/* CHAR.C -- Character-, Line-, and Screen -Oriented Commands

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

static int last_col = 0;	/* last column for ^N and ^P */

/* ------------------------------------------------------------ */

/* Move backward one character. */

void
CCharB()
	{
	BMoveBy(-uarg);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Delete backward one character. */

void
CCharBD()
	{
	BMarkToPoint(cwin->point);
	BMoveBy(-uarg);
	BRegDelete(cwin->point);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Move forward one character. */

void
CCharF()
	{
	BMoveBy(uarg);
	uarg = 0;
	}

/* ------------------------------------------------------------ */

/* Delete forward one character. */

void
CCharFD()
	{
	BCharDelete(uarg);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Transpose the previous two characters. */

void
CCharTran()
	{
	int chr;

	BMoveBy(-2);
	chr = BGetChar();
	BCharDelete(1);
	BMoveBy(1);
	BInsChar(chr);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Move to the beginning of the current line. */

void
CLineA()
	{
	if (BSearchB(NL, SNL)) BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Delete the entire current line. */

void
CLineAED()
	{
	BMarkToPoint(cwin->point);
	CLineA();
	RKillToMark(cwin->point, BACKWARD);
	SearchNLF();

		/* force append */
	lastkey = key; lasttable = table;

	RKillToMark(cwin->point, FORWARD);
	}


/* ------------------------------------------------------------ */

/* Move to the previous line. */

void
CLineB()
	{
	if (!TabIsVMove(lastkey, lasttable)) last_col = BGetCol();
	while (uarg-- > 0) SearchNLB();
	BMakeColB(last_col);
	}


/* ------------------------------------------------------------ */

/* Move to the end of the current line. */

void
CLineE()
	{
	if (BSearchF(NL, SNL)) BMoveBy(-1);
	}


/* ------------------------------------------------------------ */

/* Move to the next line. */

void
CLineF()
	{
	if (!TabIsVMove(lastkey, lasttable)) last_col = BGetCol();
	while (uarg-- > 0) SearchNLF();
	BMakeColB(last_col);
	}


/* ------------------------------------------------------------ */

/* Delete to the end of the current line. */

void
CLineFD()
	{
	BMarkToPoint(cwin->point);
	if (uarg > 0) {
		if (!BIsEnd() && IsNL())
			BMoveBy(1);
		else	CLineE();
		}
	else	CLineA();
	RKillToMark(cwin->point, uarg > 0);
	}


/* ------------------------------------------------------------ */

/* Move to the previous screen. */

void
CScrnB()
	{
	int cnt;

	BPointToMark(cwin->sstart);
	for (cnt = uarg * (DWindHeight() - VOVERLAP) - DPrefLine(); cnt > 0;
		 --cnt) {
		SearchNLB();
		}
	CLineA();
	}


/* ------------------------------------------------------------ */

/* Move the other window to the previous screen. */

void
CScrnBOW()
	{
	if (num_windows <= 1) return;
	DWindSwap();
	DIncrDisplay();
	CScrnB();
	DIncrDisplay();
	DWindSwap();
	}


/* ------------------------------------------------------------ */

/* Move to the next screen. */

void
CScrnF()
	{
	int cnt;

	DIncrDisplay();
	BPointToMark(cwin->sstart);
	for (cnt = uarg * (DWindHeight() - VOVERLAP) + DPrefLine(); cnt > 0;
		 --cnt) {
		SearchNLF();
		}
	}


/* ------------------------------------------------------------ */

/* Move the other window to the next screen. */

void
CScrnFOW()
	{
	if (num_windows <= 1) return;
	DWindSwap();
	DIncrDisplay();
	CScrnF();
	DIncrDisplay();
	DWindSwap();
	}


/* end of CHAR.C -- Character-, Line-, and Screen -Oriented Commands */
