#include "yaklib.h"
#include "yakpal.h"
#include "yakwin.h"
#include "yakfont.h"
#include "yakscrol.h"
#include "yakpanel.h"
#include "xrect.h"
#include <conio.h>
#include <string.h>
#include <alloc.h>

#define C_QUIT 1
#define C_ICON 2
#define C_ANIMICON 3
#define C_ANIMAP_REG 4
#define C_ANIMAP_FAST 5
#define C_MOUSE_JSTCK 6
#define C_WINDOWS 7
#define C_GADGETS 8
#define C_YAKLIBS 9
#define C_SOUNDS 10
#define C_PALETTES 11
#define C_FONTS 12
#define C_SUPPORT 13
#define C_BUTTONPRESS 14
#define C_LABELPRESS 15
#define C_AFTER 16

void stars(void);
void iconDemo(void);
void animDemo(void);
void amapDemo(void);
void beetDemo(void);

yakLib myYakLib("yakdemo");
yakLib sb1Lib("yakdemo");
yakScroller buttonScroller(10,10,110,100, (char *)myYakLib.loadToMem("button.txt"));
yakScroller labelScroller(20,20,120,110, (char *)myYakLib.loadToMem("label.txt"));
yakScroller myYakScroller(0,0,210,111, (char *)myYakLib.loadToMem("welcome.txt"));
yakPanel newYakPanel(0,0,100,100);
yakPanel mainMenu(0,0,110,200);
yakFont myYakFont("6x8b.fnt", &myYakLib);
yakPalette myYakPalette("standard.ypl", &myYakLib);
icon yakLogo;

void resetScreen(void)
{
  static char * adjectives[8] = {"power.", "compatibility.", "versatility.", "usefulness.",
                              "cost.", "artistry.", "value.", "simplicity."};
  static int sloganCounter;
  mouse.hide();
  char slogan[80];
  strcpy(slogan, "The difference is...");
  strcat(slogan, adjectives[sloganCounter++ % 8]);
  x_set_mode(0,340);
  x_rect_fill(0,0,320,200,VisiblePageOffs,0);
  myYakFont.use();
  myYakPalette.put();
  yakLogo.showMasked(134,30,VisiblePageOffs);
  x_printf(212 - (strlen(slogan)*CharWidth/2), 80, VisiblePageOffs, 15, slogan);
  yakWindow::drawAll();
  mainMenu.shuffleToTop();
  yakWindow::activeWindow = &mainMenu;
  mouse.show();
}


void main(int argCount, char ** argVector)
{
  x_set_mode(0,340);
  x_text_init();
  yakLogo.load("yax.yak", icon::normal, &myYakLib);
  stars();
  resetScreen();
  strcpy(myYakScroller.title, "Welcome!");
  myYakScroller.activate(50,50);
  strcpy(mainMenu.title, "Main Menu");
  mainMenu.myFlags &= ~(yakWindow::isCloseable | yakWindow::isDraggable);
  mainMenu.add(new gadgetNode(new label(2,10,'Q', C_QUIT, "Quit demo", 15, 0),
               new gadgetNode(new label(2,20,'!', C_ICON, "Icons", 15, 0),
               new gadgetNode(new label(2,30,'!', C_ANIMICON, "Animicons", 15, 0),
               new gadgetNode(new label(2,40,'!', C_ANIMAP_REG, "Animaps (regular)", 15, 0),
               new gadgetNode(new label(2,50,'!', C_ANIMAP_FAST, "Animaps (smart)", 15, 0),
               new gadgetNode(new label(2,60,'!', C_MOUSE_JSTCK, "Mouse/Jstick/Kbd", 15, 0),
               new gadgetNode(new label(2,70,'!', C_WINDOWS, "Windows",15, 0),
               new gadgetNode(new label(2,80,'!', C_GADGETS, "Gadgets", 15, 0),
               new gadgetNode(new label(2,90,'!', C_YAKLIBS, "yakLibs", 15, 0),
               new gadgetNode(new label(2,100,'!',C_SOUNDS, "Sound Support", 15,0),
               new gadgetNode(new label(2,110,'!',C_PALETTES, "Palettes", 15, 0),
               new gadgetNode(new label(2,120,'!',C_FONTS, "Fonts", 15, 0),
               new gadgetNode(new label(2,130,'!',C_SUPPORT, "Support Programs", 15, 0),
               new gadgetNode(new label(2,140,'!',C_AFTER, "Afterword", 15,0),
               NULL)))))))))))))));
  strcpy(newYakPanel.title, "Demo yakPanel!");
  newYakPanel.x = 170;
  newYakPanel.y = 50;
  newYakPanel.add(new gadgetNode(new pSwitch(2,10,'!',"light",icon::normal, &myYakLib),
                   new gadgetNode(new pSwitch(18,10,'!',"light", icon::normal, &myYakLib),
                   new gadgetNode(new pSwitch(34,10,'!',"light", icon::normal, &myYakLib),
                   new gadgetNode(new pSwitch(49,10,'!',"toggl", icon::normal, &myYakLib),
                   new gadgetNode(new pSwitch(65,10,'!',"toggl", icon::normal, &myYakLib),
                   new gadgetNode(new pSwitch(81,10,'!',"toggl", icon::normal, &myYakLib),
                   new gadgetNode(new pSwitch(2,60, '!',"grumjug", icon::normal, &myYakLib, gadget::touchPad),
                   new gadgetNode(new slider(2,26,50,10,0,100),
                   new gadgetNode(new slider(2,37,50,15,0,100,36,10,47),
                   new gadgetNode(new button(2,80,'1',C_BUTTONPRESS, "button", icon::normal, &myYakLib),
                   new gadgetNode(new label(35,85,'2',C_LABELPRESS, "Press Me!", 1, 47),
                   NULL))))))))))));

  mainMenu.open();
  mouse.init();
  resetScreen();
  int command = 0;
  while (command != C_QUIT)
  {
    if (argVector[1][0] == '+')
      x_bgprintf(2,180,VisiblePageOffs,15,0,"Free Mem: %ld  ",coreleft());
    command = yakWindow::advance();
    switch(command)
    {
      case C_BUTTONPRESS: buttonScroller.shuffleToTop(); break;
      case C_LABELPRESS : labelScroller.shuffleToTop(); break;
      case C_ICON : mouse.hide();
                    myYakScroller.newText(myYakLib.loadToMem("icon.txt"));
                    strcpy(myYakScroller.title, "The Icon class");
                    myYakScroller.activate(50,50);
                    iconDemo();
                    resetScreen();
                    mouse.show();
                    break;
      case C_ANIMICON : mouse.hide();
                    myYakScroller.newText((char *)myYakLib.loadToMem("animicon.txt"));
                    strcpy(myYakScroller.title, "The Animicon Class");
                    myYakScroller.activate(50,50);
                    animDemo();
                    resetScreen();
                    mouse.show();
                    break;
      case C_ANIMAP_REG : mouse.hide();
                    myYakScroller.newText((char *)myYakLib.loadToMem("animap.txt"));
                    strcpy(myYakScroller.title, "Animaps (regular)");
                    myYakScroller.activate(50,50);
                    amapDemo();
                    resetScreen();
                    mouse.show();
                    break;
      case C_ANIMAP_FAST : mouse.hide();
                    myYakScroller.newText((char *)myYakLib.loadToMem("beetdemo.txt"));
                    strcpy(myYakScroller.title, "Animaps (smart)");
                    myYakScroller.activate(50,50);
                    beetDemo();
                    resetScreen();
                    mouse.show();
                    break;
      case C_MOUSE_JSTCK : myYakScroller.newText((char *)myYakLib.loadToMem("mjstk.txt"));
                    strcpy(myYakScroller.title, "Mouse/Joystick/Keyboard");
                    myYakScroller.activate(50,50);
                    break;
      case C_WINDOWS : myYakScroller.newText((char *)myYakLib.loadToMem("windows.txt"));
                    strcpy(myYakScroller.title, "yakWindows");
                    myYakScroller.activate(50,50);
                    for (int windowCounter = 0; windowCounter < 5; ++windowCounter)
                    {
                      yakScroller * newScroller = new yakScroller(100+random(50), 50+random(50), 250+random(50), 120 + random(50), (char *)myYakLib.loadToMem("windemo.txt"));
                      strcpy(newScroller->title, "Demo Window!");
                      newScroller->titleBarColor = random(256);
                      newScroller->textColor = random(256);
                      newScroller->boxColor = random(256);
                      newScroller->myFlags |= yakWindow::isTemporary;
                      newScroller->open();
                    }
                    break;
      case C_GADGETS : myYakScroller.newText((char *)myYakLib.loadToMem("gadgets.txt"));
                    strcpy(myYakScroller.title, "Gadgets");
                    myYakScroller.activate(50,50);
                    newYakPanel.shuffleToTop();
                    break;
      case C_YAKLIBS : myYakScroller.newText((char *)myYakLib.loadToMem("yaklibs.txt"));
                    strcpy(myYakScroller.title, "yakLibs");
                    myYakScroller.activate(50,50);
                    break;
      case C_SOUNDS : myYakScroller.newText((char *)myYakLib.loadToMem("sounds.txt"));
                    strcpy(myYakScroller.title, "Sounds");
                    myYakScroller.activate(50,50);
                    break;
      case C_PALETTES : myYakScroller.newText((char *)myYakLib.loadToMem("yakpal.txt"));
                    strcpy(myYakScroller.title, "yakPalettes");
                    myYakScroller.activate(50,50);
                    yakPalette demoYakPalette("standard.ypl", &myYakLib);
                    while (!kbhit())
                    {
                      demoYakPalette.rotate(yakPalette::down);
                      demoYakPalette.put();
                    }
                    myYakPalette.put();
                    break;
      case C_FONTS : myYakScroller.newText((char *)myYakLib.loadToMem("fonts1.txt"));
                    strcpy(myYakScroller.title, "yakFonts");
                    myYakScroller.activate(50,50);
                    yakFont demoFont("morning.fnt", &myYakLib);
                    demoFont.use();
                    myYakScroller.newText((char *)myYakLib.loadToMem("fonts2.txt"));
                    myYakScroller.activate(50,50);
                    myYakFont.use();
                    break;
      case C_SUPPORT : myYakScroller.newText((char *)myYakLib.loadToMem("support.txt"));
                    strcpy(myYakScroller.title, "Support Programs");
                    myYakScroller.activate(50,50);
                    break;
      case C_AFTER : myYakScroller.newText((char *)myYakLib.loadToMem("after.txt"));
                    strcpy(myYakScroller.title, "Afterword");
                    myYakScroller.activate(50,50);
                    break;
    }
  }
  mouse.remove();
  x_text_mode();
}