#include "stddefs.h"
#include "yakLib.h"
#include "yakwin.h"
#include "xlib.h"
#include "xtext.h"

class yakFont
{
public:
  word startChar; //ascii code of first character in font
  byte charHeight; //height of characters
  byte charWidth;  //width of characters
  byte *fontData; //data for characters in font, includes first three items
		  //(ie character data starts at fontData[4])
  byte numberOfChars;
  yakFont(int iStartChar, int iCharWidth, int iCharHeight, int numChars)
    {startChar = iStartChar; charWidth = iCharWidth; charHeight = iCharHeight; fontData = new byte[(int)numChars * (int)charHeight + 4];};
  yakFont(void) {startChar = 0; charHeight = charWidth = 0; fontData = NULL; numberOfChars = 0;};
  void load(char * filename, yakLib * myYakLib = NULL);
  yakFont(char * filename, yakLib * myYakLib = NULL) {fontData = NULL; load(filename, myYakLib);};
  void registerMe(void);
  void save(char * filename);
  void use(void);
};

