#define YAKMOUSEUNIT

#include "xlib.h"
#include "yakmouse.h"
#include "xmouse.h"

/*
00000010 2
00000111 7
00001111 15
00011111 31
00111111 63
00001100 12
00011000 24
00110000 48
00000000
00000000
00000000
00000000
00000000
00000000
00000000
*/

unsigned char standardMouse[] = {2, 7, 15, 31, 63, 12, 24, 48,0,0,0,0,0,0};

yakMouse mouse;

void yakMouse::beStandardMouse(void)
{
  x_define_mouse_cursor(standardMouse, 15);
}

void yakMouse::init(void)
{
  x_mouse_init();
  beStandardMouse();
  show();
}

void yakMouse::remove(void)
{
  x_mouse_remove();
}

void yakMouse::show(void)
{
  x_show_mouse();
}

void yakMouse::hide(void)
{
  x_hide_mouse();
}

void yakMouse::setImage(char * mouseDef, int color)
{
  x_define_mouse_cursor(mouseDef, color);
}

word yakMouse::x(void)
{
  return MouseX;
}

word yakMouse::y(void)
{
  return MouseY;
}


void yakMouse::display(int x, int y, int topclip, int botclip, word offset)
{
  x_put_cursor(x, y, topclip, botclip, offset);
}

//word yakMouse::numberOfButtons(void)
//{
//  return x_mouse_nbuts;
//}

word yakMouse::buttonStatus(void)
{
  return MouseButtonStatus;
}

byte yakMouse::isPressed(buttonType myButtons)
{
  return (MouseButtonStatus & myButtons);
}

byte yakMouse::isClicked(buttonType myButtons)
{
  static buttonType oldButtons;
  buttonType newButtons = (MouseButtonStatus & myButtons);
  if (myButtons == reset)
  {
    oldButtons = noButtons;
    return 0;
  }
  if (newButtons == noButtons)
  {
    oldButtons = noButtons;		//no buttons at all
    return 0;
  }
  else if (newButtons == oldButtons)  //something's held down..
    return 0;
  else
  {
    oldButtons = newButtons;		//a new button is pressed.
    return (newButtons);
  }
}

byte yakMouse::isInBox(int x1, int y1, int x2, int y2)
{
  return (((MouseX >= x1) && (MouseX <= x2)) &&
	  ((MouseY >= y1) && (MouseY <= y2)));
}