/*****************************************************************************
 VGLLINE.C

 vglLine( int x1, int y1, int x2, int y2, int c );

 Draws a line from x1,y1 to x2,y2 in the color c.  Fairly quick, even though
 it's in C.  Original algorithm from Graphics Gems.  This is an *excellent*
 general purpose Bresanham line tracing routine!

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

 #include "vgl.h"

#define ABS(a)   ((a < 0) ? -a : a)
#define SGN(a)   ((a < 0) ? -1 : 1)

vglLine( int x1, int y1, int x2, int y2, int c )
{
   int d, x, y, ax, ay, sx, sy, dx, dy;

   dx = x2-x1;
   ax = ABS(dx) << 1;
   sx = SGN(dx);
   dy = y2-y1;
   ay = ABS(dy) << 1;
   sy = SGN(dy);

   x = x1;
   y = y1;
   if( ax > ay )
   {
      d = ay - (ax >> 1);
      while( x != x2 )
      {
         vglPutPel( x, y, c );
	 if( d >= 0 )
         {
            y += sy;
	    d -= ax;
         }
	 x += sx;
	 d += ay;
      }
   }
   else
   {
      d = ax - (ay >> 1);
      while( y != y2 )
      {
         vglPutPel( x, y, c );
	 if( d >= 0 )
         {
            x += sx;
	    d -= ay;
         }
	 y += sy;
	 d += ax;
      }
   }
   return 0;
}
