#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include "xlib_all.h"
#define TITLE "LBM2CBM - Linear to Compiled bitmap conversion utility    T. Gouthas 20/11/92\n"
#define SRC_EXT ".LBM"
#define DEST_EXT ".CBM"

int convert(char *filenamein, char *filenameout);
void syntax();

typedef struct _lbm_struc {
  unsigned char width;
  unsigned char height;
  unsigned char data[];
} far *LBM_PTR;

unsigned ScrnLogicalByteWidth;

#define BUFF_LEN 100
size_t farfread(void far *destptr,size_t size, size_t n, FILE *fp){
   unsigned len;
   unsigned char buff[BUFF_LEN];
   len=size*n;
   while(len >=BUFF_LEN){
     fread(buff,BUFF_LEN,1,fp);
     movedata((unsigned)_DS,(unsigned)buff,FP_SEG(destptr),FP_OFF(destptr),BUFF_LEN);
     len-=BUFF_LEN;
     (char far *)destptr+=BUFF_LEN;
   }
   if (len>0){
     fread(buff,len,1,fp);
     movedata((unsigned)_DS,(unsigned)buff,FP_SEG(destptr),FP_OFF(destptr),len);
   }
};

size_t farfwrite(void far *srcptr,size_t size, size_t n, FILE *fp){
   unsigned len;
   unsigned char buff[BUFF_LEN];
   len=size*n;
   while(len >=BUFF_LEN){
     movedata(FP_SEG(srcptr),FP_OFF(srcptr),(unsigned)_DS,(unsigned)buff,BUFF_LEN);
     fwrite(buff,BUFF_LEN,1,fp);
     len-=BUFF_LEN;
     (char far *)srcptr+=BUFF_LEN;
   }
   if (len>0){
     movedata(FP_SEG(srcptr),FP_OFF(srcptr),(unsigned)_DS,(unsigned)buff,len);
     fwrite(buff,len,1,fp);
   }
};


int convert(char *filenamein, char *filenameout){
  static char far *ibuff=NULL, far *obuff=NULL;
  static unsigned isize=0, osize=0;
  unsigned width,height;
  FILE *fi, *fo;
  char far * farchptr;
  unsigned infilesize,outfilesize;
  fi=fopen(filenamein,"rb+");
  if(!fi) return 0;
  fo=fopen(filenameout,"wb+");
  if (!fo) {
    fclose(fi);
    return 0;
  }
  fseek(fi,0,SEEK_END);
  infilesize = (unsigned) ftell(fi);
  fseek(fi,0,SEEK_SET);
  if (ibuff==NULL){
    ibuff=farmalloc(infilesize);
    if (ibuff==NULL) goto error;
    isize=infilesize;
  } else {
    farchptr=farrealloc(ibuff,infilesize);
    if (farchptr==NULL) goto error;
    ibuff=farchptr;
    isize=infilesize;
  }
  farfread(ibuff,infilesize,1,fi);
  if ferror(fi) goto error;
  outfilesize=x_sizeof_cbitmap(ScrnLogicalByteWidth,ibuff);
  if (obuff==NULL){
    obuff=farmalloc(outfilesize);
    if (obuff==NULL) goto error;
    osize=outfilesize;
  } else {
    farchptr=farrealloc(obuff,outfilesize);
    if (farchptr==NULL) goto error;
    obuff=farchptr;
    osize=outfilesize;
  }
  if(osize!=x_compile_bitmap(ScrnLogicalByteWidth,ibuff,obuff)){
    printf("Compilation Size Mismatch: BUG !!\n");
  }
  farfwrite(obuff,osize,1,fo);
  if ferror(fo) goto error;
  fclose(fi);
  fclose(fo);
  return 1;
error:
  fclose(fi);
  fclose(fo);
  return 0;
}

void syntax(){
  printf("\n LBM2CBM <Logical scrn width> <filespec> [ <filespec> ..] \n\n");
  exit(0);
}

void main(int argc, char *argv[]){
   int  i;
   char *dotptr;
   char *tempptr;
   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char name[MAXFILE];
   char ext[MAXEXT];
   char filenameraw[100];
   char filenamewild[100];
   char filenamein[100];
   char filenameout[100];
   struct ffblk ffb;
   printf(TITLE);
   if (argc<3) syntax();
   sscanf(argv[1],"%ud",&ScrnLogicalByteWidth);
   for (i=2;i<argc;i++){
     strupr(argv[i]);
     strcpy(filenamewild,argv[i]);
     printf("\nConverting files matching \"%s\".\n",argv[i]);

     fnsplit(filenamewild,drive,dir,NULL,ext);
     if (*ext=='\0') strcat(filenamewild,SRC_EXT);

     if(findfirst(filenamewild,&ffb,0)){
       printf("No files found.\n");
       exit(1);
     }
     do {
       fnsplit(ffb.ff_name,NULL,NULL,name,ext);
       if (strcmp(ext,SRC_EXT)){
	 printf("Skipping  : %12s -> incorrect type.\n",ffb.ff_name);
       } else {
	 fnmerge(filenamein,drive,dir,name,ext);
	 fnmerge(filenameout,drive,dir,name,DEST_EXT);
	 printf("Converting: %12s -> %12s  ",filenamein,filenameout);
	 if (convert(filenamein,filenameout)) printf("OK\n");
	 else printf("FAILED\n");
       }
     } while(!findnext(&ffb));
   }
}