/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_43 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 31992, "epsg", 31992,
        "SIRGAS 1995 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31992\"]]");
    p = add_epsg_def_ex (filter, first, last, 31993, "epsg", 31993,
        "SIRGAS 1995 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31993\"]]");
    p = add_epsg_def_ex (filter, first, last, 31994, "epsg", 31994,
        "SIRGAS 1995 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31994\"]]");
    p = add_epsg_def_ex (filter, first, last, 31995, "epsg", 31995,
        "SIRGAS 1995 / UTM zone 20S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31995\"]]");
    p = add_epsg_def_ex (filter, first, last, 31996, "epsg", 31996,
        "SIRGAS 1995 / UTM zone 21S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31996\"]]");
    p = add_epsg_def_ex (filter, first, last, 31997, "epsg", 31997,
        "SIRGAS 1995 / UTM zone 22S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31997\"]]");
    p = add_epsg_def_ex (filter, first, last, 31998, "epsg", 31998,
        "SIRGAS 1995 / UTM zone 23S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 23S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-4");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31998\"]]");
    p = add_epsg_def_ex (filter, first, last, 31999, "epsg", 31999,
        "SIRGAS 1995 / UTM zone 24S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 24S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"31999\"]]");
    p = add_epsg_def_ex (filter, first, last, 32000, "epsg", 32000,
        "SIRGAS 1995 / UTM zone 25S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 25S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"32000\"]]");
    p = add_epsg_def_ex (filter, first, last, 32001, "epsg", 32001,
        "NAD27 / Montana North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.71666666666667 +lat_2=47.85 +lat_0=4");
    add_proj4text (p, 1,
        "7 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",48.71666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",47.85],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 10,
        "rigin\",47],PARAMETER[\"central_meridian\",-109.5],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",2000000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"32001\"]]");
    p = add_epsg_def_ex (filter, first, last, 32002, "epsg", 32002,
        "NAD27 / Montana Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.88333333333333 +lat_2=46.45 +lat_0=4");
    add_proj4text (p, 1,
        "5.83333333333334 +lon_0=-109.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",47.88333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",46.45],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",45.83333333333334],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 11,
        "n\",-109.5],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 13,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32002\"]]");
    p = add_epsg_def_ex (filter, first, last, 32003, "epsg", 32003,
        "NAD27 / Montana South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.4 +lat_2=44.86666666666667 +lat_0=44");
    add_proj4text (p, 1,
        " +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana South\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",46.4],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",44.86666666666667],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 10,
        "igin\",44],PARAMETER[\"central_meridian\",-109.5],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",2000000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"32003\"]]");
    p = add_epsg_def_ex (filter, first, last, 32005, "epsg", 32005,
        "NAD27 / Nebraska North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.85 +lat_2=42.81666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "1.33333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",41.85],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",42.81666666666667],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 10,
        "origin\",41.33333333333334],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",-100],PARAMETER[\"false_easting\",2000000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32005\"]]");
    p = add_epsg_def_ex (filter, first, last, 32006, "epsg", 32006,
        "NAD27 / Nebraska South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.28333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.66666666666666 +lon_0=-99.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",40.28333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",41.71666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",39.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-99.5],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3200");
    add_srs_wkt (p, 15,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 32007, "epsg", 32007,
        "NAD27 / Nevada East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",34.75],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "15.5833333333333],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"32007\"]]");
    p = add_epsg_def_ex (filter, first, last, 32008, "epsg", 32008,
        "NAD27 / Nevada Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada Central\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",34.75],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-116.6666666666667],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32008\"]]");
    p = add_epsg_def_ex (filter, first, last, 32009, "epsg", 32009,
        "NAD27 / Nevada West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",34.75],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "18.5833333333333],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"32009\"]]");
    p = add_epsg_def_ex (filter, first, last, 32010, "epsg", 32010,
        "NAD27 / New Hampshire", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Hampshire\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",42.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "71.66666666666667],PARAMETER[\"scale_factor\",0.99996666");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32010\"]]");
    p = add_epsg_def_ex (filter, first, last, 32011, "epsg", 32011,
        "NAD27 / New Jersey", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.66666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999749999999999 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Jersey\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",38.83333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-74.66666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999975],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32011\"]]");
    p = add_epsg_def_ex (filter, first, last, 32012, "epsg", 32012,
        "NAD27 / New Mexico East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico East\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",31],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "104.3333333333333],PARAMETER[\"scale_factor\",0.99990909");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32012\"]]");
    p = add_epsg_def_ex (filter, first, last, 32013, "epsg", 32013,
        "NAD27 / New Mexico Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=1524");
    add_proj4text (p, 1,
        "00.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico Central\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-106.25],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"32013\"]]");
    p = add_epsg_def_ex (filter, first, last, 32014, "epsg", 32014,
        "NAD27 / New Mexico West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico West\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",31],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "107.8333333333333],PARAMETER[\"scale_factor\",0.99991666");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32014\"]]");
    p = add_epsg_def_ex (filter, first, last, 32015, "epsg", 32015,
        "NAD27 / New York East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-74.33333333333333 +k=0.999");
    add_proj4text (p, 1,
        "966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",40],PARAMETER[\"central_meridian\",-74");
    add_srs_wkt (p, 9,
        ".33333333333333],PARAMETER[\"scale_factor\",0.999966667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32015\"]]");
    p = add_epsg_def_ex (filter, first, last, 32016, "epsg", 32016,
        "NAD27 / New York Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",40],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "76.58333333333333],PARAMETER[\"scale_factor\",0.9999375]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32016\"]]");
    p = add_epsg_def_ex (filter, first, last, 32017, "epsg", 32017,
        "NAD27 / New York West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",40],PARAMETER[\"central_meridian\",-78");
    add_srs_wkt (p, 9,
        ".58333333333333],PARAMETER[\"scale_factor\",0.9999375],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"32017\"]]");
    p = add_epsg_def_ex (filter, first, last, 32018, "epsg", 32018,
        "NAD27 / New York Long Island (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=304800.6096012192 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_");
    add_srs_wkt (p, 8,
        "Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.033333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"standard_parallel_2\",40.666666666");
    add_srs_wkt (p, 10,
        "66666],PARAMETER[\"latitude_of_origin\",40.5],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-74],PARAMETER[\"false_easting\",10");
    add_srs_wkt (p, 12,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "32018\"]]");
    p = add_epsg_def_ex (filter, first, last, 32019, "epsg", 32019,
        "NAD27 / North Carolina", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.33333333333334 +lat_2=36.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Carolina\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",34.33333333333334],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",36.16666666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",33.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",-79],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32019\"]]");
    p = add_epsg_def_ex (filter, first, last, 32020, "epsg", 32020,
        "NAD27 / North Dakota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.43333333333333 +lat_2=48.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",47.43333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",48.73333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",47],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",-100.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32020\"]]");
    p = add_epsg_def_ex (filter, first, last, 32021, "epsg", 32021,
        "NAD27 / North Dakota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.18333333333333 +lat_2=47.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",46.18333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",47.48333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",45.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-100.5],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 12,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "32021\"]]");
    p = add_epsg_def_ex (filter, first, last, 32022, "epsg", 32022,
        "NAD27 / Ohio North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.43333333333333 +lat_2=41.7 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",40.43333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",41.7],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",39.66666666666666],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 11,
        "2.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32022\"]]");
    p = add_epsg_def_ex (filter, first, last, 32023, "epsg", 32023,
        "NAD27 / Ohio South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.73333333333333 +lat_2=40.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",38.73333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",40.03333333333333],PARAMETER[\"lati");
    add_srs_wkt (p, 10,
        "tude_of_origin\",38],PARAMETER[\"central_meridian\",-82.");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32023\"]]");
    p = add_epsg_def_ex (filter, first, last, 32024, "epsg", 32024,
        "NAD27 / Oklahoma North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.56666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",35.56666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",36.76666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",35],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-98],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32024\"]]");
    p = add_epsg_def_ex (filter, first, last, 32025, "epsg", 32025,
        "NAD27 / Oklahoma South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.93333333333333 +lat_2=35.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",33.93333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",35.23333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",33.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-98],PARAMETER[\"false_easting\",2000000]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32025\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32026, "epsg", 32026,
        "NAD27 / Oregon North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.33333333333334 +lat_2=46 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",44.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",46],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",43.66666666666666],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 11,
        "0.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32026\"]]");
    p = add_epsg_def_ex (filter, first, last, 32027, "epsg", 32027,
        "NAD27 / Oregon South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.33333333333334 +lat_2=44 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",42.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",44],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",41.66666666666666],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 11,
        "0.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32027\"]]");
    p = add_epsg_def_ex (filter, first, last, 32028, "epsg", 32028,
        "NAD27 / Pennsylvania North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.88333333333333 +lat_2=41.95 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",40.88333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",41.95],PARAMETER[\"latitude_");
    add_srs_wkt (p, 10,
        "of_origin\",40.16666666666666],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-77.75],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32028\"]]");
    p = add_epsg_def_ex (filter, first, last, 32029, "epsg", 32029,
        "NAD27 / Pennsylvania South (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.93333333333333 +lat_2=40.8 +lat_0=39");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",39.9333333333");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"standard_parallel_2\",40.8],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"latitude_of_origin\",39.33333333333334],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-77.75],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 13,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "2029\"]]");
    p = add_epsg_def_ex (filter, first, last, 32030, "epsg", 32030,
        "NAD27 / Rhode Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "999938 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Rhode Island\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",41.08333333333334],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-71.5],PARAMETER[\"scale_factor\",0.9999938],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"32030\"]]");
    p = add_epsg_def_ex (filter, first, last, 32031, "epsg", 32031,
        "NAD27 / South Carolina North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.76666666666667 +lat_2=34.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=33 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina North\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",33.76666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",34.96666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",33],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-81],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32031\"]]");
    p = add_epsg_def_ex (filter, first, last, 32033, "epsg", 32033,
        "NAD27 / South Carolina South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.33333333333334 +lat_2=33.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina South\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",32.33333333333334],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",33.66666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",31.83333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-81],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 12,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "32033\"]]");
    p = add_epsg_def_ex (filter, first, last, 32034, "epsg", 32034,
        "NAD27 / South Dakota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41666666666666 +lat_2=45.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43.83333333333334 +lon_0=-100 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",44.41666666666666],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",45.68333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",43.83333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-100],PARAMETER[\"false_easting\",2000");
    add_srs_wkt (p, 12,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 13,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32");
    add_srs_wkt (p, 15,
        "034\"]]");
    p = add_epsg_def_ex (filter, first, last, 32035, "epsg", 32035,
        "NAD27 / South Dakota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.83333333333334 +lat_2=44.4 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",42.83333333333334],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",44.4],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_origin\",42.33333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",-100.3333333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 13,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "2035\"]]");
    p = add_epsg_def_ex (filter, first, last, 32036, "epsg", 32036,
        "NAD27 / Tennessee (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
        "4.66666666666666 +lon_0=-86 +x_0=30480.06096012192 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Tennessee (deprecated)\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",35.25],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",36.41666666666666],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",34.66666666666666],PARAMETER[\"central_me");
    add_srs_wkt (p, 11,
        "ridian\",-86],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 13,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 14,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32036\"]]");
    p = add_epsg_def_ex (filter, first, last, 32037, "epsg", 32037,
        "NAD27 / Texas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",34.65],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_2\",36.18333333333333],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",34],PARAMETER[\"central_meridian\",-101.5],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",2000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"32037\"]]");
    p = add_epsg_def_ex (filter, first, last, 32038, "epsg", 32038,
        "NAD27 / Texas North Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.13333333333333 +lat_2=33.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=31.66666666666667 +lon_0=-97.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",32.13333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",33.96666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",31.66666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-97.5],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 13,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "2038\"]]");
    p = add_epsg_def_ex (filter, first, last, 32039, "epsg", 32039,
        "NAD27 / Texas Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.11666666666667 +lat_2=31.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",30.11666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",31.88333333333333],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",29.66666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-100.3333333333333],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"32039\"]]");
    p = add_epsg_def_ex (filter, first, last, 32040, "epsg", 32040,
        "NAD27 / Texas South Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.38333333333333 +lat_2=30.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",28.38333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",30.28333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",27.83333333333333],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-99],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 12,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 13,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 15,
        "40\"]]");
    p = add_epsg_def_ex (filter, first, last, 32041, "epsg", 32041,
        "NAD27 / Texas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.16666666666667 +lat_2=27.83333333333");
    add_proj4text (p, 1,
        "333 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",26.16666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",27.83333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",25.66666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-98.5],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32041\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32042, "epsg", 32042,
        "NAD27 / Utah North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.71666666666667 +lat_2=41.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",40.71666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",41.78333333333333],PARAMETER[\"lati");
    add_srs_wkt (p, 10,
        "tude_of_origin\",40.33333333333334],PARAMETER[\"central_");
    add_srs_wkt (p, 11,
        "meridian\",-111.5],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32042\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32043, "epsg", 32043,
        "NAD27 / Utah Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.01666666666667 +lat_2=40.65 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah Central\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",39.01666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",40.65],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",38.33333333333334],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-111.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32043\"]]");
    p = add_epsg_def_ex (filter, first, last, 32044, "epsg", 32044,
        "NAD27 / Utah South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.21666666666667 +lat_2=38.35 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",37.21666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",38.35],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 10,
        "in\",36.66666666666666],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 11,
        "111.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32044\"]]");
    p = add_epsg_def_ex (filter, first, last, 32045, "epsg", 32045,
        "NAD27 / Vermont", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Vermont\",GEOGCS[\"NAD27\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",42.5],PARAMETER[\"central_meridian\",-72.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.999964286],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"32045\"]]");
    p = add_epsg_def_ex (filter, first, last, 32046, "epsg", 32046,
        "NAD27 / Virginia North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.03333333333333 +lat_2=39.2 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",38.03333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",39.2],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 10,
        "rigin\",37.66666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-78.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32046\"]]");
    p = add_epsg_def_ex (filter, first, last, 32047, "epsg", 32047,
        "NAD27 / Virginia South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",36.76666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",37.96666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",36.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-78.5],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3204");
    add_srs_wkt (p, 15,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 32048, "epsg", 32048,
        "NAD27 / Washington North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.5 +lat_2=48.73333333333333 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington North\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",47.5],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",48.73333333333333],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 10,
        "origin\",47],PARAMETER[\"central_meridian\",-120.8333333");
    add_srs_wkt (p, 11,
        "333333],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32048\"]]");
    p = add_epsg_def_ex (filter, first, last, 32049, "epsg", 32049,
        "NAD27 / Washington South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.83333333333334 +lat_2=47.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington South\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",45.83333333333334],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",47.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",45.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-120.5],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 12,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 13,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 15,
        "49\"]]");
    p = add_epsg_def_ex (filter, first, last, 32050, "epsg", 32050,
        "NAD27 / West Virginia North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39 +lat_2=40.25 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia North\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",39],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",40.25],PARAMETER[\"latitude_of_origin\",38.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"central_meridian\",-79.5],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",2000000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
        "IT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"32050\"]]");
    p = add_epsg_def_ex (filter, first, last, 32051, "epsg", 32051,
        "NAD27 / West Virginia South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.48333333333333 +lat_2=38.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia South\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",37.48333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",38.88333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",37],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",-81],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32051\"]]");
    p = add_epsg_def_ex (filter, first, last, 32052, "epsg", 32052,
        "NAD27 / Wisconsin North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.56666666666667 +lat_2=46.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",45.56666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",46.76666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",45.16666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-90],PARAMETER[\"false_easting\",2000000]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32052\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32053, "epsg", 32053,
        "NAD27 / Wisconsin Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.25 +lat_2=45.5 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",44.25],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_2\",45.5],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 10,
        "3.83333333333334],PARAMETER[\"central_meridian\",-90],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",2000000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"32053\"]]");
    p = add_epsg_def_ex (filter, first, last, 32054, "epsg", 32054,
        "NAD27 / Wisconsin South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.73333333333333 +lat_2=44.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=42 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",42.73333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",44.06666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",42],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-90],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32054\"]]");
    p = add_epsg_def_ex (filter, first, last, 32055, "epsg", 32055,
        "NAD27 / Wyoming East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-105.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",40.66666666666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-105.1666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999941177],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32055\"]]");
    p = add_epsg_def_ex (filter, first, last, 32056, "epsg", 32056,
        "NAD27 / Wyoming East Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-107.3333333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",40.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-107.3333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.999941177],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3205");
    add_srs_wkt (p, 14,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 32057, "epsg", 32057,
        "NAD27 / Wyoming West Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-108.75 +k=0");
    add_proj4text (p, 1,
        ".999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming West Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",40.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-108.75],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999941177],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32057\"]]");
    p = add_epsg_def_ex (filter, first, last, 32058, "epsg", 32058,
        "NAD27 / Wyoming West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-110.0833333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",40.66666666666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-110.0833333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999941177],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32058\"]]");
    p = add_epsg_def_ex (filter, first, last, 32061, "epsg", 32061,
        "NAD27 / Guatemala Norte (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Guatemala Norte (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"latitude_of_origin\",16.81666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-90.33333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.99992226],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",500000],PARAMETER[\"false_northing\",292209.579],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32061\"]]");
    p = add_epsg_def_ex (filter, first, last, 32062, "epsg", 32062,
        "NAD27 / Guatemala Sur (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333");
    add_proj4text (p, 1,
        "333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +datum=N");
    add_proj4text (p, 2,
        "AD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Guatemala Sur (deprecated)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"latitude_of_origin\",14.9],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-90.33333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.99989906],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",325992.681],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32062\"]]");
    p = add_epsg_def_ex (filter, first, last, 32064, "epsg", 32064,
        "NAD27 / BLM 14N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 14N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-99");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",1640416.67],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32064\"]]");
    p = add_epsg_def_ex (filter, first, last, 32065, "epsg", 32065,
        "NAD27 / BLM 15N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 15N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-93");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",1640416.67],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32065\"]]");
    p = add_epsg_def_ex (filter, first, last, 32066, "epsg", 32066,
        "NAD27 / BLM 16N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 16N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-87");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",1640416.67],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32066\"]]");
    p = add_epsg_def_ex (filter, first, last, 32067, "epsg", 32067,
        "NAD27 / BLM 17N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 17N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-81");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",1640416.67],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32067\"]]");
    p = add_epsg_def_ex (filter, first, last, 32074, "epsg", 32074,
        "NAD27 / BLM 14N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 14N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1640416.67],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"32074\"]]");
    p = add_epsg_def_ex (filter, first, last, 32075, "epsg", 32075,
        "NAD27 / BLM 15N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 15N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1640416.67],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"32075\"]]");
    p = add_epsg_def_ex (filter, first, last, 32076, "epsg", 32076,
        "NAD27 / BLM 16N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 16N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1640416.67],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"32076\"]]");
    p = add_epsg_def_ex (filter, first, last, 32077, "epsg", 32077,
        "NAD27 / BLM 17N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 17N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1640416.67],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"32077\"]]");
    p = add_epsg_def_ex (filter, first, last, 32081, "epsg", 32081,
        "NAD27 / MTM zone 1", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 1\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",0],PARAMETER[\"central_meridian\",-53],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",304800],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32081\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32082, "epsg", 32082,
        "NAD27 / MTM zone 2", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 2\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",0],PARAMETER[\"central_meridian\",-56],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",304800],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32082\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32083, "epsg", 32083,
        "NAD27 / MTM zone 3", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 3\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",0],PARAMETER[\"central_meridian\",-58.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",304800],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32083");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 32084, "epsg", 32084,
        "NAD27 / MTM zone 4", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 4\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",0],PARAMETER[\"central_meridian\",-61.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",304800],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32084");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 32085, "epsg", 32085,
        "NAD27 / MTM zone 5", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 5\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",0],PARAMETER[\"central_meridian\",-64.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",304800],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32085");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 32086, "epsg", 32086,
        "NAD27 / MTM zone 6", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 6\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",0],PARAMETER[\"central_meridian\",-67.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",304800],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32086");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 32098, "epsg", 32098,
        "NAD27 / Quebec Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Quebec Lambert\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",60],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_2\",46],PARAMETER[\"latitude_of_origin\",44],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",-68.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32098\"]]");
    p = add_epsg_def_ex (filter, first, last, 32099, "epsg", 32099,
        "NAD27 / Louisiana Offshore", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-91.33333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana Offshore\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",27.83333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",26.16666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",25.66666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-91.33333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",2000000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 13,
        "\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"32099\"]]");
    p = add_epsg_def_ex (filter, first, last, 32100, "epsg", 32100,
        "NAD83 / Montana", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5");
    add_proj4text (p, 1,
        " +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Montana\",GEOGCS[\"NAD83\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",49],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_2\",45],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 10,
        "25],PARAMETER[\"central_meridian\",-109.5],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",600000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32100\"]]");
    p = add_epsg_def_ex (filter, first, last, 32104, "epsg", 32104,
        "NAD83 / Nebraska", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",43],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",40],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 10,
        "9.83333333333334],PARAMETER[\"central_meridian\",-100],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"32104\"]]");
    p = add_epsg_def_ex (filter, first, last, 32107, "epsg", 32107,
        "NAD83 / Nevada East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",34.75],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-115.5833333333333],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",8000000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"32107\"]]");
    p = add_epsg_def_ex (filter, first, last, 32108, "epsg", 32108,
        "NAD83 / Nevada Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada Central\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-116.6666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9999],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",6000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"32108\"]]");
    p = add_epsg_def_ex (filter, first, last, 32109, "epsg", 32109,
        "NAD83 / Nevada West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",34.75],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-118.5833333333333],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9999],PARAMETER[\"false_easting\",800000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",4000000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"32109\"]]");
    p = add_epsg_def_ex (filter, first, last, 32110, "epsg", 32110,
        "NAD83 / New Hampshire", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Hampshire\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",42.5],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-71.66666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999966667],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"32110\"]]");
    p = add_epsg_def_ex (filter, first, last, 32111, "epsg", 32111,
        "NAD83 / New Jersey", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Jersey\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",38.83333333333334],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-74.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",150000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"32111\"]]");
    p = add_epsg_def_ex (filter, first, last, 32112, "epsg", 32112,
        "NAD83 / New Mexico East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico East\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-104.3333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999909091],PARAMETER[\"false_easting\",165000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"32112\"]]");
    p = add_epsg_def_ex (filter, first, last, 32113, "epsg", 32113,
        "NAD83 / New Mexico Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
        "00 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico Central\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-106.25],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "99],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"32113\"]]");
    p = add_epsg_def_ex (filter, first, last, 32114, "epsg", 32114,
        "NAD83 / New Mexico West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico West\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-107.8333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999916667],PARAMETER[\"false_easting\",830000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"32114\"]]");
    p = add_epsg_def_ex (filter, first, last, 32115, "epsg", 32115,
        "NAD83 / New York East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",38.83333333333334],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-74.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",150000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"32115\"]]");
    p = add_epsg_def_ex (filter, first, last, 32116, "epsg", 32116,
        "NAD83 / New York Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-76.58333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.9999375],PARAMETER[\"false_easting\",250000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"32116\"]]");
    p = add_epsg_def_ex (filter, first, last, 32117, "epsg", 32117,
        "NAD83 / New York West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",40],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-78.58333333333333],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999375],PARAMETER[\"false_easting\",350000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32117\"]]");
    p = add_epsg_def_ex (filter, first, last, 32118, "epsg", 32118,
        "NAD83 / New York Long Island", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York Long Island\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.03333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"standard_parallel_2\",40.66666666");
    add_srs_wkt (p, 10,
        "666666],PARAMETER[\"latitude_of_origin\",40.166666666666");
    add_srs_wkt (p, 11,
        "66],PARAMETER[\"central_meridian\",-74],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",300000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 13,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 14,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32118\"]]");
    p = add_epsg_def_ex (filter, first, last, 32119, "epsg", 32119,
        "NAD83 / North Carolina", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Carolina\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",36.16666666666");
    add_srs_wkt (p, 9,
        "666],PARAMETER[\"standard_parallel_2\",34.33333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",33.75],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-79],PARAMETER[\"false_easting\",609601");
    add_srs_wkt (p, 12,
        ".22],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"32119\"]]");
    p = add_epsg_def_ex (filter, first, last, 32120, "epsg", 32120,
        "NAD83 / North Dakota North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Dakota North\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",48.7333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"standard_parallel_2\",47.4333333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"latitude_of_origin\",47],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-100.5],PARAMETER[\"false_easting\",60");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"32120\"]]");
    p = add_epsg_def_ex (filter, first, last, 32121, "epsg", 32121,
        "NAD83 / North Dakota South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Dakota South\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",47.4833333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"standard_parallel_2\",46.1833333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"latitude_of_origin\",45.66666666666666");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"central_meridian\",-100.5],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_easting\",600000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32121\"]]");
    p = add_epsg_def_ex (filter, first, last, 32122, "epsg", 32122,
        "NAD83 / Ohio North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ohio North\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",41.7],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",40.43333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",39.66666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-82.5],PARAMETER[\"false_easting\",600000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"32122\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

