// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_ext_autogen.cpp:
//   Defines the GLES extension entry points.

#include "libGLESv2/entry_points_gles_ext_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture_gles_ext_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationESEXT.h"
#include "libGLESv2/global_state.h"

#include "libANGLE/capture_gles_1_0_autogen.h"
#include "libANGLE/capture_gles_2_0_autogen.h"
#include "libANGLE/capture_gles_3_0_autogen.h"
#include "libANGLE/capture_gles_3_1_autogen.h"
#include "libANGLE/capture_gles_3_2_autogen.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"

namespace gl
{

// GL_ANGLE_base_vertex_base_instance
void GL_APIENTRY DrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                      GLint first,
                                                      GLsizei count,
                                                      GLsizei instanceCount,
                                                      GLuint baseInstance)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawArraysInstancedBaseInstanceANGLE",
          "context = %d, GLenum mode = %s, GLint first = %d, GLsizei count = %d, GLsizei "
          "instanceCount = %d, GLuint baseInstance = %u",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), first, count,
          instanceCount, baseInstance);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawArraysInstancedBaseInstanceANGLE(
                                context, modePacked, first, count, instanceCount, baseInstance));
        if (isCallValid)
        {
            context->drawArraysInstancedBaseInstance(modePacked, first, count, instanceCount,
                                                     baseInstance);
        }
        ANGLE_CAPTURE(DrawArraysInstancedBaseInstanceANGLE, isCallValid, context, modePacked, first,
                      count, instanceCount, baseInstance);
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                                  GLsizei count,
                                                                  GLenum type,
                                                                  const GLvoid *indices,
                                                                  GLsizei instanceCounts,
                                                                  GLint baseVertex,
                                                                  GLuint baseInstance)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsInstancedBaseVertexBaseInstanceANGLE",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const GLvoid "
          "*indices = 0x%016" PRIxPTR
          ", GLsizei instanceCounts = %d, GLint baseVertex = %d, GLuint baseInstance = %u",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instanceCounts,
          baseVertex, baseInstance);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexBaseInstanceANGLE(
                                              context, modePacked, count, typePacked, indices,
                                              instanceCounts, baseVertex, baseInstance));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertexBaseInstance(
                modePacked, count, typePacked, indices, instanceCounts, baseVertex, baseInstance);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexBaseInstanceANGLE, isCallValid, context,
                      modePacked, count, typePacked, indices, instanceCounts, baseVertex,
                      baseInstance);
    }
}

void GL_APIENTRY MultiDrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                           const GLint *firsts,
                                                           const GLsizei *counts,
                                                           const GLsizei *instanceCounts,
                                                           const GLuint *baseInstances,
                                                           GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawArraysInstancedBaseInstanceANGLE",
          "context = %d, GLenum mode = %s, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR
          ", const GLsizei *instanceCounts = 0x%016" PRIxPTR
          ", const GLuint *baseInstances = 0x%016" PRIxPTR ", GLsizei drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, (uintptr_t)instanceCounts, (uintptr_t)baseInstances, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawArraysInstancedBaseInstanceANGLE(
                 context, modePacked, firsts, counts, instanceCounts, baseInstances, drawcount));
        if (isCallValid)
        {
            context->multiDrawArraysInstancedBaseInstance(modePacked, firsts, counts,
                                                          instanceCounts, baseInstances, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawArraysInstancedBaseInstanceANGLE, isCallValid, context, modePacked,
                      firsts, counts, instanceCounts, baseInstances, drawcount);
    }
}

void GL_APIENTRY
MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                      const GLsizei *counts,
                                                      GLenum type,
                                                      const GLvoid *const *indices,
                                                      const GLsizei *instanceCounts,
                                                      const GLint *baseVertices,
                                                      const GLuint *baseInstances,
                                                      GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE",
          "context = %d, GLenum mode = %s, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = %s, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", const GLsizei *instanceCounts = 0x%016" PRIxPTR
          ", const GLint *baseVertices = 0x%016" PRIxPTR
          ", const GLuint *baseInstances = 0x%016" PRIxPTR ", GLsizei drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices,
          (uintptr_t)instanceCounts, (uintptr_t)baseVertices, (uintptr_t)baseInstances, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
                                context, modePacked, counts, typePacked, indices, instanceCounts,
                                baseVertices, baseInstances, drawcount));
        if (isCallValid)
        {
            context->multiDrawElementsInstancedBaseVertexBaseInstance(
                modePacked, counts, typePacked, indices, instanceCounts, baseVertices,
                baseInstances, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE, isCallValid, context,
                      modePacked, counts, typePacked, indices, instanceCounts, baseVertices,
                      baseInstances, drawcount);
    }
}

// GL_ANGLE_copy_texture_3d
void GL_APIENTRY CopyTexture3DANGLE(GLuint sourceId,
                                    GLint sourceLevel,
                                    GLenum destTarget,
                                    GLuint destId,
                                    GLint destLevel,
                                    GLint internalFormat,
                                    GLenum destType,
                                    GLboolean unpackFlipY,
                                    GLboolean unpackPremultiplyAlpha,
                                    GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyTexture3DANGLE",
          "context = %d, GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = %s, "
          "GLuint destId = %u, GLint destLevel = %d, GLint internalFormat = %d, GLenum destType = "
          "%s, GLboolean unpackFlipY = %s, GLboolean unpackPremultiplyAlpha = %s, GLboolean "
          "unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, internalFormat,
          GLenumToString(GLenumGroup::DefaultGroup, destType), GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked                      = FromGL<TextureID>(sourceId);
        TextureTarget destTargetPacked                = FromGL<TextureTarget>(destTarget);
        TextureID destIdPacked                        = FromGL<TextureID>(destId);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTexture3DANGLE(
                                context, sourceIdPacked, sourceLevel, destTargetPacked,
                                destIdPacked, destLevel, internalFormat, destType, unpackFlipY,
                                unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copyTexture3D(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                   destLevel, internalFormat, destType, unpackFlipY,
                                   unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopyTexture3DANGLE, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
}

void GL_APIENTRY CopySubTexture3DANGLE(GLuint sourceId,
                                       GLint sourceLevel,
                                       GLenum destTarget,
                                       GLuint destId,
                                       GLint destLevel,
                                       GLint xoffset,
                                       GLint yoffset,
                                       GLint zoffset,
                                       GLint x,
                                       GLint y,
                                       GLint z,
                                       GLint width,
                                       GLint height,
                                       GLint depth,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopySubTexture3DANGLE",
          "context = %d, GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = %s, "
          "GLuint destId = %u, GLint destLevel = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
          "zoffset = %d, GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height "
          "= %d, GLint depth = %d, GLboolean unpackFlipY = %s, GLboolean unpackPremultiplyAlpha = "
          "%s, GLboolean unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, xoffset,
          yoffset, zoffset, x, y, z, width, height, depth, GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked                      = FromGL<TextureID>(sourceId);
        TextureTarget destTargetPacked                = FromGL<TextureTarget>(destTarget);
        TextureID destIdPacked                        = FromGL<TextureID>(destId);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopySubTexture3DANGLE(context, sourceIdPacked, sourceLevel, destTargetPacked,
                                           destIdPacked, destLevel, xoffset, yoffset, zoffset, x, y,
                                           z, width, height, depth, unpackFlipY,
                                           unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copySubTexture3D(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                      destLevel, xoffset, yoffset, zoffset, x, y, z, width, height,
                                      depth, unpackFlipY, unpackPremultiplyAlpha,
                                      unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopySubTexture3DANGLE, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, zoffset, x, y, z,
                      width, height, depth, unpackFlipY, unpackPremultiplyAlpha,
                      unpackUnmultiplyAlpha);
    }
}

// GL_ANGLE_framebuffer_blit
void GL_APIENTRY BlitFramebufferANGLE(GLint srcX0,
                                      GLint srcY0,
                                      GLint srcX1,
                                      GLint srcY1,
                                      GLint dstX0,
                                      GLint dstY0,
                                      GLint dstX1,
                                      GLint dstY1,
                                      GLbitfield mask,
                                      GLenum filter)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBlitFramebufferANGLE",
          "context = %d, GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, "
          "GLint dstX0 = %d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask "
          "= %s, GLenum filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                         dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebufferANGLE, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
}

// GL_ANGLE_framebuffer_multisample
void GL_APIENTRY RenderbufferStorageMultisampleANGLE(GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glRenderbufferStorageMultisampleANGLE",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisampleANGLE(
                                context, target, samples, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisampleANGLE, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
}

// GL_ANGLE_get_image
void GL_APIENTRY
GetTexImageANGLE(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexImageANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum format = %s, GLenum type = "
          "%s, void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexImageANGLE(context, targetPacked, level, format, type, pixels));
        if (isCallValid)
        {
            context->getTexImage(targetPacked, level, format, type, pixels);
        }
        ANGLE_CAPTURE(GetTexImageANGLE, isCallValid, context, targetPacked, level, format, type,
                      pixels);
    }
}

void GL_APIENTRY GetRenderbufferImageANGLE(GLenum target, GLenum format, GLenum type, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetRenderbufferImageANGLE",
          "context = %d, GLenum target = %s, GLenum format = %s, GLenum type = %s, void *pixels = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetRenderbufferImageANGLE(context, target, format, type, pixels));
        if (isCallValid)
        {
            context->getRenderbufferImage(target, format, type, pixels);
        }
        ANGLE_CAPTURE(GetRenderbufferImageANGLE, isCallValid, context, target, format, type,
                      pixels);
    }
}

// GL_ANGLE_instanced_arrays
void GL_APIENTRY DrawArraysInstancedANGLE(GLenum mode,
                                          GLint first,
                                          GLsizei count,
                                          GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawArraysInstancedANGLE",
          "context = %d, GLenum mode = %s, GLint first = %d, GLsizei count = %d, GLsizei primcount "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), first, count, primcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedANGLE(context, modePacked, first, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedANGLE, isCallValid, context, modePacked, first, count,
                      primcount);
    }
}

void GL_APIENTRY DrawElementsInstancedANGLE(GLenum mode,
                                            GLsizei count,
                                            GLenum type,
                                            const void *indices,
                                            GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsInstancedANGLE",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::PrimitiveType, type), (uintptr_t)indices, primcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsInstancedANGLE(context, modePacked, count,
                                                               typePacked, indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedANGLE, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount);
    }
}

void GL_APIENTRY VertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribDivisorANGLE", "context = %d, GLuint index = %u, GLuint divisor = %u",
          CID(context), index, divisor);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexAttribDivisorANGLE(context, index, divisor));
        if (isCallValid)
        {
            context->vertexAttribDivisor(index, divisor);
        }
        ANGLE_CAPTURE(VertexAttribDivisorANGLE, isCallValid, context, index, divisor);
    }
}

// GL_ANGLE_multi_draw
void GL_APIENTRY MultiDrawArraysANGLE(GLenum mode,
                                      const GLint *firsts,
                                      const GLsizei *counts,
                                      GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawArraysANGLE",
          "context = %d, GLenum mode = %s, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR ", GLsizei drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawArraysANGLE(context, modePacked, firsts, counts, drawcount));
        if (isCallValid)
        {
            context->multiDrawArrays(modePacked, firsts, counts, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawArraysANGLE, isCallValid, context, modePacked, firsts, counts,
                      drawcount);
    }
}

void GL_APIENTRY MultiDrawArraysInstancedANGLE(GLenum mode,
                                               const GLint *firsts,
                                               const GLsizei *counts,
                                               const GLsizei *instanceCounts,
                                               GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawArraysInstancedANGLE",
          "context = %d, GLenum mode = %s, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR
          ", const GLsizei *instanceCounts = 0x%016" PRIxPTR ", GLsizei drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, (uintptr_t)instanceCounts, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateMultiDrawArraysInstancedANGLE(
                                context, modePacked, firsts, counts, instanceCounts, drawcount));
        if (isCallValid)
        {
            context->multiDrawArraysInstanced(modePacked, firsts, counts, instanceCounts,
                                              drawcount);
        }
        ANGLE_CAPTURE(MultiDrawArraysInstancedANGLE, isCallValid, context, modePacked, firsts,
                      counts, instanceCounts, drawcount);
    }
}

void GL_APIENTRY MultiDrawElementsANGLE(GLenum mode,
                                        const GLsizei *counts,
                                        GLenum type,
                                        const GLvoid *const *indices,
                                        GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawElementsANGLE",
          "context = %d, GLenum mode = %s, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = %s, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", GLsizei drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateMultiDrawElementsANGLE(context, modePacked, counts, typePacked,
                                                           indices, drawcount));
        if (isCallValid)
        {
            context->multiDrawElements(modePacked, counts, typePacked, indices, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawElementsANGLE, isCallValid, context, modePacked, counts, typePacked,
                      indices, drawcount);
    }
}

void GL_APIENTRY MultiDrawElementsInstancedANGLE(GLenum mode,
                                                 const GLsizei *counts,
                                                 GLenum type,
                                                 const GLvoid *const *indices,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawElementsInstancedANGLE",
          "context = %d, GLenum mode = %s, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = %s, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", const GLsizei*instanceCounts = 0x%016" PRIxPTR ", GLsizei drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices,
          (uintptr_t)instanceCounts, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawElementsInstancedANGLE(context, modePacked, counts, typePacked,
                                                     indices, instanceCounts, drawcount));
        if (isCallValid)
        {
            context->multiDrawElementsInstanced(modePacked, counts, typePacked, indices,
                                                instanceCounts, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawElementsInstancedANGLE, isCallValid, context, modePacked, counts,
                      typePacked, indices, instanceCounts, drawcount);
    }
}

// GL_ANGLE_program_binary

// GL_ANGLE_provoking_vertex
void GL_APIENTRY ProvokingVertexANGLE(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT("glProvokingVertexANGLE", "context = %d, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::VertexProvokingMode, mode));

    if (context)
    {
        ProvokingVertexConvention modePacked          = FromGL<ProvokingVertexConvention>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateProvokingVertexANGLE(context, modePacked));
        if (isCallValid)
        {
            context->provokingVertex(modePacked);
        }
        ANGLE_CAPTURE(ProvokingVertexANGLE, isCallValid, context, modePacked);
    }
}

// GL_ANGLE_request_extension
void GL_APIENTRY RequestExtensionANGLE(const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glRequestExtensionANGLE", "context = %d, const GLchar * name = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)name);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateRequestExtensionANGLE(context, name));
        if (isCallValid)
        {
            context->requestExtension(name);
        }
        ANGLE_CAPTURE(RequestExtensionANGLE, isCallValid, context, name);
    }
}

void GL_APIENTRY DisableExtensionANGLE(const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDisableExtensionANGLE", "context = %d, const GLchar * name = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)name);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableExtensionANGLE(context, name));
        if (isCallValid)
        {
            context->disableExtension(name);
        }
        ANGLE_CAPTURE(DisableExtensionANGLE, isCallValid, context, name);
    }
}

// GL_ANGLE_robust_client_memory
void GL_APIENTRY GetBooleanvRobustANGLE(GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLboolean *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetBooleanvRobustANGLE",
          "context = %d, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLboolean * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBooleanvRobustANGLE(context, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getBooleanvRobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBooleanvRobustANGLE, isCallValid, context, pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetBufferParameterivRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetBufferParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferParameterivRobustANGLE(context, targetPacked, pname,
                                                                    bufSize, length, params));
        if (isCallValid)
        {
            context->getBufferParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBufferParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetFloatvRobustANGLE(GLenum pname,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFloatvRobustANGLE",
          "context = %d, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFloatvRobustANGLE(context, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getFloatvRobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetFloatvRobustANGLE, isCallValid, context, pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivRobustANGLE(GLenum target,
                                                                GLenum attachment,
                                                                GLenum pname,
                                                                GLsizei bufSize,
                                                                GLsizei *length,
                                                                GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFramebufferAttachmentParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum pname = %s, GLsizei "
          "bufSize = %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, attachment),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFramebufferAttachmentParameterivRobustANGLE(
                                context, target, attachment, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameterivRobust(target, attachment, pname, bufSize,
                                                               length, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivRobustANGLE, isCallValid, context, target,
                      attachment, pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetIntegervRobustANGLE(GLenum pname, GLsizei bufSize, GLsizei *length, GLint *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetIntegervRobustANGLE",
          "context = %d, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetIntegervRobustANGLE(context, pname, bufSize, length, data));
        if (isCallValid)
        {
            context->getIntegervRobust(pname, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetIntegervRobustANGLE, isCallValid, context, pname, bufSize, length, data);
    }
}

void GL_APIENTRY GetProgramivRobustANGLE(GLuint program,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetProgramivRobustANGLE",
          "context = %d, GLuint program = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramivRobustANGLE(context, programPacked, pname, bufSize,
                                                            length, params));
        if (isCallValid)
        {
            context->getProgramivRobust(programPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetProgramivRobustANGLE, isCallValid, context, programPacked, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetRenderbufferParameterivRobustANGLE(GLenum target,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetRenderbufferParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetRenderbufferParameterivRobustANGLE(
                                              context, target, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getRenderbufferParameterivRobust(target, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameterivRobustANGLE, isCallValid, context, target, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY
GetShaderivRobustANGLE(GLuint shader, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetShaderivRobustANGLE",
          "context = %d, GLuint shader = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), shader, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderivRobustANGLE(context, shaderPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getShaderivRobust(shaderPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetShaderivRobustANGLE, isCallValid, context, shaderPacked, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetTexParameterfvRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexParameterfvRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterfvRobustANGLE(context, targetPacked, pname,
                                                                 bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterfvRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterfvRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetTexParameterivRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterivRobustANGLE(context, targetPacked, pname,
                                                                 bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetUniformfvRobustANGLE(GLuint program,
                                         GLint location,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUniformfvRobustANGLE",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformfvRobustANGLE(context, programPacked, location,
                                                            bufSize, length, params));
        if (isCallValid)
        {
            context->getUniformfvRobust(programPacked, location, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetUniformfvRobustANGLE, isCallValid, context, programPacked, location,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetUniformivRobustANGLE(GLuint program,
                                         GLint location,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUniformivRobustANGLE",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformivRobustANGLE(context, programPacked, location,
                                                            bufSize, length, params));
        if (isCallValid)
        {
            context->getUniformivRobust(programPacked, location, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetUniformivRobustANGLE, isCallValid, context, programPacked, location,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetVertexAttribfvRobustANGLE(GLuint index,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribfvRobustANGLE",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribfvRobustANGLE(context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribfvRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribfvRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetVertexAttribivRobustANGLE(GLuint index,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribivRobustANGLE",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribivRobustANGLE(context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribivRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetVertexAttribPointervRobustANGLE(GLuint index,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    void **pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribPointervRobustANGLE",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", void ** pointer = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribPointervRobustANGLE(
                                              context, index, pname, bufSize, length, pointer));
        if (isCallValid)
        {
            context->getVertexAttribPointervRobust(index, pname, bufSize, length, pointer);
        }
        ANGLE_CAPTURE(GetVertexAttribPointervRobustANGLE, isCallValid, context, index, pname,
                      bufSize, length, pointer);
    }
}

void GL_APIENTRY ReadPixelsRobustANGLE(GLint x,
                                       GLint y,
                                       GLsizei width,
                                       GLsizei height,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLsizei *columns,
                                       GLsizei *rows,
                                       void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glReadPixelsRobustANGLE",
        "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum "
        "format = %s, GLenum type = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
        ", GLsizei * columns = 0x%016" PRIxPTR ", GLsizei * rows = 0x%016" PRIxPTR
        ", void * pixels = 0x%016" PRIxPTR "",
        CID(context), x, y, width, height, GLenumToString(GLenumGroup::DefaultGroup, format),
        GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)length,
        (uintptr_t)columns, (uintptr_t)rows, (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                           length, columns, rows, pixels));
        if (isCallValid)
        {
            context->readPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                      rows, pixels);
        }
        ANGLE_CAPTURE(ReadPixelsRobustANGLE, isCallValid, context, x, y, width, height, format,
                      type, bufSize, length, columns, rows, pixels);
    }
}

void GL_APIENTRY TexImage2DRobustANGLE(GLenum target,
                                       GLint level,
                                       GLint internalformat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLint border,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexImage2DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLint internalformat = %d, GLsizei "
          "width = %d, GLsizei height = %d, GLint border = %d, GLenum format = %s, GLenum type = "
          "%s, GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, internalformat,
          width, height, border, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage2DRobustANGLE(context, targetPacked, level, internalformat, width,
                                           height, border, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texImage2DRobust(targetPacked, level, internalformat, width, height, border,
                                      format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, format, type, bufSize, pixels);
    }
}

void GL_APIENTRY TexParameterfvRobustANGLE(GLenum target,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexParameterfvRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, const "
          "GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterfvRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterfvRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterfvRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                      params);
    }
}

void GL_APIENTRY TexParameterivRobustANGLE(GLenum target,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, const GLint "
          "* params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterivRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterivRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                      params);
    }
}

void GL_APIENTRY TexSubImage2DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexSubImage2DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLsizei width = %d, GLsizei height = %d, GLenum format = %s, GLenum type = %s, "
          "GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage2DRobustANGLE(context, targetPacked, level, xoffset, yoffset, width,
                                              height, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texSubImage2DRobust(targetPacked, level, xoffset, yoffset, width, height,
                                         format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexSubImage2DRobustANGLE, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, width, height, format, type, bufSize, pixels);
    }
}

void GL_APIENTRY TexImage3DRobustANGLE(GLenum target,
                                       GLint level,
                                       GLint internalformat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       GLint border,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexImage3DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLint internalformat = %d, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = "
          "%s, GLenum type = %s, GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, internalformat,
          width, height, depth, border, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage3DRobustANGLE(context, targetPacked, level, internalformat, width,
                                           height, depth, border, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texImage3DRobust(targetPacked, level, internalformat, width, height, depth,
                                      border, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, format, type, bufSize, pixels);
    }
}

void GL_APIENTRY TexSubImage3DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint zoffset,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexSubImage3DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLenum type = %s, GLsizei bufSize = %d, const void * pixels = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexSubImage3DRobustANGLE(context, targetPacked, level, xoffset,
                                                             yoffset, zoffset, width, height, depth,
                                                             format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset, width,
                                         height, depth, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexSubImage3DRobustANGLE, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }
}

void GL_APIENTRY CompressedTexImage2DRobustANGLE(GLenum target,
                                                 GLint level,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLint border,
                                                 GLsizei imageSize,
                                                 GLsizei dataSize,
                                                 const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTexImage2DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, GLsizei "
          "dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, internalformat), width, height, border,
          imageSize, dataSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompressedTexImage2DRobustANGLE(
                                              context, targetPacked, level, internalformat, width,
                                              height, border, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexImage2DRobust(targetPacked, level, internalformat, width, height,
                                                border, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, imageSize, dataSize, data);
    }
}

void GL_APIENTRY CompressedTexSubImage2DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLsizei xoffset,
                                                    GLsizei yoffset,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLenum format,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTexSubImage2DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLsizei xoffset = %d, GLsizei "
          "yoffset = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = %s, GLsizei "
          "imageSize = %d, GLsizei dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::DefaultGroup, format), imageSize, dataSize,
          (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompressedTexSubImage2DRobustANGLE(
                                              context, targetPacked, level, xoffset, yoffset, width,
                                              height, format, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage2DRobust(targetPacked, level, xoffset, yoffset, width,
                                                   height, format, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, width, height, format, imageSize, dataSize, data);
    }
}

void GL_APIENTRY CompressedTexImage3DRobustANGLE(GLenum target,
                                                 GLint level,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLint border,
                                                 GLsizei imageSize,
                                                 GLsizei dataSize,
                                                 const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTexImage3DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei "
          "imageSize = %d, GLsizei dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, internalformat), width, height, depth, border,
          imageSize, dataSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompressedTexImage3DRobustANGLE(
                                              context, targetPacked, level, internalformat, width,
                                              height, depth, border, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3DRobust(targetPacked, level, internalformat, width, height,
                                                depth, border, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, dataSize, data);
    }
}

void GL_APIENTRY CompressedTexSubImage3DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLint xoffset,
                                                    GLint yoffset,
                                                    GLint zoffset,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLsizei depth,
                                                    GLenum format,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTexSubImage3DRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLsizei imageSize = %d, GLsizei dataSize = %d, const GLvoid * data "
          "= 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::DefaultGroup, format),
          imageSize, dataSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3DRobustANGLE(
                                context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset,
                                                   width, height, depth, format, imageSize,
                                                   dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataSize,
                      data);
    }
}

void GL_APIENTRY
GetQueryivRobustANGLE(GLenum target, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryivRobustANGLE(context, targetPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryivRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetQueryObjectuivRobustANGLE(GLuint id,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryObjectuivRobustANGLE",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length "
          "= 0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjectuivRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjectuivRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuivRobustANGLE, isCallValid, context, idPacked, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetBufferPointervRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetBufferPointervRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", void ** params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferPointervRobustANGLE(context, targetPacked, pname,
                                                                 bufSize, length, params));
        if (isCallValid)
        {
            context->getBufferPointervRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBufferPointervRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY
GetIntegeri_vRobustANGLE(GLenum target, GLuint index, GLsizei bufSize, GLsizei *length, GLint *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetIntegeri_vRobustANGLE",
          "context = %d, GLenum target = %s, GLuint index = %u, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetIntegeri_vRobustANGLE(context, target, index, bufSize, length, data));
        if (isCallValid)
        {
            context->getIntegeri_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetIntegeri_vRobustANGLE, isCallValid, context, target, index, bufSize,
                      length, data);
    }
}

void GL_APIENTRY GetInternalformativRobustANGLE(GLenum target,
                                                GLenum internalformat,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetInternalformativRobustANGLE",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLenum pname = %s, "
          "GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, internalformat),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetInternalformativRobustANGLE(context, target, internalformat,
                                                                   pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getInternalformativRobust(target, internalformat, pname, bufSize, length,
                                               params);
        }
        ANGLE_CAPTURE(GetInternalformativRobustANGLE, isCallValid, context, target, internalformat,
                      pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetVertexAttribIivRobustANGLE(GLuint index,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribIivRobustANGLE",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribIivRobustANGLE(context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribIivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIivRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetVertexAttribIuivRobustANGLE(GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribIuivRobustANGLE",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribIuivRobustANGLE(
                                              context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribIuivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIuivRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetUniformuivRobustANGLE(GLuint program,
                                          GLint location,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUniformuivRobustANGLE",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformuivRobustANGLE(context, programPacked, location,
                                                             bufSize, length, params));
        if (isCallValid)
        {
            context->getUniformuivRobust(programPacked, location, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetUniformuivRobustANGLE, isCallValid, context, programPacked, location,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetActiveUniformBlockivRobustANGLE(GLuint program,
                                                    GLuint uniformBlockIndex,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetActiveUniformBlockivRobustANGLE",
          "context = %d, GLuint program = %u, GLuint uniformBlockIndex = %u, GLenum pname = %s, "
          "GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), program, uniformBlockIndex,
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetActiveUniformBlockivRobustANGLE(context, programPacked, uniformBlockIndex,
                                                        pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getActiveUniformBlockivRobust(programPacked, uniformBlockIndex, pname, bufSize,
                                                   length, params);
        }
        ANGLE_CAPTURE(GetActiveUniformBlockivRobustANGLE, isCallValid, context, programPacked,
                      uniformBlockIndex, pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetInteger64vRobustANGLE(GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint64 *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetInteger64vRobustANGLE",
          "context = %d, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint64 * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInteger64vRobustANGLE(context, pname, bufSize, length, data));
        if (isCallValid)
        {
            context->getInteger64vRobust(pname, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetInteger64vRobustANGLE, isCallValid, context, pname, bufSize, length, data);
    }
}

void GL_APIENTRY GetInteger64i_vRobustANGLE(GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetInteger64i_vRobustANGLE",
          "context = %d, GLenum target = %s, GLuint index = %u, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint64 * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInteger64i_vRobustANGLE(context, target, index, bufSize, length, data));
        if (isCallValid)
        {
            context->getInteger64i_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetInteger64i_vRobustANGLE, isCallValid, context, target, index, bufSize,
                      length, data);
    }
}

void GL_APIENTRY GetBufferParameteri64vRobustANGLE(GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetBufferParameteri64vRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint64 * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferParameteri64vRobustANGLE(context, targetPacked, pname,
                                                                      bufSize, length, params));
        if (isCallValid)
        {
            context->getBufferParameteri64vRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBufferParameteri64vRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY SamplerParameterivRobustANGLE(GLuint sampler,
                                               GLuint pname,
                                               GLsizei bufSize,
                                               const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameterivRobustANGLE",
          "context = %d, GLuint sampler = %u, GLuint pname = %u, GLsizei bufSize = %d, const GLint "
          "* param = 0x%016" PRIxPTR "",
          CID(context), sampler, pname, bufSize, (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSamplerParameterivRobustANGLE(context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
}

void GL_APIENTRY SamplerParameterfvRobustANGLE(GLuint sampler,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLfloat *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameterfvRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, const "
          "GLfloat * param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSamplerParameterfvRobustANGLE(context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterfvRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterfvRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
}

void GL_APIENTRY GetSamplerParameterivRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterivRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterivRobustANGLE(context, samplerPacked, pname,
                                                                     bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetSamplerParameterfvRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterfvRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterfvRobustANGLE(context, samplerPacked, pname,
                                                                     bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterfvRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterfvRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetFramebufferParameterivRobustANGLE(GLenum target,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFramebufferParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferParameterivRobustANGLE(
                                              context, target, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getFramebufferParameterivRobust(target, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetFramebufferParameterivRobustANGLE, isCallValid, context, target, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetProgramInterfaceivRobustANGLE(GLuint program,
                                                  GLenum programInterface,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetProgramInterfaceivRobustANGLE",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, GLenum pname = %s, "
          "GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, programInterface),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramInterfaceivRobustANGLE(context, programPacked, programInterface,
                                                      pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getProgramInterfaceivRobust(programPacked, programInterface, pname, bufSize,
                                                 length, params);
        }
        ANGLE_CAPTURE(GetProgramInterfaceivRobustANGLE, isCallValid, context, programPacked,
                      programInterface, pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetBooleani_vRobustANGLE(GLenum target,
                                          GLuint index,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetBooleani_vRobustANGLE",
          "context = %d, GLenum target = %s, GLuint index = %u, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLboolean * data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBooleani_vRobustANGLE(context, target, index, bufSize, length, data));
        if (isCallValid)
        {
            context->getBooleani_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetBooleani_vRobustANGLE, isCallValid, context, target, index, bufSize,
                      length, data);
    }
}

void GL_APIENTRY GetMultisamplefvRobustANGLE(GLenum pname,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLfloat *val)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetMultisamplefvRobustANGLE",
          "context = %d, GLenum pname = %s, GLuint index = %u, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLfloat * val = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), index, bufSize,
          (uintptr_t)length, (uintptr_t)val);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMultisamplefvRobustANGLE(context, pname, index, bufSize, length, val));
        if (isCallValid)
        {
            context->getMultisamplefvRobust(pname, index, bufSize, length, val);
        }
        ANGLE_CAPTURE(GetMultisamplefvRobustANGLE, isCallValid, context, pname, index, bufSize,
                      length, val);
    }
}

void GL_APIENTRY GetTexLevelParameterivRobustANGLE(GLenum target,
                                                   GLint level,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexLevelParameterivRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum pname = %s, GLsizei bufSize "
          "= %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexLevelParameterivRobustANGLE(
                                context, targetPacked, level, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getTexLevelParameterivRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterivRobustANGLE, isCallValid, context, targetPacked, level,
                      pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetTexLevelParameterfvRobustANGLE(GLenum target,
                                                   GLint level,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexLevelParameterfvRobustANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum pname = %s, GLsizei bufSize "
          "= %d, GLsizei * length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexLevelParameterfvRobustANGLE(
                                context, targetPacked, level, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfvRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterfvRobustANGLE, isCallValid, context, targetPacked, level,
                      pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetPointervRobustANGLERobustANGLE(GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetPointervRobustANGLERobustANGLE",
          "context = %d, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", void ** params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPointervRobustANGLERobustANGLE(context, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getPointervRobustANGLERobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetPointervRobustANGLERobustANGLE, isCallValid, context, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY ReadnPixelsRobustANGLE(GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height,
                                        GLenum format,
                                        GLenum type,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLsizei *columns,
                                        GLsizei *rows,
                                        void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glReadnPixelsRobustANGLE",
        "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum "
        "format = %s, GLenum type = %s, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
        ", GLsizei * columns = 0x%016" PRIxPTR ", GLsizei * rows = 0x%016" PRIxPTR
        ", void * data = 0x%016" PRIxPTR "",
        CID(context), x, y, width, height, GLenumToString(GLenumGroup::DefaultGroup, format),
        GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)length,
        (uintptr_t)columns, (uintptr_t)rows, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                            length, columns, rows, data));
        if (isCallValid)
        {
            context->readnPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                       rows, data);
        }
        ANGLE_CAPTURE(ReadnPixelsRobustANGLE, isCallValid, context, x, y, width, height, format,
                      type, bufSize, length, columns, rows, data);
    }
}

void GL_APIENTRY GetnUniformfvRobustANGLE(GLuint program,
                                          GLint location,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformfvRobustANGLE",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetnUniformfvRobustANGLE(context, programPacked, location,
                                                             bufSize, length, params));
        if (isCallValid)
        {
            context->getnUniformfvRobust(programPacked, location, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetnUniformfvRobustANGLE, isCallValid, context, programPacked, location,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetnUniformivRobustANGLE(GLuint program,
                                          GLint location,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformivRobustANGLE",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetnUniformivRobustANGLE(context, programPacked, location,
                                                             bufSize, length, params));
        if (isCallValid)
        {
            context->getnUniformivRobust(programPacked, location, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetnUniformivRobustANGLE, isCallValid, context, programPacked, location,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetnUniformuivRobustANGLE(GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformuivRobustANGLE",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetnUniformuivRobustANGLE(context, programPacked, location,
                                                              bufSize, length, params));
        if (isCallValid)
        {
            context->getnUniformuivRobust(programPacked, location, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetnUniformuivRobustANGLE, isCallValid, context, programPacked, location,
                      bufSize, length, params);
    }
}

void GL_APIENTRY TexParameterIivRobustANGLE(GLenum target,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexParameterIivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, const GLint "
          "* params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterIivRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterIivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterIivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, params);
    }
}

void GL_APIENTRY TexParameterIuivRobustANGLE(GLenum target,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexParameterIuivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, const GLuint "
          "* params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterIuivRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterIuivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterIuivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, params);
    }
}

void GL_APIENTRY GetTexParameterIivRobustANGLE(GLenum target,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexParameterIivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIivRobustANGLE(context, targetPacked, pname,
                                                                  bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterIivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetTexParameterIuivRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexParameterIuivRobustANGLE",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIuivRobustANGLE(context, targetPacked, pname,
                                                                   bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterIuivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY SamplerParameterIivRobustANGLE(GLuint sampler,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameterIivRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, const GLint "
          "* param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSamplerParameterIivRobustANGLE(context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterIivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterIivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
}

void GL_APIENTRY SamplerParameterIuivRobustANGLE(GLuint sampler,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSamplerParameterIuivRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, const "
          "GLuint * param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSamplerParameterIuivRobustANGLE(
                                              context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterIuivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
}

void GL_APIENTRY GetSamplerParameterIivRobustANGLE(GLuint sampler,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterIivRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterIivRobustANGLE(context, samplerPacked, pname,
                                                                      bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterIivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, length, params);
    }
}

void GL_APIENTRY GetSamplerParameterIuivRobustANGLE(GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterIuivRobustANGLE",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * "
          "length = 0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuivRobustANGLE(
                                context, samplerPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivRobustANGLE, isCallValid, context, samplerPacked,
                      pname, bufSize, length, params);
    }
}

void GL_APIENTRY GetQueryObjectivRobustANGLE(GLuint id,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetQueryObjectivRobustANGLE",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length "
          "= 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjectivRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjectivRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjectivRobustANGLE, isCallValid, context, idPacked, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetQueryObjecti64vRobustANGLE(GLuint id,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetQueryObjecti64vRobustANGLE",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length "
          "= 0x%016" PRIxPTR ", GLint64 * params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjecti64vRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjecti64vRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64vRobustANGLE, isCallValid, context, idPacked, pname, bufSize,
                      length, params);
    }
}

void GL_APIENTRY GetQueryObjectui64vRobustANGLE(GLuint id,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryObjectui64vRobustANGLE",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLsizei bufSize = %d, GLsizei * length "
          "= 0x%016" PRIxPTR ", GLuint64 * params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjectui64vRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjectui64vRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64vRobustANGLE, isCallValid, context, idPacked, pname,
                      bufSize, length, params);
    }
}

// GL_ANGLE_texture_external_update
void GL_APIENTRY TexImage2DExternalANGLE(GLenum target,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTexImage2DExternalANGLE",
        "context = %d, GLenum target = %s, GLint level = %d, GLint internalformat = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLint border = %d, GLenum format = %s, GLenum type = %s",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
        width, height, border, GLenumToString(GLenumGroup::PixelFormat, format),
        GLenumToString(GLenumGroup::PixelType, type));

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage2DExternalANGLE(context, targetPacked, level, internalformat, width,
                                             height, border, format, type));
        if (isCallValid)
        {
            context->texImage2DExternal(targetPacked, level, internalformat, width, height, border,
                                        format, type);
        }
        ANGLE_CAPTURE(TexImage2DExternalANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, format, type);
    }
}

void GL_APIENTRY InvalidateTextureANGLE(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glInvalidateTextureANGLE", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateInvalidateTextureANGLE(context, targetPacked));
        if (isCallValid)
        {
            context->invalidateTexture(targetPacked);
        }
        ANGLE_CAPTURE(InvalidateTextureANGLE, isCallValid, context, targetPacked);
    }
}

// GL_ANGLE_texture_multisample
void GL_APIENTRY TexStorage2DMultisampleANGLE(GLenum target,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorage2DMultisampleANGLE",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLboolean fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2DMultisampleANGLE(context, targetPacked, samples, internalformat,
                                                  width, height, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage2DMultisampleANGLE, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, fixedsamplelocations);
    }
}

void GL_APIENTRY GetTexLevelParameterivANGLE(GLenum target,
                                             GLint level,
                                             GLenum pname,
                                             GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexLevelParameterivANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum pname = %s, GLint * params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterivANGLE(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterivANGLE, isCallValid, context, targetPacked, level, pname,
                      params);
    }
}

void GL_APIENTRY GetTexLevelParameterfvANGLE(GLenum target,
                                             GLint level,
                                             GLenum pname,
                                             GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexLevelParameterfvANGLE",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum pname = %s, GLfloat * params "
          "= 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterfvANGLE(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterfvANGLE, isCallValid, context, targetPacked, level, pname,
                      params);
    }
}

void GL_APIENTRY GetMultisamplefvANGLE(GLenum pname, GLuint index, GLfloat *val)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetMultisamplefvANGLE",
          "context = %d, GLenum pname = %s, GLuint index = %u, GLfloat * val = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), index, (uintptr_t)val);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetMultisamplefvANGLE(context, pname, index, val));
        if (isCallValid)
        {
            context->getMultisamplefv(pname, index, val);
        }
        ANGLE_CAPTURE(GetMultisamplefvANGLE, isCallValid, context, pname, index, val);
    }
}

void GL_APIENTRY SampleMaskiANGLE(GLuint maskNumber, GLbitfield mask)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSampleMaskiANGLE", "context = %d, GLuint maskNumber = %u, GLbitfield mask = %s",
          CID(context), maskNumber, GLbitfieldToString(GLenumGroup::DefaultGroup, mask).c_str());

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSampleMaskiANGLE(context, maskNumber, mask));
        if (isCallValid)
        {
            context->sampleMaski(maskNumber, mask);
        }
        ANGLE_CAPTURE(SampleMaskiANGLE, isCallValid, context, maskNumber, mask);
    }
}

// GL_ANGLE_translated_shader_source
void GL_APIENTRY GetTranslatedShaderSourceANGLE(GLuint shader,
                                                GLsizei bufsize,
                                                GLsizei *length,
                                                GLchar *source)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTranslatedShaderSourceANGLE",
          "context = %d, GLuint shader = %u, GLsizei bufsize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR "",
          CID(context), shader, bufsize, (uintptr_t)length, (uintptr_t)source);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTranslatedShaderSourceANGLE(
                                              context, shaderPacked, bufsize, length, source));
        if (isCallValid)
        {
            context->getTranslatedShaderSource(shaderPacked, bufsize, length, source);
        }
        ANGLE_CAPTURE(GetTranslatedShaderSourceANGLE, isCallValid, context, shaderPacked, bufsize,
                      length, source);
    }
}

// GL_CHROMIUM_bind_uniform_location
void GL_APIENTRY BindUniformLocationCHROMIUM(GLuint program, GLint location, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindUniformLocationCHROMIUM",
          "context = %d, GLuint program = %u, GLint location = %d, const GLchar* name = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindUniformLocationCHROMIUM(context, programPacked, location, name));
        if (isCallValid)
        {
            context->bindUniformLocation(programPacked, location, name);
        }
        ANGLE_CAPTURE(BindUniformLocationCHROMIUM, isCallValid, context, programPacked, location,
                      name);
    }
}

// GL_CHROMIUM_copy_compressed_texture
void GL_APIENTRY CompressedCopyTextureCHROMIUM(GLuint sourceId, GLuint destId)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedCopyTextureCHROMIUM",
          "context = %d, GLuint sourceId = %u, GLuint destId = %u", CID(context), sourceId, destId);

    if (context)
    {
        TextureID sourceIdPacked                      = FromGL<TextureID>(sourceId);
        TextureID destIdPacked                        = FromGL<TextureID>(destId);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedCopyTextureCHROMIUM(context, sourceIdPacked, destIdPacked));
        if (isCallValid)
        {
            context->compressedCopyTexture(sourceIdPacked, destIdPacked);
        }
        ANGLE_CAPTURE(CompressedCopyTextureCHROMIUM, isCallValid, context, sourceIdPacked,
                      destIdPacked);
    }
}

// GL_CHROMIUM_copy_texture
void GL_APIENTRY CopyTextureCHROMIUM(GLuint sourceId,
                                     GLint sourceLevel,
                                     GLenum destTarget,
                                     GLuint destId,
                                     GLint destLevel,
                                     GLint internalFormat,
                                     GLenum destType,
                                     GLboolean unpackFlipY,
                                     GLboolean unpackPremultiplyAlpha,
                                     GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyTextureCHROMIUM",
          "context = %d, GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = %s, "
          "GLuint destId = %u, GLint destLevel = %d, GLint internalFormat = %d, GLenum destType = "
          "%s, GLboolean unpackFlipY = %s, GLboolean unpackPremultiplyAlpha = %s, GLboolean "
          "unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, internalFormat,
          GLenumToString(GLenumGroup::DefaultGroup, destType), GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked                      = FromGL<TextureID>(sourceId);
        TextureTarget destTargetPacked                = FromGL<TextureTarget>(destTarget);
        TextureID destIdPacked                        = FromGL<TextureID>(destId);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTextureCHROMIUM(
                                context, sourceIdPacked, sourceLevel, destTargetPacked,
                                destIdPacked, destLevel, internalFormat, destType, unpackFlipY,
                                unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copyTexture(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                 destLevel, internalFormat, destType, unpackFlipY,
                                 unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopyTextureCHROMIUM, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
}

void GL_APIENTRY CopySubTextureCHROMIUM(GLuint sourceId,
                                        GLint sourceLevel,
                                        GLenum destTarget,
                                        GLuint destId,
                                        GLint destLevel,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint x,
                                        GLint y,
                                        GLint width,
                                        GLint height,
                                        GLboolean unpackFlipY,
                                        GLboolean unpackPremultiplyAlpha,
                                        GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopySubTextureCHROMIUM",
          "context = %d, GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = %s, "
          "GLuint destId = %u, GLint destLevel = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
          "x = %d, GLint y = %d, GLint width = %d, GLint height = %d, GLboolean unpackFlipY = %s, "
          "GLboolean unpackPremultiplyAlpha = %s, GLboolean unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, xoffset,
          yoffset, x, y, width, height, GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked                      = FromGL<TextureID>(sourceId);
        TextureTarget destTargetPacked                = FromGL<TextureTarget>(destTarget);
        TextureID destIdPacked                        = FromGL<TextureID>(destId);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopySubTextureCHROMIUM(
                                context, sourceIdPacked, sourceLevel, destTargetPacked,
                                destIdPacked, destLevel, xoffset, yoffset, x, y, width, height,
                                unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copySubTexture(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                    destLevel, xoffset, yoffset, x, y, width, height, unpackFlipY,
                                    unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopySubTextureCHROMIUM, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, x, y, width,
                      height, unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
}

// GL_CHROMIUM_framebuffer_mixed_samples
void GL_APIENTRY CoverageModulationCHROMIUM(GLenum components)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCoverageModulationCHROMIUM", "context = %d, GLenum components = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, components));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCoverageModulationCHROMIUM(context, components));
        if (isCallValid)
        {
            context->coverageModulation(components);
        }
        ANGLE_CAPTURE(CoverageModulationCHROMIUM, isCallValid, context, components);
    }
}

void GL_APIENTRY MatrixLoadfCHROMIUM(GLenum matrixMode, const GLfloat *matrix)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMatrixLoadfCHROMIUM",
          "context = %d, GLenum matrixMode = %s, const GLfloat * matrix = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, matrixMode), (uintptr_t)matrix);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMatrixLoadfCHROMIUM(context, matrixMode, matrix));
        if (isCallValid)
        {
            context->matrixLoadf(matrixMode, matrix);
        }
        ANGLE_CAPTURE(MatrixLoadfCHROMIUM, isCallValid, context, matrixMode, matrix);
    }
}

void GL_APIENTRY MatrixLoadIdentityCHROMIUM(GLenum matrixMode)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMatrixLoadIdentityCHROMIUM", "context = %d, GLenum matrixMode = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, matrixMode));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMatrixLoadIdentityCHROMIUM(context, matrixMode));
        if (isCallValid)
        {
            context->matrixLoadIdentity(matrixMode);
        }
        ANGLE_CAPTURE(MatrixLoadIdentityCHROMIUM, isCallValid, context, matrixMode);
    }
}

// GL_CHROMIUM_lose_context
void GL_APIENTRY LoseContextCHROMIUM(GLenum current, GLenum other)
{
    Context *context = GetValidGlobalContext();
    EVENT("glLoseContextCHROMIUM", "context = %d, GLenum current = %s, GLenum other = %s",
          CID(context), GLenumToString(GLenumGroup::GraphicsResetStatus, current),
          GLenumToString(GLenumGroup::GraphicsResetStatus, other));

    if (context)
    {
        GraphicsResetStatus currentPacked             = FromGL<GraphicsResetStatus>(current);
        GraphicsResetStatus otherPacked               = FromGL<GraphicsResetStatus>(other);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateLoseContextCHROMIUM(context, currentPacked, otherPacked));
        if (isCallValid)
        {
            context->loseContext(currentPacked, otherPacked);
        }
        ANGLE_CAPTURE(LoseContextCHROMIUM, isCallValid, context, currentPacked, otherPacked);
    }
}

// GL_CHROMIUM_path_rendering
GLuint GL_APIENTRY GenPathsCHROMIUM(GLsizei range)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenPathsCHROMIUM", "context = %d, GLsizei range = %d", CID(context), range);

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGenPathsCHROMIUM(context, range));
        if (isCallValid)
        {
            returnValue = context->genPaths(range);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GenPathsCHROMIUM, GLuint>();
        }
        ANGLE_CAPTURE(GenPathsCHROMIUM, isCallValid, context, range, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GenPathsCHROMIUM, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY DeletePathsCHROMIUM(GLuint first, GLsizei range)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeletePathsCHROMIUM", "context = %d, GLuint first = %u, GLsizei range = %d",
          CID(context), first, range);

    if (context)
    {
        PathID firstPacked                            = FromGL<PathID>(first);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeletePathsCHROMIUM(context, firstPacked, range));
        if (isCallValid)
        {
            context->deletePaths(firstPacked, range);
        }
        ANGLE_CAPTURE(DeletePathsCHROMIUM, isCallValid, context, firstPacked, range);
    }
}

GLboolean GL_APIENTRY IsPathCHROMIUM(GLuint path)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsPathCHROMIUM", "context = %d, GLuint path = %u", CID(context), path);

    GLboolean returnValue;
    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsPathCHROMIUM(context, pathPacked));
        if (isCallValid)
        {
            returnValue = context->isPath(pathPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsPathCHROMIUM, GLboolean>();
        }
        ANGLE_CAPTURE(IsPathCHROMIUM, isCallValid, context, pathPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsPathCHROMIUM, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY PathCommandsCHROMIUM(GLuint path,
                                      GLsizei numCommands,
                                      const GLubyte *commands,
                                      GLsizei numCoords,
                                      GLenum coordType,
                                      const void *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glPathCommandsCHROMIUM",
          "context = %d, GLuint path = %u, GLsizei numCommands = %d, const GLubyte * commands = "
          "0x%016" PRIxPTR
          ", GLsizei numCoords = %d, GLenum coordType = %s, const void* coords = 0x%016" PRIxPTR "",
          CID(context), path, numCommands, (uintptr_t)commands, numCoords,
          GLenumToString(GLenumGroup::DefaultGroup, coordType), (uintptr_t)coords);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePathCommandsCHROMIUM(context, pathPacked, numCommands, commands,
                                                         numCoords, coordType, coords));
        if (isCallValid)
        {
            context->pathCommands(pathPacked, numCommands, commands, numCoords, coordType, coords);
        }
        ANGLE_CAPTURE(PathCommandsCHROMIUM, isCallValid, context, pathPacked, numCommands, commands,
                      numCoords, coordType, coords);
    }
}

void GL_APIENTRY PathParameterfCHROMIUM(GLuint path, GLenum pname, GLfloat value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glPathParameterfCHROMIUM",
          "context = %d, GLuint path = %u, GLenum pname = %s, GLfloat value = %f", CID(context),
          path, GLenumToString(GLenumGroup::DefaultGroup, pname), value);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePathParameterfCHROMIUM(context, pathPacked, pname, value));
        if (isCallValid)
        {
            context->pathParameterf(pathPacked, pname, value);
        }
        ANGLE_CAPTURE(PathParameterfCHROMIUM, isCallValid, context, pathPacked, pname, value);
    }
}

void GL_APIENTRY PathParameteriCHROMIUM(GLuint path, GLenum pname, GLint value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glPathParameteriCHROMIUM",
          "context = %d, GLuint path = %u, GLenum pname = %s, GLint value = %d", CID(context), path,
          GLenumToString(GLenumGroup::DefaultGroup, pname), value);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePathParameteriCHROMIUM(context, pathPacked, pname, value));
        if (isCallValid)
        {
            context->pathParameteri(pathPacked, pname, value);
        }
        ANGLE_CAPTURE(PathParameteriCHROMIUM, isCallValid, context, pathPacked, pname, value);
    }
}

void GL_APIENTRY GetPathParameterfvCHROMIUM(GLuint path, GLenum pname, GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetPathParameterfvCHROMIUM",
          "context = %d, GLuint path = %u, GLenum pname = %s, GLfloat * value = 0x%016" PRIxPTR "",
          CID(context), path, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)value);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetPathParameterfvCHROMIUM(context, pathPacked, pname, value));
        if (isCallValid)
        {
            context->getPathParameterfv(pathPacked, pname, value);
        }
        ANGLE_CAPTURE(GetPathParameterfvCHROMIUM, isCallValid, context, pathPacked, pname, value);
    }
}

void GL_APIENTRY GetPathParameterivCHROMIUM(GLuint path, GLenum pname, GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetPathParameterivCHROMIUM",
          "context = %d, GLuint path = %u, GLenum pname = %s, GLint * value = 0x%016" PRIxPTR "",
          CID(context), path, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)value);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetPathParameterivCHROMIUM(context, pathPacked, pname, value));
        if (isCallValid)
        {
            context->getPathParameteriv(pathPacked, pname, value);
        }
        ANGLE_CAPTURE(GetPathParameterivCHROMIUM, isCallValid, context, pathPacked, pname, value);
    }
}

void GL_APIENTRY PathStencilFuncCHROMIUM(GLenum func, GLint ref, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT("glPathStencilFuncCHROMIUM",
          "context = %d, GLenum func = %s, GLint ref = %d, GLuint mask = %u", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, func), ref, mask);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePathStencilFuncCHROMIUM(context, func, ref, mask));
        if (isCallValid)
        {
            context->pathStencilFunc(func, ref, mask);
        }
        ANGLE_CAPTURE(PathStencilFuncCHROMIUM, isCallValid, context, func, ref, mask);
    }
}

void GL_APIENTRY StencilFillPathCHROMIUM(GLuint path, GLenum fillMode, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilFillPathCHROMIUM",
          "context = %d, GLuint path = %u, GLenum fillMode = %s, GLuint mask = %u", CID(context),
          path, GLenumToString(GLenumGroup::DefaultGroup, fillMode), mask);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilFillPathCHROMIUM(context, pathPacked, fillMode, mask));
        if (isCallValid)
        {
            context->stencilFillPath(pathPacked, fillMode, mask);
        }
        ANGLE_CAPTURE(StencilFillPathCHROMIUM, isCallValid, context, pathPacked, fillMode, mask);
    }
}

void GL_APIENTRY StencilStrokePathCHROMIUM(GLuint path, GLint reference, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilStrokePathCHROMIUM",
          "context = %d, GLuint path = %u, GLint reference = %d, GLuint mask = %u", CID(context),
          path, reference, mask);

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateStencilStrokePathCHROMIUM(
                                                             context, pathPacked, reference, mask));
        if (isCallValid)
        {
            context->stencilStrokePath(pathPacked, reference, mask);
        }
        ANGLE_CAPTURE(StencilStrokePathCHROMIUM, isCallValid, context, pathPacked, reference, mask);
    }
}

void GL_APIENTRY CoverFillPathCHROMIUM(GLuint path, GLenum coverMode)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCoverFillPathCHROMIUM", "context = %d, GLuint path = %u, GLenum coverMode = %s",
          CID(context), path, GLenumToString(GLenumGroup::DefaultGroup, coverMode));

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCoverFillPathCHROMIUM(context, pathPacked, coverMode));
        if (isCallValid)
        {
            context->coverFillPath(pathPacked, coverMode);
        }
        ANGLE_CAPTURE(CoverFillPathCHROMIUM, isCallValid, context, pathPacked, coverMode);
    }
}

void GL_APIENTRY CoverStrokePathCHROMIUM(GLuint path, GLenum coverMode)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCoverStrokePathCHROMIUM", "context = %d, GLuint path = %u, GLenum coverMode = %s",
          CID(context), path, GLenumToString(GLenumGroup::DefaultGroup, coverMode));

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCoverStrokePathCHROMIUM(context, pathPacked, coverMode));
        if (isCallValid)
        {
            context->coverStrokePath(pathPacked, coverMode);
        }
        ANGLE_CAPTURE(CoverStrokePathCHROMIUM, isCallValid, context, pathPacked, coverMode);
    }
}

void GL_APIENTRY StencilThenCoverFillPathCHROMIUM(GLuint path,
                                                  GLenum fillMode,
                                                  GLuint mask,
                                                  GLenum coverMode)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilThenCoverFillPathCHROMIUM",
          "context = %d, GLuint path = %u, GLenum fillMode = %s, GLuint mask = %u, GLenum "
          "coverMode = %s",
          CID(context), path, GLenumToString(GLenumGroup::DefaultGroup, fillMode), mask,
          GLenumToString(GLenumGroup::DefaultGroup, coverMode));

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilThenCoverFillPathCHROMIUM(
                                              context, pathPacked, fillMode, mask, coverMode));
        if (isCallValid)
        {
            context->stencilThenCoverFillPath(pathPacked, fillMode, mask, coverMode);
        }
        ANGLE_CAPTURE(StencilThenCoverFillPathCHROMIUM, isCallValid, context, pathPacked, fillMode,
                      mask, coverMode);
    }
}

void GL_APIENTRY StencilThenCoverStrokePathCHROMIUM(GLuint path,
                                                    GLint reference,
                                                    GLuint mask,
                                                    GLenum coverMode)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilThenCoverStrokePathCHROMIUM",
          "context = %d, GLuint path = %u, GLint reference = %d, GLuint mask = %u, GLenum "
          "coverMode = %s",
          CID(context), path, reference, mask,
          GLenumToString(GLenumGroup::DefaultGroup, coverMode));

    if (context)
    {
        PathID pathPacked                             = FromGL<PathID>(path);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilThenCoverStrokePathCHROMIUM(
                                              context, pathPacked, reference, mask, coverMode));
        if (isCallValid)
        {
            context->stencilThenCoverStrokePath(pathPacked, reference, mask, coverMode);
        }
        ANGLE_CAPTURE(StencilThenCoverStrokePathCHROMIUM, isCallValid, context, pathPacked,
                      reference, mask, coverMode);
    }
}

void GL_APIENTRY CoverFillPathInstancedCHROMIUM(GLsizei numPath,
                                                GLenum pathNameType,
                                                const void *paths,
                                                GLuint pathBase,
                                                GLenum coverMode,
                                                GLenum transformType,
                                                const GLfloat *transformValues)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCoverFillPathInstancedCHROMIUM",
          "context = %d, GLsizei numPath = %d, GLenum pathNameType = %s, const void * paths = "
          "0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum coverMode = %s, GLenum transformType = %s, const GLfloat "
          "* transformValues = 0x%016" PRIxPTR "",
          CID(context), numPath, GLenumToString(GLenumGroup::DefaultGroup, pathNameType),
          (uintptr_t)paths, pathBase, GLenumToString(GLenumGroup::DefaultGroup, coverMode),
          GLenumToString(GLenumGroup::DefaultGroup, transformType), (uintptr_t)transformValues);

    if (context)
    {
        PathID pathBasePacked                         = FromGL<PathID>(pathBase);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCoverFillPathInstancedCHROMIUM(
                                              context, numPath, pathNameType, paths, pathBasePacked,
                                              coverMode, transformType, transformValues));
        if (isCallValid)
        {
            context->coverFillPathInstanced(numPath, pathNameType, paths, pathBasePacked, coverMode,
                                            transformType, transformValues);
        }
        ANGLE_CAPTURE(CoverFillPathInstancedCHROMIUM, isCallValid, context, numPath, pathNameType,
                      paths, pathBasePacked, coverMode, transformType, transformValues);
    }
}

void GL_APIENTRY CoverStrokePathInstancedCHROMIUM(GLsizei numPath,
                                                  GLenum pathNameType,
                                                  const void *paths,
                                                  GLuint pathBase,
                                                  GLenum coverMode,
                                                  GLenum transformType,
                                                  const GLfloat *transformValues)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCoverStrokePathInstancedCHROMIUM",
          "context = %d, GLsizei numPath = %d, GLenum pathNameType = %s, const void * paths = "
          "0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum coverMode = %s, GLenum transformType = %s, const GLfloat "
          "* transformValues = 0x%016" PRIxPTR "",
          CID(context), numPath, GLenumToString(GLenumGroup::DefaultGroup, pathNameType),
          (uintptr_t)paths, pathBase, GLenumToString(GLenumGroup::DefaultGroup, coverMode),
          GLenumToString(GLenumGroup::DefaultGroup, transformType), (uintptr_t)transformValues);

    if (context)
    {
        PathID pathBasePacked                         = FromGL<PathID>(pathBase);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCoverStrokePathInstancedCHROMIUM(
                                              context, numPath, pathNameType, paths, pathBasePacked,
                                              coverMode, transformType, transformValues));
        if (isCallValid)
        {
            context->coverStrokePathInstanced(numPath, pathNameType, paths, pathBasePacked,
                                              coverMode, transformType, transformValues);
        }
        ANGLE_CAPTURE(CoverStrokePathInstancedCHROMIUM, isCallValid, context, numPath, pathNameType,
                      paths, pathBasePacked, coverMode, transformType, transformValues);
    }
}

void GL_APIENTRY StencilStrokePathInstancedCHROMIUM(GLsizei numPath,
                                                    GLenum pathNameType,
                                                    const void *paths,
                                                    GLuint pathBase,
                                                    GLint reference,
                                                    GLuint mask,
                                                    GLenum transformType,
                                                    const GLfloat *transformValues)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilStrokePathInstancedCHROMIUM",
          "context = %d, GLsizei numPath = %d, GLenum pathNameType = %s, const void * paths = "
          "0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLint reference = %d, GLuint mask = %u, GLenum transformType = "
          "%s, const GLfloat * transformValues = 0x%016" PRIxPTR "",
          CID(context), numPath, GLenumToString(GLenumGroup::DefaultGroup, pathNameType),
          (uintptr_t)paths, pathBase, reference, mask,
          GLenumToString(GLenumGroup::DefaultGroup, transformType), (uintptr_t)transformValues);

    if (context)
    {
        PathID pathBasePacked                         = FromGL<PathID>(pathBase);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilStrokePathInstancedCHROMIUM(
                                              context, numPath, pathNameType, paths, pathBasePacked,
                                              reference, mask, transformType, transformValues));
        if (isCallValid)
        {
            context->stencilStrokePathInstanced(numPath, pathNameType, paths, pathBasePacked,
                                                reference, mask, transformType, transformValues);
        }
        ANGLE_CAPTURE(StencilStrokePathInstancedCHROMIUM, isCallValid, context, numPath,
                      pathNameType, paths, pathBasePacked, reference, mask, transformType,
                      transformValues);
    }
}

void GL_APIENTRY StencilFillPathInstancedCHROMIUM(GLsizei numPaths,
                                                  GLenum pathNameType,
                                                  const void *paths,
                                                  GLuint pathBase,
                                                  GLenum fillMode,
                                                  GLuint mask,
                                                  GLenum transformType,
                                                  const GLfloat *transformValues)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilFillPathInstancedCHROMIUM",
          "context = %d, GLsizei numPaths = %d, GLenum pathNameType = %s, const void * paths = "
          "0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum fillMode = %s, GLuint mask = %u, GLenum transformType = "
          "%s, const GLfloat * transformValues = 0x%016" PRIxPTR "",
          CID(context), numPaths, GLenumToString(GLenumGroup::DefaultGroup, pathNameType),
          (uintptr_t)paths, pathBase, GLenumToString(GLenumGroup::DefaultGroup, fillMode), mask,
          GLenumToString(GLenumGroup::DefaultGroup, transformType), (uintptr_t)transformValues);

    if (context)
    {
        PathID pathBasePacked                         = FromGL<PathID>(pathBase);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilFillPathInstancedCHROMIUM(
                                context, numPaths, pathNameType, paths, pathBasePacked, fillMode,
                                mask, transformType, transformValues));
        if (isCallValid)
        {
            context->stencilFillPathInstanced(numPaths, pathNameType, paths, pathBasePacked,
                                              fillMode, mask, transformType, transformValues);
        }
        ANGLE_CAPTURE(StencilFillPathInstancedCHROMIUM, isCallValid, context, numPaths,
                      pathNameType, paths, pathBasePacked, fillMode, mask, transformType,
                      transformValues);
    }
}

void GL_APIENTRY StencilThenCoverFillPathInstancedCHROMIUM(GLsizei numPaths,
                                                           GLenum pathNameType,
                                                           const void *paths,
                                                           GLuint pathBase,
                                                           GLenum fillMode,
                                                           GLuint mask,
                                                           GLenum coverMode,
                                                           GLenum transformType,
                                                           const GLfloat *transformValues)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilThenCoverFillPathInstancedCHROMIUM",
          "context = %d, GLsizei numPaths = %d, GLenum pathNameType = %s, const void * paths = "
          "0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum fillMode = %s, GLuint mask = %u, GLenum coverMode = %s, "
          "GLenum transformType = %s, const GLfloat * transformValues = 0x%016" PRIxPTR "",
          CID(context), numPaths, GLenumToString(GLenumGroup::DefaultGroup, pathNameType),
          (uintptr_t)paths, pathBase, GLenumToString(GLenumGroup::DefaultGroup, fillMode), mask,
          GLenumToString(GLenumGroup::DefaultGroup, coverMode),
          GLenumToString(GLenumGroup::DefaultGroup, transformType), (uintptr_t)transformValues);

    if (context)
    {
        PathID pathBasePacked                         = FromGL<PathID>(pathBase);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilThenCoverFillPathInstancedCHROMIUM(
                                context, numPaths, pathNameType, paths, pathBasePacked, fillMode,
                                mask, coverMode, transformType, transformValues));
        if (isCallValid)
        {
            context->stencilThenCoverFillPathInstanced(numPaths, pathNameType, paths,
                                                       pathBasePacked, fillMode, mask, coverMode,
                                                       transformType, transformValues);
        }
        ANGLE_CAPTURE(StencilThenCoverFillPathInstancedCHROMIUM, isCallValid, context, numPaths,
                      pathNameType, paths, pathBasePacked, fillMode, mask, coverMode, transformType,
                      transformValues);
    }
}

void GL_APIENTRY StencilThenCoverStrokePathInstancedCHROMIUM(GLsizei numPaths,
                                                             GLenum pathNameType,
                                                             const void *paths,
                                                             GLuint pathBase,
                                                             GLint reference,
                                                             GLuint mask,
                                                             GLenum coverMode,
                                                             GLenum transformType,
                                                             const GLfloat *transformValues)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilThenCoverStrokePathInstancedCHROMIUM",
          "context = %d, GLsizei numPaths = %d, GLenum pathNameType = %s, const void * paths = "
          "0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLint reference = %d, GLuint mask = %u, GLenum coverMode = %s, "
          "GLenum transformType = %s, const GLfloat * transformValues = 0x%016" PRIxPTR "",
          CID(context), numPaths, GLenumToString(GLenumGroup::DefaultGroup, pathNameType),
          (uintptr_t)paths, pathBase, reference, mask,
          GLenumToString(GLenumGroup::DefaultGroup, coverMode),
          GLenumToString(GLenumGroup::DefaultGroup, transformType), (uintptr_t)transformValues);

    if (context)
    {
        PathID pathBasePacked                         = FromGL<PathID>(pathBase);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilThenCoverStrokePathInstancedCHROMIUM(
                                context, numPaths, pathNameType, paths, pathBasePacked, reference,
                                mask, coverMode, transformType, transformValues));
        if (isCallValid)
        {
            context->stencilThenCoverStrokePathInstanced(numPaths, pathNameType, paths,
                                                         pathBasePacked, reference, mask, coverMode,
                                                         transformType, transformValues);
        }
        ANGLE_CAPTURE(StencilThenCoverStrokePathInstancedCHROMIUM, isCallValid, context, numPaths,
                      pathNameType, paths, pathBasePacked, reference, mask, coverMode,
                      transformType, transformValues);
    }
}

void GL_APIENTRY BindFragmentInputLocationCHROMIUM(GLuint programs,
                                                   GLint location,
                                                   const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindFragmentInputLocationCHROMIUM",
          "context = %d, GLuint programs = %u, GLint location = %d, const GLchar * name = "
          "0x%016" PRIxPTR "",
          CID(context), programs, location, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programsPacked                = FromGL<ShaderProgramID>(programs);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindFragmentInputLocationCHROMIUM(context, programsPacked, location, name));
        if (isCallValid)
        {
            context->bindFragmentInputLocation(programsPacked, location, name);
        }
        ANGLE_CAPTURE(BindFragmentInputLocationCHROMIUM, isCallValid, context, programsPacked,
                      location, name);
    }
}

void GL_APIENTRY ProgramPathFragmentInputGenCHROMIUM(GLuint program,
                                                     GLint location,
                                                     GLenum genMode,
                                                     GLint components,
                                                     const GLfloat *coeffs)
{
    Context *context = GetValidGlobalContext();
    EVENT("glProgramPathFragmentInputGenCHROMIUM",
          "context = %d, GLuint program = %u, GLint location = %d, GLenum genMode = %s, GLint "
          "components = %d, const GLfloat * coeffs = 0x%016" PRIxPTR "",
          CID(context), program, location, GLenumToString(GLenumGroup::DefaultGroup, genMode),
          components, (uintptr_t)coeffs);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramPathFragmentInputGenCHROMIUM(
                                context, programPacked, location, genMode, components, coeffs));
        if (isCallValid)
        {
            context->programPathFragmentInputGen(programPacked, location, genMode, components,
                                                 coeffs);
        }
        ANGLE_CAPTURE(ProgramPathFragmentInputGenCHROMIUM, isCallValid, context, programPacked,
                      location, genMode, components, coeffs);
    }
}

// GL_EXT_blend_func_extended
void GL_APIENTRY BindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glBindFragDataLocationEXT",
        "context = %d, GLuint program = %u, GLuint color = %u, const GLchar *name = 0x%016" PRIxPTR
        "",
        CID(context), program, color, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindFragDataLocationEXT(context, programPacked, color, name));
        if (isCallValid)
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationEXT, isCallValid, context, programPacked, color, name);
    }
}

void GL_APIENTRY BindFragDataLocationIndexedEXT(GLuint program,
                                                GLuint colorNumber,
                                                GLuint index,
                                                const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindFragDataLocationIndexedEXT",
          "context = %d, GLuint program = %u, GLuint colorNumber = %u, GLuint index = %u, const "
          "GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindFragDataLocationIndexedEXT(
                                              context, programPacked, colorNumber, index, name));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationIndexedEXT, isCallValid, context, programPacked,
                      colorNumber, index, name);
    }
}

GLint GL_APIENTRY GetFragDataIndexEXT(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFragDataIndexEXT",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFragDataIndexEXT(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndexEXT, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataIndexEXT, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndexEXT, GLint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GetProgramResourceLocationIndexEXT(GLuint program,
                                                     GLenum programInterface,
                                                     const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetProgramResourceLocationIndexEXT",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, const GLchar *name = "
          "0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramResourceLocationIndexEXT(
                                              context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocationIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<EntryPoint::GetProgramResourceLocationIndexEXT, GLint>();
        }
        ANGLE_CAPTURE(GetProgramResourceLocationIndexEXT, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        returnValue =
            GetDefaultReturnValue<EntryPoint::GetProgramResourceLocationIndexEXT, GLint>();
    }
    return returnValue;
}

// GL_EXT_debug_marker
void GL_APIENTRY InsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("glInsertEventMarkerEXT", "context = %d, GLsizei length = %d, const GLchar *marker =
    // 0x%016" PRIxPTR "", CID(context), length, (uintptr_t)marker);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->insertEventMarker(length, marker);
        }
        ANGLE_CAPTURE(InsertEventMarkerEXT, isCallValid, context, length, marker);
    }
}

void GL_APIENTRY PopGroupMarkerEXT()
{
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("glPopGroupMarkerEXT", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopGroupMarkerEXT(context));
        if (isCallValid)
        {
            context->popGroupMarker();
        }
        ANGLE_CAPTURE(PopGroupMarkerEXT, isCallValid, context);
    }
}

void GL_APIENTRY PushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("glPushGroupMarkerEXT", "context = %d, GLsizei length = %d, const GLchar *marker =
    // 0x%016" PRIxPTR "", CID(context), length, (uintptr_t)marker);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePushGroupMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->pushGroupMarker(length, marker);
        }
        ANGLE_CAPTURE(PushGroupMarkerEXT, isCallValid, context, length, marker);
    }
}

// GL_EXT_discard_framebuffer
void GL_APIENTRY DiscardFramebufferEXT(GLenum target,
                                       GLsizei numAttachments,
                                       const GLenum *attachments)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDiscardFramebufferEXT",
          "context = %d, GLenum target = %s, GLsizei numAttachments = %d, const GLenum "
          "*attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), numAttachments,
          (uintptr_t)attachments);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments));
        if (isCallValid)
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE(DiscardFramebufferEXT, isCallValid, context, target, numAttachments,
                      attachments);
    }
}

// GL_EXT_disjoint_timer_query
void GL_APIENTRY BeginQueryEXT(GLenum target, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBeginQueryEXT", "context = %d, GLenum target = %s, GLuint id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context)
    {
        QueryType targetPacked                        = FromGL<QueryType>(target);
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginQueryEXT(context, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE(BeginQueryEXT, isCallValid, context, targetPacked, idPacked);
    }
}

void GL_APIENTRY DeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteQueriesEXT",
          "context = %d, GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context)
    {
        const QueryID *idsPacked                      = FromGL<const QueryID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteQueriesEXT, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY EndQueryEXT(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glEndQueryEXT", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEndQueryEXT(context, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE(EndQueryEXT, isCallValid, context, targetPacked);
    }
}

void GL_APIENTRY GenQueriesEXT(GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenQueriesEXT", "context = %d, GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context)
    {
        QueryID *idsPacked                            = FromGL<QueryID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(GenQueriesEXT, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY GetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetQueryObjecti64vEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLint64 *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjecti64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64vEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectivEXT(GLuint id, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetQueryObjectivEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectivEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryObjectui64vEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLuint64 *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectui64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64vEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryObjectuivEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectuivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuivEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryivEXT",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryivEXT, isCallValid, context, targetPacked, pname, params);
    }
}

GLboolean GL_APIENTRY IsQueryEXT(GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsQueryEXT", "context = %d, GLuint id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsQueryEXT(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsQueryEXT, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY QueryCounterEXT(GLuint id, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glQueryCounterEXT", "context = %d, GLuint id = %u, GLenum target = %s", CID(context), id,
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryID idPacked                              = FromGL<QueryID>(id);
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryCounterEXT(context, idPacked, targetPacked));
        if (isCallValid)
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE(QueryCounterEXT, isCallValid, context, idPacked, targetPacked);
    }
}

// GL_EXT_draw_buffers
void GL_APIENTRY DrawBuffersEXT(GLsizei n, const GLenum *bufs)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawBuffersEXT",
          "context = %d, GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)bufs);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffersEXT, isCallValid, context, n, bufs);
    }
}

// GL_EXT_draw_elements_base_vertex
void GL_APIENTRY DrawElementsBaseVertexEXT(GLenum mode,
                                           GLsizei count,
                                           GLenum type,
                                           const void *indices,
                                           GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsBaseVertexEXT",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexEXT(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertexEXT(GLenum mode,
                                                    GLsizei count,
                                                    GLenum type,
                                                    const void *indices,
                                                    GLsizei instancecount,
                                                    GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsInstancedBaseVertexEXT",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei instancecount = %d, GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
}

void GL_APIENTRY DrawRangeElementsBaseVertexEXT(GLenum mode,
                                                GLuint start,
                                                GLuint end,
                                                GLsizei count,
                                                GLenum type,
                                                const void *indices,
                                                GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawRangeElementsBaseVertexEXT",
          "context = %d, GLenum mode = %s, GLuint start = %u, GLuint end = %u, GLsizei count = %d, "
          "GLenum type = %s, const void *indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexEXT(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexEXT, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
}

void GL_APIENTRY MultiDrawElementsBaseVertexEXT(GLenum mode,
                                                const GLsizei *count,
                                                GLenum type,
                                                const void *const *indices,
                                                GLsizei primcount,
                                                const GLint *basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMultiDrawElementsBaseVertexEXT",
          "context = %d, GLenum mode = %s, const GLsizei *count = 0x%016" PRIxPTR
          ", GLenum type = %s, const void *const*indices = 0x%016" PRIxPTR
          ", GLsizei primcount = %d, const GLint *basevertex = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount,
          (uintptr_t)basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultiDrawElementsBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, primcount, basevertex));
        if (isCallValid)
        {
            context->multiDrawElementsBaseVertex(modePacked, count, typePacked, indices, primcount,
                                                 basevertex);
        }
        ANGLE_CAPTURE(MultiDrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount, basevertex);
    }
}

// GL_EXT_geometry_shader
void GL_APIENTRY FramebufferTextureEXT(GLenum target,
                                       GLenum attachment,
                                       GLuint texture,
                                       GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFramebufferTextureEXT",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLuint texture = %u, GLint "
          "level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureEXT(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTextureEXT, isCallValid, context, target, attachment,
                      texturePacked, level);
    }
}

// GL_EXT_instanced_arrays
void GL_APIENTRY DrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawArraysInstancedEXT",
          "context = %d, GLenum mode = %s, GLint start = %d, GLsizei count = %d, GLsizei primcount "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, count, primcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedEXT(context, modePacked, start, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedEXT, isCallValid, context, modePacked, start, count,
                      primcount);
    }
}

void GL_APIENTRY DrawElementsInstancedEXT(GLenum mode,
                                          GLsizei count,
                                          GLenum type,
                                          const void *indices,
                                          GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsInstancedEXT",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsInstancedEXT(context, modePacked, count, typePacked,
                                                             indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedEXT, isCallValid, context, modePacked, count, typePacked,
                      indices, primcount);
    }
}

void GL_APIENTRY VertexAttribDivisorEXT(GLuint index, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribDivisorEXT", "context = %d, GLuint index = %u, GLuint divisor = %u",
          CID(context), index, divisor);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribDivisorEXT(context, index, divisor));
        if (isCallValid)
        {
            context->vertexAttribDivisor(index, divisor);
        }
        ANGLE_CAPTURE(VertexAttribDivisorEXT, isCallValid, context, index, divisor);
    }
}

// GL_EXT_map_buffer_range
void GL_APIENTRY FlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFlushMappedBufferRangeEXT",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr length = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRangeEXT, isCallValid, context, targetPacked, offset,
                      length);
    }
}

void *GL_APIENTRY MapBufferRangeEXT(GLenum target,
                                    GLintptr offset,
                                    GLsizeiptr length,
                                    GLbitfield access)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMapBufferRangeEXT",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr length = %llu, "
          "GLbitfield access = %s",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
        }
        ANGLE_CAPTURE(MapBufferRangeEXT, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
    }
    return returnValue;
}

// GL_EXT_memory_object
void GL_APIENTRY BufferStorageMemEXT(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBufferStorageMemEXT",
          "context = %d, GLenum target = %s, GLsizeiptr size = %llu, GLuint memory = %u, GLuint64 "
          "offset = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBufferStorageMemEXT(context, targetPacked, size, memoryPacked, offset));
        if (isCallValid)
        {
            context->bufferStorageMem(targetPacked, size, memoryPacked, offset);
        }
        ANGLE_CAPTURE(BufferStorageMemEXT, isCallValid, context, targetPacked, size, memoryPacked,
                      offset);
    }
}

void GL_APIENTRY CreateMemoryObjectsEXT(GLsizei n, GLuint *memoryObjects)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateMemoryObjectsEXT",
          "context = %d, GLsizei n = %d, GLuint *memoryObjects = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)memoryObjects);

    if (context)
    {
        MemoryObjectID *memoryObjectsPacked           = FromGL<MemoryObjectID *>(memoryObjects);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCreateMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->createMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(CreateMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
}

void GL_APIENTRY DeleteMemoryObjectsEXT(GLsizei n, const GLuint *memoryObjects)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteMemoryObjectsEXT",
          "context = %d, GLsizei n = %d, const GLuint *memoryObjects = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)memoryObjects);

    if (context)
    {
        const MemoryObjectID *memoryObjectsPacked = FromGL<const MemoryObjectID *>(memoryObjects);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->deleteMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(DeleteMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
}

void GL_APIENTRY GetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetMemoryObjectParameterivEXT",
        "context = %d, GLuint memoryObject = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
        (uintptr_t)params);

    if (context)
    {
        MemoryObjectID memoryObjectPacked             = FromGL<MemoryObjectID>(memoryObject);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->getMemoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(GetMemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked,
                      pname, params);
    }
}

void GL_APIENTRY GetUnsignedBytevEXT(GLenum pname, GLubyte *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUnsignedBytevEXT",
          "context = %d, GLenum pname = %s, GLubyte *data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUnsignedBytevEXT(context, pname, data));
        if (isCallValid)
        {
            context->getUnsignedBytev(pname, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytevEXT, isCallValid, context, pname, data);
    }
}

void GL_APIENTRY GetUnsignedBytei_vEXT(GLenum target, GLuint index, GLubyte *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUnsignedBytei_vEXT",
          "context = %d, GLenum target = %s, GLuint index = %u, GLubyte *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUnsignedBytei_vEXT(context, target, index, data));
        if (isCallValid)
        {
            context->getUnsignedBytei_v(target, index, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytei_vEXT, isCallValid, context, target, index, data);
    }
}

GLboolean GL_APIENTRY IsMemoryObjectEXT(GLuint memoryObject)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsMemoryObjectEXT", "context = %d, GLuint memoryObject = %u", CID(context),
          memoryObject);

    GLboolean returnValue;
    if (context)
    {
        MemoryObjectID memoryObjectPacked             = FromGL<MemoryObjectID>(memoryObject);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsMemoryObjectEXT(context, memoryObjectPacked));
        if (isCallValid)
        {
            returnValue = context->isMemoryObject(memoryObjectPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsMemoryObjectEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsMemoryObjectEXT, isCallValid, context, memoryObjectPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsMemoryObjectEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY MemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMemoryObjectParameterivEXT",
          "context = %d, GLuint memoryObject = %u, GLenum pname = %s, const GLint *params = "
          "0x%016" PRIxPTR "",
          CID(context), memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        MemoryObjectID memoryObjectPacked             = FromGL<MemoryObjectID>(memoryObject);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->memoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(MemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked, pname,
                      params);
    }
}

void GL_APIENTRY TexStorageMem2DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalFormat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLuint memory,
                                    GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorageMem2DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLuint memory = %u, GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, memory,
          static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMem2DEXT(context, targetPacked, levels, internalFormat, width,
                                        height, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem2D(targetPacked, levels, internalFormat, width, height,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem2DEXT, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, memoryPacked, offset);
    }
}

void GL_APIENTRY TexStorageMem2DMultisampleEXT(GLenum target,
                                               GLsizei samples,
                                               GLenum internalFormat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLboolean fixedSampleLocations,
                                               GLuint memory,
                                               GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorageMem2DMultisampleEXT",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLboolean fixedSampleLocations = %s, GLuint "
          "memory = %u, GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexStorageMem2DMultisampleEXT(
                                              context, targetPacked, samples, internalFormat, width,
                                              height, fixedSampleLocations, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem2DMultisample(targetPacked, samples, internalFormat, width,
                                                height, fixedSampleLocations, memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem2DMultisampleEXT, isCallValid, context, targetPacked, samples,
                      internalFormat, width, height, fixedSampleLocations, memoryPacked, offset);
    }
}

void GL_APIENTRY TexStorageMem3DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalFormat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLuint memory,
                                    GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorageMem3DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLuint memory = %u, "
          "GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth, memory,
          static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMem3DEXT(context, targetPacked, levels, internalFormat, width,
                                        height, depth, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem3D(targetPacked, levels, internalFormat, width, height, depth,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem3DEXT, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, depth, memoryPacked, offset);
    }
}

void GL_APIENTRY TexStorageMem3DMultisampleEXT(GLenum target,
                                               GLsizei samples,
                                               GLenum internalFormat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLboolean fixedSampleLocations,
                                               GLuint memory,
                                               GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorageMem3DMultisampleEXT",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLboolean "
          "fixedSampleLocations = %s, GLuint memory = %u, GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexStorageMem3DMultisampleEXT(
                                context, targetPacked, samples, internalFormat, width, height,
                                depth, fixedSampleLocations, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem3DMultisample(targetPacked, samples, internalFormat, width,
                                                height, depth, fixedSampleLocations, memoryPacked,
                                                offset);
        }
        ANGLE_CAPTURE(TexStorageMem3DMultisampleEXT, isCallValid, context, targetPacked, samples,
                      internalFormat, width, height, depth, fixedSampleLocations, memoryPacked,
                      offset);
    }
}

// GL_EXT_memory_object_fd
void GL_APIENTRY ImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)
{
    Context *context = GetValidGlobalContext();
    EVENT("glImportMemoryFdEXT",
          "context = %d, GLuint memory = %u, GLuint64 size = %llu, GLenum handleType = %s, GLint "
          "fd = %d",
          CID(context), memory, static_cast<unsigned long long>(size),
          GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context)
    {
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        HandleType handleTypePacked                   = FromGL<HandleType>(handleType);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportMemoryFdEXT(context, memoryPacked, size, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importMemoryFd(memoryPacked, size, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportMemoryFdEXT, isCallValid, context, memoryPacked, size, handleTypePacked,
                      fd);
    }
}

// GL_EXT_multisampled_render_to_texture
void GL_APIENTRY FramebufferTexture2DMultisampleEXT(GLenum target,
                                                    GLenum attachment,
                                                    GLenum textarget,
                                                    GLuint texture,
                                                    GLint level,
                                                    GLsizei samples)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFramebufferTexture2DMultisampleEXT",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d, GLsizei samples = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, samples);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferTexture2DMultisampleEXT(
                                context, target, attachment, textarget, texture, level, samples));
        if (isCallValid)
        {
            context->framebufferTexture2DMultisample(target, attachment, textarget, texture, level,
                                                     samples);
        }
        ANGLE_CAPTURE(FramebufferTexture2DMultisampleEXT, isCallValid, context, target, attachment,
                      textarget, texture, level, samples);
    }
}

void GL_APIENTRY RenderbufferStorageMultisampleEXT(GLenum target,
                                                   GLsizei samples,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glRenderbufferStorageMultisampleEXT",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisampleEXT(
                                context, target, samples, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisampleEXT, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
}

// GL_EXT_occlusion_query_boolean
// BeginQueryEXT is already defined.

// DeleteQueriesEXT is already defined.

// EndQueryEXT is already defined.

// GenQueriesEXT is already defined.

// GetQueryObjectuivEXT is already defined.

// GetQueryivEXT is already defined.

// IsQueryEXT is already defined.

// GL_EXT_read_format_bgra

// GL_EXT_robustness
GLenum GL_APIENTRY GetGraphicsResetStatusEXT()
{
    Context *context = GetGlobalContext();
    EVENT("glGetGraphicsResetStatusEXT", "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatusEXT, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformfvEXT",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfvEXT(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfvEXT, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformivEXT",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformivEXT(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformivEXT, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY ReadnPixelsEXT(GLint x,
                                GLint y,
                                GLsizei width,
                                GLsizei height,
                                GLenum format,
                                GLenum type,
                                GLsizei bufSize,
                                void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glReadnPixelsEXT",
          "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, "
          "GLenum format = %s, GLenum type = %s, GLsizei bufSize = %d, void *data = 0x%016" PRIxPTR
          "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixelsEXT(context, x, y, width, height, format, type, bufSize, data));
        if (isCallValid)
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE(ReadnPixelsEXT, isCallValid, context, x, y, width, height, format, type,
                      bufSize, data);
    }
}

// GL_EXT_sRGB

// GL_EXT_semaphore
void GL_APIENTRY DeleteSemaphoresEXT(GLsizei n, const GLuint *semaphores)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteSemaphoresEXT",
          "context = %d, GLsizei n = %d, const GLuint *semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (context)
    {
        const SemaphoreID *semaphoresPacked           = FromGL<const SemaphoreID *>(semaphores);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->deleteSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(DeleteSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
}

void GL_APIENTRY GenSemaphoresEXT(GLsizei n, GLuint *semaphores)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenSemaphoresEXT",
          "context = %d, GLsizei n = %d, GLuint *semaphores = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)semaphores);

    if (context)
    {
        SemaphoreID *semaphoresPacked                 = FromGL<SemaphoreID *>(semaphores);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->genSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(GenSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
}

void GL_APIENTRY GetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetSemaphoreParameterui64vEXT",
        "context = %d, GLuint semaphore = %u, GLenum pname = %s, GLuint64 *params = 0x%016" PRIxPTR
        "",
        CID(context), semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname),
        (uintptr_t)params);

    if (context)
    {
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->getSemaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(GetSemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
}

GLboolean GL_APIENTRY IsSemaphoreEXT(GLuint semaphore)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsSemaphoreEXT", "context = %d, GLuint semaphore = %u", CID(context), semaphore);

    GLboolean returnValue;
    if (context)
    {
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsSemaphoreEXT(context, semaphorePacked));
        if (isCallValid)
        {
            returnValue = context->isSemaphore(semaphorePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsSemaphoreEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsSemaphoreEXT, isCallValid, context, semaphorePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsSemaphoreEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY SemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, const GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSemaphoreParameterui64vEXT",
          "context = %d, GLuint semaphore = %u, GLenum pname = %s, const GLuint64 *params = "
          "0x%016" PRIxPTR "",
          CID(context), semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->semaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(SemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
}

void GL_APIENTRY SignalSemaphoreEXT(GLuint semaphore,
                                    GLuint numBufferBarriers,
                                    const GLuint *buffers,
                                    GLuint numTextureBarriers,
                                    const GLuint *textures,
                                    const GLenum *dstLayouts)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSignalSemaphoreEXT",
          "context = %d, GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint "
          "*buffers = 0x%016" PRIxPTR
          ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
          ", const GLenum *dstLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)dstLayouts);

    if (context)
    {
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        const TextureID *texturesPacked               = FromGL<const TextureID *>(textures);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSignalSemaphoreEXT(context, semaphorePacked, numBufferBarriers, buffersPacked,
                                        numTextureBarriers, texturesPacked, dstLayouts));
        if (isCallValid)
        {
            context->signalSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                     numTextureBarriers, texturesPacked, dstLayouts);
        }
        ANGLE_CAPTURE(SignalSemaphoreEXT, isCallValid, context, semaphorePacked, numBufferBarriers,
                      buffersPacked, numTextureBarriers, texturesPacked, dstLayouts);
    }
}

void GL_APIENTRY WaitSemaphoreEXT(GLuint semaphore,
                                  GLuint numBufferBarriers,
                                  const GLuint *buffers,
                                  GLuint numTextureBarriers,
                                  const GLuint *textures,
                                  const GLenum *srcLayouts)
{
    Context *context = GetValidGlobalContext();
    EVENT("glWaitSemaphoreEXT",
          "context = %d, GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint "
          "*buffers = 0x%016" PRIxPTR
          ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
          ", const GLenum *srcLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)srcLayouts);

    if (context)
    {
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        const TextureID *texturesPacked               = FromGL<const TextureID *>(textures);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateWaitSemaphoreEXT(context, semaphorePacked, numBufferBarriers, buffersPacked,
                                      numTextureBarriers, texturesPacked, srcLayouts));
        if (isCallValid)
        {
            context->waitSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                   numTextureBarriers, texturesPacked, srcLayouts);
        }
        ANGLE_CAPTURE(WaitSemaphoreEXT, isCallValid, context, semaphorePacked, numBufferBarriers,
                      buffersPacked, numTextureBarriers, texturesPacked, srcLayouts);
    }
}

// GetUnsignedBytei_vEXT is already defined.

// GetUnsignedBytevEXT is already defined.

// GL_EXT_semaphore_fd
void GL_APIENTRY ImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd)
{
    Context *context = GetValidGlobalContext();
    EVENT("glImportSemaphoreFdEXT",
          "context = %d, GLuint semaphore = %u, GLenum handleType = %s, GLint fd = %d",
          CID(context), semaphore, GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context)
    {
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        HandleType handleTypePacked                   = FromGL<HandleType>(handleType);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportSemaphoreFdEXT(context, semaphorePacked, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importSemaphoreFd(semaphorePacked, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportSemaphoreFdEXT, isCallValid, context, semaphorePacked, handleTypePacked,
                      fd);
    }
}

// GL_EXT_texture_compression_bptc

// GL_EXT_texture_compression_dxt1

// GL_EXT_texture_compression_s3tc

// GL_EXT_texture_compression_s3tc_srgb

// GL_EXT_texture_filter_anisotropic

// GL_EXT_texture_format_BGRA8888

// GL_EXT_texture_storage
void GL_APIENTRY TexStorage1DEXT(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorage1DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage1DEXT(context, target, levels, internalformat, width));
        if (isCallValid)
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
        ANGLE_CAPTURE(TexStorage1DEXT, isCallValid, context, target, levels, internalformat, width);
    }
}

void GL_APIENTRY
TexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorage2DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2DEXT(context, targetPacked, levels, internalformat, width, height));
        if (isCallValid)
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE(TexStorage2DEXT, isCallValid, context, targetPacked, levels, internalformat,
                      width, height);
    }
}

void GL_APIENTRY TexStorage3DEXT(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorage3DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexStorage3DEXT(context, targetPacked, levels, internalformat,
                                                    width, height, depth));
        if (isCallValid)
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE(TexStorage3DEXT, isCallValid, context, targetPacked, levels, internalformat,
                      width, height, depth);
    }
}

// GL_KHR_debug
void GL_APIENTRY DebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void *userParam)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDebugMessageCallbackKHR",
          "context = %d, GLDEBUGPROCKHR callback = 0x%016" PRIxPTR
          ", const void *userParam = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)callback, (uintptr_t)userParam);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDebugMessageCallbackKHR(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallbackKHR, isCallValid, context, callback, userParam);
    }
}

void GL_APIENTRY DebugMessageControlKHR(GLenum source,
                                        GLenum type,
                                        GLenum severity,
                                        GLsizei count,
                                        const GLuint *ids,
                                        GLboolean enabled)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDebugMessageControlKHR",
          "context = %d, GLenum source = %s, GLenum type = %s, GLenum severity = %s, GLsizei count "
          "= %d, const GLuint *ids = 0x%016" PRIxPTR ", GLboolean enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControlKHR, isCallValid, context, source, type, severity, count,
                      ids, enabled);
    }
}

void GL_APIENTRY DebugMessageInsertKHR(GLenum source,
                                       GLenum type,
                                       GLuint id,
                                       GLenum severity,
                                       GLsizei length,
                                       const GLchar *buf)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDebugMessageInsertKHR",
          "context = %d, GLenum source = %s, GLenum type = %s, GLuint id = %u, GLenum severity = "
          "%s, GLsizei length = %d, const GLchar *buf = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsertKHR, isCallValid, context, source, type, id, severity,
                      length, buf);
    }
}

GLuint GL_APIENTRY GetDebugMessageLogKHR(GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetDebugMessageLogKHR",
          "context = %d, GLuint count = %u, GLsizei bufSize = %d, GLenum *sources = 0x%016" PRIxPTR
          ", GLenum *types = 0x%016" PRIxPTR ", GLuint *ids = 0x%016" PRIxPTR
          ", GLenum *severities = 0x%016" PRIxPTR ", GLsizei *lengths = 0x%016" PRIxPTR
          ", GLchar *messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types,
                                                          ids, severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLogKHR, isCallValid, context, count, bufSize, sources, types,
                      ids, severities, lengths, messageLog, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY
GetObjectLabelKHR(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetObjectLabelKHR",
          "context = %d, GLenum identifier = %s, GLuint name = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLchar *label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabelKHR, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
}

void GL_APIENTRY GetObjectPtrLabelKHR(const void *ptr,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetObjectPtrLabelKHR",
          "context = %d, const void *ptr = 0x%016" PRIxPTR
          ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabelKHR, isCallValid, context, ptr, bufSize, length, label);
    }
}

void GL_APIENTRY GetPointervKHR(GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetPointervKHR", "context = %d, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointervKHR(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointervKHR, isCallValid, context, pname, params);
    }
}

void GL_APIENTRY ObjectLabelKHR(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT("glObjectLabelKHR",
          "context = %d, GLenum identifier = %s, GLuint name = %u, GLsizei length = %d, const "
          "GLchar *label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateObjectLabelKHR(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabelKHR, isCallValid, context, identifier, name, length, label);
    }
}

void GL_APIENTRY ObjectPtrLabelKHR(const void *ptr, GLsizei length, const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT("glObjectPtrLabelKHR",
          "context = %d, const void *ptr = 0x%016" PRIxPTR
          ", GLsizei length = %d, const GLchar *label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabelKHR, isCallValid, context, ptr, length, label);
    }
}

void GL_APIENTRY PopDebugGroupKHR()
{
    Context *context = GetValidGlobalContext();
    EVENT("glPopDebugGroupKHR", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopDebugGroupKHR(context));
        if (isCallValid)
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE(PopDebugGroupKHR, isCallValid, context);
    }
}

void GL_APIENTRY PushDebugGroupKHR(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    Context *context = GetValidGlobalContext();
    EVENT("glPushDebugGroupKHR",
          "context = %d, GLenum source = %s, GLuint id = %u, GLsizei length = %d, const GLchar "
          "*message = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source), id, length,
          (uintptr_t)message);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePushDebugGroupKHR(context, source, id, length, message));
        if (isCallValid)
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE(PushDebugGroupKHR, isCallValid, context, source, id, length, message);
    }
}

// GL_KHR_parallel_shader_compile
void GL_APIENTRY MaxShaderCompilerThreadsKHR(GLuint count)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMaxShaderCompilerThreadsKHR", "context = %d, GLuint count = %u", CID(context), count);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaxShaderCompilerThreadsKHR(context, count));
        if (isCallValid)
        {
            context->maxShaderCompilerThreads(count);
        }
        ANGLE_CAPTURE(MaxShaderCompilerThreadsKHR, isCallValid, context, count);
    }
}

// GL_NV_fence
void GL_APIENTRY DeleteFencesNV(GLsizei n, const GLuint *fences)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteFencesNV",
          "context = %d, GLsizei n = %d, const GLuint *fences = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)fences);

    if (context)
    {
        const FenceNVID *fencesPacked                 = FromGL<const FenceNVID *>(fences);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->deleteFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(DeleteFencesNV, isCallValid, context, n, fencesPacked);
    }
}

void GL_APIENTRY FinishFenceNV(GLuint fence)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFinishFenceNV", "context = %d, GLuint fence = %u", CID(context), fence);

    if (context)
    {
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFinishFenceNV(context, fencePacked));
        if (isCallValid)
        {
            context->finishFenceNV(fencePacked);
        }
        ANGLE_CAPTURE(FinishFenceNV, isCallValid, context, fencePacked);
    }
}

void GL_APIENTRY GenFencesNV(GLsizei n, GLuint *fences)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenFencesNV", "context = %d, GLsizei n = %d, GLuint *fences = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)fences);

    if (context)
    {
        FenceNVID *fencesPacked                       = FromGL<FenceNVID *>(fences);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->genFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(GenFencesNV, isCallValid, context, n, fencesPacked);
    }
}

void GL_APIENTRY GetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFenceivNV",
          "context = %d, GLuint fence = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), fence, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFenceivNV(context, fencePacked, pname, params));
        if (isCallValid)
        {
            context->getFenceivNV(fencePacked, pname, params);
        }
        ANGLE_CAPTURE(GetFenceivNV, isCallValid, context, fencePacked, pname, params);
    }
}

GLboolean GL_APIENTRY IsFenceNV(GLuint fence)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsFenceNV", "context = %d, GLuint fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context)
    {
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->isFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(IsFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY SetFenceNV(GLuint fence, GLenum condition)
{
    Context *context = GetValidGlobalContext();
    EVENT("glSetFenceNV", "context = %d, GLuint fence = %u, GLenum condition = %s", CID(context),
          fence, GLenumToString(GLenumGroup::DefaultGroup, condition));

    if (context)
    {
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSetFenceNV(context, fencePacked, condition));
        if (isCallValid)
        {
            context->setFenceNV(fencePacked, condition);
        }
        ANGLE_CAPTURE(SetFenceNV, isCallValid, context, fencePacked, condition);
    }
}

GLboolean GL_APIENTRY TestFenceNV(GLuint fence)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTestFenceNV", "context = %d, GLuint fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context)
    {
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTestFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->testFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(TestFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
    }
    return returnValue;
}

// GL_OES_EGL_image
void GL_APIENTRY EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    Context *context = GetValidGlobalContext();
    EVENT("glEGLImageTargetRenderbufferStorageOES",
          "context = %d, GLenum target = %s, GLeglImageOES image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image));
        if (isCallValid)
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
        ANGLE_CAPTURE(EGLImageTargetRenderbufferStorageOES, isCallValid, context, target, image);
    }
}

void GL_APIENTRY EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    Context *context = GetValidGlobalContext();
    EVENT("glEGLImageTargetTexture2DOES",
          "context = %d, GLenum target = %s, GLeglImageOES image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateEGLImageTargetTexture2DOES(context, targetPacked, image));
        if (isCallValid)
        {
            context->eGLImageTargetTexture2D(targetPacked, image);
        }
        ANGLE_CAPTURE(EGLImageTargetTexture2DOES, isCallValid, context, targetPacked, image);
    }
}

// GL_OES_compressed_ETC1_RGB8_texture

// GL_OES_depth32

// GL_OES_draw_elements_base_vertex
void GL_APIENTRY DrawElementsBaseVertexOES(GLenum mode,
                                           GLsizei count,
                                           GLenum type,
                                           const void *indices,
                                           GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsBaseVertexOES",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexOES(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertexOES(GLenum mode,
                                                    GLsizei count,
                                                    GLenum type,
                                                    const void *indices,
                                                    GLsizei instancecount,
                                                    GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawElementsInstancedBaseVertexOES",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei instancecount = %d, GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexOES(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
}

void GL_APIENTRY DrawRangeElementsBaseVertexOES(GLenum mode,
                                                GLuint start,
                                                GLuint end,
                                                GLsizei count,
                                                GLenum type,
                                                const void *indices,
                                                GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawRangeElementsBaseVertexOES",
          "context = %d, GLenum mode = %s, GLuint start = %u, GLuint end = %u, GLsizei count = %d, "
          "GLenum type = %s, const void *indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexOES(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexOES, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
}

// MultiDrawElementsBaseVertexEXT is already defined.

// GL_OES_draw_texture
void GL_APIENTRY DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexfOES",
          "context = %d, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat width = %f, "
          "GLfloat height = %f",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexf(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexfOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexfvOES(const GLfloat *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexfvOES", "context = %d, const GLfloat *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexfvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexfv(coords);
        }
        ANGLE_CAPTURE(DrawTexfvOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexiOES",
          "context = %d, GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height "
          "= %d",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexi(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexiOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexivOES(const GLint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexivOES", "context = %d, const GLint *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexivOES(context, coords));
        if (isCallValid)
        {
            context->drawTexiv(coords);
        }
        ANGLE_CAPTURE(DrawTexivOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexsOES",
          "context = %d, GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort width = %d, "
          "GLshort height = %d",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexs(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexsOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexsvOES(const GLshort *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexsvOES", "context = %d, const GLshort *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexsvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexsv(coords);
        }
        ANGLE_CAPTURE(DrawTexsvOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexxOES",
          "context = %d, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X, GLfixed width = "
          "0x%X, GLfixed height = 0x%X",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexx(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexxOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexxvOES(const GLfixed *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawTexxvOES", "context = %d, const GLfixed *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexxvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexxv(coords);
        }
        ANGLE_CAPTURE(DrawTexxvOES, isCallValid, context, coords);
    }
}

// GL_OES_framebuffer_object
void GL_APIENTRY BindFramebufferOES(GLenum target, GLuint framebuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindFramebufferOES", "context = %d, GLenum target = %s, GLuint framebuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindFramebufferOES(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebufferOES, isCallValid, context, target, framebufferPacked);
    }
}

void GL_APIENTRY BindRenderbufferOES(GLenum target, GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindRenderbufferOES", "context = %d, GLenum target = %s, GLuint renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context)
    {
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindRenderbufferOES(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbufferOES, isCallValid, context, target, renderbufferPacked);
    }
}

GLenum GL_APIENTRY CheckFramebufferStatusOES(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCheckFramebufferStatusOES", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatusOES(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatusOES, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatusOES, isCallValid, context, target, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatusOES, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY DeleteFramebuffersOES(GLsizei n, const GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteFramebuffersOES",
          "context = %d, GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context)
    {
        const FramebufferID *framebuffersPacked       = FromGL<const FramebufferID *>(framebuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
}

void GL_APIENTRY DeleteRenderbuffersOES(GLsizei n, const GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteRenderbuffersOES",
          "context = %d, GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context)
    {
        const RenderbufferID *renderbuffersPacked = FromGL<const RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY FramebufferRenderbufferOES(GLenum target,
                                            GLenum attachment,
                                            GLenum renderbuffertarget,
                                            GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFramebufferRenderbufferOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum renderbuffertarget = "
          "%s, GLuint renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbufferOES(context, target, attachment, renderbuffertarget,
                                                renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbufferOES, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
}

void GL_APIENTRY FramebufferTexture2DOES(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFramebufferTexture2DOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context)
    {
        TextureTarget textargetPacked                 = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferTexture2DOES(context, target, attachment,
                                                            textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
}

void GL_APIENTRY GenFramebuffersOES(GLsizei n, GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenFramebuffersOES",
          "context = %d, GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        FramebufferID *framebuffersPacked             = FromGL<FramebufferID *>(framebuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGenFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
}

void GL_APIENTRY GenRenderbuffersOES(GLsizei n, GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenRenderbuffersOES",
          "context = %d, GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)renderbuffers);

    if (context)
    {
        RenderbufferID *renderbuffersPacked           = FromGL<RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGenRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY GenerateMipmapOES(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenerateMipmapOES", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmapOES(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmapOES, isCallValid, context, targetPacked);
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivOES(GLenum target,
                                                        GLenum attachment,
                                                        GLenum pname,
                                                        GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetFramebufferAttachmentParameterivOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum pname = %s, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameterivOES(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivOES, isCallValid, context, target,
                      attachment, pname, params);
    }
}

void GL_APIENTRY GetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetRenderbufferParameterivOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetRenderbufferParameterivOES(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameterivOES, isCallValid, context, target, pname, params);
    }
}

GLboolean GL_APIENTRY IsFramebufferOES(GLuint framebuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsFramebufferOES", "context = %d, GLuint framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebufferOES(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsFramebufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebufferOES, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsFramebufferOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsRenderbufferOES(GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsRenderbufferOES", "context = %d, GLuint renderbuffer = %u", CID(context),
          renderbuffer);

    GLboolean returnValue;
    if (context)
    {
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbufferOES(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbufferOES, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbufferOES, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY RenderbufferStorageOES(GLenum target,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glRenderbufferStorageOES",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLsizei width = %d, "
          "GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRenderbufferStorageOES(context, target, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageOES, isCallValid, context, target, internalformat, width,
                      height);
    }
}

// GL_OES_get_program_binary
void GL_APIENTRY GetProgramBinaryOES(GLuint program,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLenum *binaryFormat,
                                     void *binary)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetProgramBinaryOES",
        "context = %d, GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR "",
        CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
        (uintptr_t)binary);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramBinaryOES(context, programPacked, bufSize, length,
                                                        binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinaryOES, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
}

void GL_APIENTRY ProgramBinaryOES(GLuint program,
                                  GLenum binaryFormat,
                                  const void *binary,
                                  GLint length)
{
    Context *context = GetValidGlobalContext();
    EVENT("glProgramBinaryOES",
          "context = %d, GLuint program = %u, GLenum binaryFormat = %s, const void *binary = "
          "0x%016" PRIxPTR ", GLint length = %d",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, binaryFormat),
          (uintptr_t)binary, length);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramBinaryOES(context, programPacked, binaryFormat, binary, length));
        if (isCallValid)
        {
            context->programBinary(programPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE(ProgramBinaryOES, isCallValid, context, programPacked, binaryFormat, binary,
                      length);
    }
}

// GL_OES_mapbuffer
void GL_APIENTRY GetBufferPointervOES(GLenum target, GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetBufferPointervOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferPointervOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferPointervOES, isCallValid, context, targetPacked, pname, params);
    }
}

void *GL_APIENTRY MapBufferOES(GLenum target, GLenum access)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMapBufferOES", "context = %d, GLenum target = %s, GLenum access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::BufferAccessARB, access));

    void *returnValue;
    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access));
        if (isCallValid)
        {
            returnValue = context->mapBuffer(targetPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
        }
        ANGLE_CAPTURE(MapBufferOES, isCallValid, context, targetPacked, access, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY UnmapBufferOES(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUnmapBufferOES", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target));

    GLboolean returnValue;
    if (context)
    {
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUnmapBufferOES(context, targetPacked));
        if (isCallValid)
        {
            returnValue = context->unmapBuffer(targetPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::UnmapBufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(UnmapBufferOES, isCallValid, context, targetPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::UnmapBufferOES, GLboolean>();
    }
    return returnValue;
}

// GL_OES_matrix_palette
void GL_APIENTRY CurrentPaletteMatrixOES(GLuint matrixpaletteindex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCurrentPaletteMatrixOES", "context = %d, GLuint matrixpaletteindex = %u", CID(context),
          matrixpaletteindex);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex));
        if (isCallValid)
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
        ANGLE_CAPTURE(CurrentPaletteMatrixOES, isCallValid, context, matrixpaletteindex);
    }
}

void GL_APIENTRY LoadPaletteFromModelViewMatrixOES()
{
    Context *context = GetValidGlobalContext();
    EVENT("glLoadPaletteFromModelViewMatrixOES", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context));
        if (isCallValid)
        {
            context->loadPaletteFromModelViewMatrix();
        }
        ANGLE_CAPTURE(LoadPaletteFromModelViewMatrixOES, isCallValid, context);
    }
}

void GL_APIENTRY MatrixIndexPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMatrixIndexPointerOES",
          "context = %d, GLint size = %d, GLenum type = %s, GLsizei stride = %d, const void "
          "*pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::DefaultGroup, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer));
        if (isCallValid)
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE(MatrixIndexPointerOES, isCallValid, context, size, type, stride, pointer);
    }
}

void GL_APIENTRY WeightPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glWeightPointerOES",
          "context = %d, GLint size = %d, GLenum type = %s, GLsizei stride = %d, const void "
          "*pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::DefaultGroup, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateWeightPointerOES(context, size, type, stride, pointer));
        if (isCallValid)
        {
            context->weightPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE(WeightPointerOES, isCallValid, context, size, type, stride, pointer);
    }
}

// GL_OES_point_size_array
void GL_APIENTRY PointSizePointerOES(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glPointSizePointerOES",
        "context = %d, GLenum type = %s, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::DefaultGroup, type), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                   = FromGL<VertexAttribType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePointSizePointerOES(context, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->pointSizePointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(PointSizePointerOES, isCallValid, context, typePacked, stride, pointer);
    }
}

// GL_OES_query_matrix
GLbitfield GL_APIENTRY QueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
    Context *context = GetValidGlobalContext();
    EVENT("glQueryMatrixxOES",
          "context = %d, GLfixed *mantissa = 0x%016" PRIxPTR ", GLint *exponent = 0x%016" PRIxPTR
          "",
          CID(context), (uintptr_t)mantissa, (uintptr_t)exponent);

    GLbitfield returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryMatrixxOES(context, mantissa, exponent));
        if (isCallValid)
        {
            returnValue = context->queryMatrixx(mantissa, exponent);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
        }
        ANGLE_CAPTURE(QueryMatrixxOES, isCallValid, context, mantissa, exponent, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
    }
    return returnValue;
}

// GL_OES_texture_3D
void GL_APIENTRY CompressedTexImage3DOES(GLenum target,
                                         GLint level,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLsizei imageSize,
                                         const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTexImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei "
          "imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3DOES(context, targetPacked, level, internalformat, width,
                                             height, depth, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3DOES, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, data);
    }
}

void GL_APIENTRY CompressedTexSubImage3DOES(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLsizei imageSize,
                                            const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTexSubImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3DOES(
                                context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3DOES, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
}

void GL_APIENTRY CopyTexSubImage3DOES(GLenum target,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLint x,
                                      GLint y,
                                      GLsizei width,
                                      GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyTexSubImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTexSubImage3DOES(context, targetPacked, level, xoffset,
                                                         yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE(CopyTexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
}

void GL_APIENTRY FramebufferTexture3DOES(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level,
                                         GLint zoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFramebufferTexture3DOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d, GLint zoffset = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, zoffset);

    if (context)
    {
        TextureTarget textargetPacked                 = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture3DOES(context, target, attachment, textargetPacked,
                                             texturePacked, level, zoffset));
        if (isCallValid)
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE(FramebufferTexture3DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, zoffset);
    }
}

void GL_APIENTRY TexImage3DOES(GLenum target,
                               GLint level,
                               GLenum internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLsizei depth,
                               GLint border,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = "
          "%s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage3DOES(context, targetPacked, level, internalformat, width, height,
                                   depth, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
        ANGLE_CAPTURE(TexImage3DOES, isCallValid, context, targetPacked, level, internalformat,
                      width, height, depth, border, format, type, pixels);
    }
}

void GL_APIENTRY TexSubImage3DOES(GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLint zoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexSubImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset,
                                      width, height, depth, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
        ANGLE_CAPTURE(TexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, type, pixels);
    }
}

// GL_OES_texture_border_clamp
void GL_APIENTRY GetSamplerParameterIivOES(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterIivOES",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
}

void GL_APIENTRY GetSamplerParameterIuivOES(GLuint sampler, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetSamplerParameterIuivOES",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR
          "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIuivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
}

void GL_APIENTRY GetTexParameterIivOES(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexParameterIivOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterIuivOES(GLenum target, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexParameterIuivOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY SamplerParameterIivOES(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glSamplerParameterIivOES",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterIivOES(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIivOES, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterIuivOES(GLuint sampler, GLenum pname, const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glSamplerParameterIuivOES",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLuint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterIuivOES(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuivOES, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY TexParameterIivOES(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTexParameterIivOES",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameterIuivOES(GLenum target, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTexParameterIuivOES",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLuint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
}

// GL_OES_texture_cube_map
void GL_APIENTRY GetTexGenfvOES(GLenum coord, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexGenfvOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenfvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY GetTexGenivOES(GLenum coord, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexGenivOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenivOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTexGenxvOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenxvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY TexGenfOES(GLenum coord, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexGenfOES", "context = %d, GLenum coord = %s, GLenum pname = %s, GLfloat param = %f",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenfOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGenf(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGenfOES, isCallValid, context, coord, pname, param);
    }
}

void GL_APIENTRY TexGenfvOES(GLenum coord, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTexGenfvOES",
        "context = %d, GLenum coord = %s, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
        GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenfvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY TexGeniOES(GLenum coord, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexGeniOES", "context = %d, GLenum coord = %s, GLenum pname = %s, GLint param = %d",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGeniOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGeni(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGeniOES, isCallValid, context, coord, pname, param);
    }
}

void GL_APIENTRY TexGenivOES(GLenum coord, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexGenivOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenivOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY TexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexGenxOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLfixed param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenxOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGenx(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGenxOES, isCallValid, context, coord, pname, param);
    }
}

void GL_APIENTRY TexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTexGenxvOES",
        "context = %d, GLenum coord = %s, GLenum pname = %s, const GLfixed *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
        GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenxvOES, isCallValid, context, coord, pname, params);
    }
}

// GL_OES_texture_half_float

// GL_OES_texture_storage_multisample_2d_array
void GL_APIENTRY TexStorage3DMultisampleOES(GLenum target,
                                            GLsizei samples,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTexStorage3DMultisampleOES",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLboolean "
          "fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage3DMultisampleOES(context, targetPacked, samples, internalformat,
                                                width, height, depth, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage3DMultisampleOES, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, depth, fixedsamplelocations);
    }
}

// GL_OES_vertex_array_object
void GL_APIENTRY BindVertexArrayOES(GLuint array)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindVertexArrayOES", "context = %d, GLuint array = %u", CID(context), array);

    if (context)
    {
        VertexArrayID arrayPacked                     = FromGL<VertexArrayID>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArrayOES, isCallValid, context, arrayPacked);
    }
}

void GL_APIENTRY DeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteVertexArraysOES",
          "context = %d, GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)arrays);

    if (context)
    {
        const VertexArrayID *arraysPacked             = FromGL<const VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
}

void GL_APIENTRY GenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenVertexArraysOES",
          "context = %d, GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)arrays);

    if (context)
    {
        VertexArrayID *arraysPacked                   = FromGL<VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
}

GLboolean GL_APIENTRY IsVertexArrayOES(GLuint array)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsVertexArrayOES", "context = %d, GLuint array = %u", CID(context), array);

    GLboolean returnValue;
    if (context)
    {
        VertexArrayID arrayPacked                     = FromGL<VertexArrayID>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArrayOES, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
    }
    return returnValue;
}

// GL_OVR_multiview
void GL_APIENTRY FramebufferTextureMultiviewOVR(GLenum target,
                                                GLenum attachment,
                                                GLuint texture,
                                                GLint level,
                                                GLint baseViewIndex,
                                                GLsizei numViews)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFramebufferTextureMultiviewOVR",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLuint texture = %u, GLint "
          "level = %d, GLint baseViewIndex = %d, GLsizei numViews = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level,
          baseViewIndex, numViews);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureMultiviewOVR(context, target, attachment, texturePacked,
                                                    level, baseViewIndex, numViews));
        if (isCallValid)
        {
            context->framebufferTextureMultiview(target, attachment, texturePacked, level,
                                                 baseViewIndex, numViews);
        }
        ANGLE_CAPTURE(FramebufferTextureMultiviewOVR, isCallValid, context, target, attachment,
                      texturePacked, level, baseViewIndex, numViews);
    }
}

// GL_OVR_multiview2

// EGL_ANGLE_explicit_context
void GL_APIENTRY ActiveShaderProgramContextANGLE(GLeglContext ctx, GLuint pipeline, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glActiveShaderProgram", "context = %d, GLuint pipeline = %u, GLuint program = %u",
          CID(context), pipeline, program);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked              = FromGL<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateActiveShaderProgram(context, pipelinePacked, programPacked));
        if (isCallValid)
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE(ActiveShaderProgram, isCallValid, context, pipelinePacked, programPacked);
    }
}

void GL_APIENTRY ActiveTextureContextANGLE(GLeglContext ctx, GLenum texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glActiveTexture", "context = %d, GLenum texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateActiveTexture(context, texture));
        if (isCallValid)
        {
            context->activeTexture(texture);
        }
        ANGLE_CAPTURE(ActiveTexture, isCallValid, context, texture);
    }
}

void GL_APIENTRY AlphaFuncContextANGLE(GLeglContext ctx, GLenum func, GLfloat ref)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glAlphaFunc", "context = %d, GLenum func = %s, GLfloat ref = %f", CID(context),
          GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        AlphaTestFunc funcPacked                      = FromGL<AlphaTestFunc>(func);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateAlphaFunc(context, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFunc(funcPacked, ref);
        }
        ANGLE_CAPTURE(AlphaFunc, isCallValid, context, funcPacked, ref);
    }
}

void GL_APIENTRY AlphaFuncxContextANGLE(GLeglContext ctx, GLenum func, GLfixed ref)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glAlphaFuncx", "context = %d, GLenum func = %s, GLfixed ref = 0x%X", CID(context),
          GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        AlphaTestFunc funcPacked                      = FromGL<AlphaTestFunc>(func);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateAlphaFuncx(context, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFuncx(funcPacked, ref);
        }
        ANGLE_CAPTURE(AlphaFuncx, isCallValid, context, funcPacked, ref);
    }
}

void GL_APIENTRY AttachShaderContextANGLE(GLeglContext ctx, GLuint program, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glAttachShader", "context = %d, GLuint program = %u, GLuint shader = %u", CID(context),
          program, shader);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateAttachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->attachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(AttachShader, isCallValid, context, programPacked, shaderPacked);
    }
}

void GL_APIENTRY BeginQueryContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBeginQuery", "context = %d, GLenum target = %s, GLuint id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                        = FromGL<QueryType>(target);
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginQuery(context, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE(BeginQuery, isCallValid, context, targetPacked, idPacked);
    }
}

void GL_APIENTRY BeginQueryEXTContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBeginQueryEXT", "context = %d, GLenum target = %s, GLuint id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                        = FromGL<QueryType>(target);
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginQueryEXT(context, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE(BeginQueryEXT, isCallValid, context, targetPacked, idPacked);
    }
}

void GL_APIENTRY BeginTransformFeedbackContextANGLE(GLeglContext ctx, GLenum primitiveMode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBeginTransformFeedback", "context = %d, GLenum primitiveMode = %s", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, primitiveMode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode primitiveModePacked             = FromGL<PrimitiveMode>(primitiveMode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBeginTransformFeedback(context, primitiveModePacked));
        if (isCallValid)
        {
            context->beginTransformFeedback(primitiveModePacked);
        }
        ANGLE_CAPTURE(BeginTransformFeedback, isCallValid, context, primitiveModePacked);
    }
}

void GL_APIENTRY BindAttribLocationContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLuint index,
                                                const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glBindAttribLocation",
        "context = %d, GLuint program = %u, GLuint index = %u, const GLchar *name = 0x%016" PRIxPTR
        "",
        CID(context), program, index, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindAttribLocation(context, programPacked, index, name));
        if (isCallValid)
        {
            context->bindAttribLocation(programPacked, index, name);
        }
        ANGLE_CAPTURE(BindAttribLocation, isCallValid, context, programPacked, index, name);
    }
}

void GL_APIENTRY BindBufferContextANGLE(GLeglContext ctx, GLenum target, GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindBuffer", "context = %d, GLenum target = %s, GLuint buffer = %u", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), buffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindBuffer(context, targetPacked, bufferPacked));
        if (isCallValid)
        {
            context->bindBuffer(targetPacked, bufferPacked);
        }
        ANGLE_CAPTURE(BindBuffer, isCallValid, context, targetPacked, bufferPacked);
    }
}

void GL_APIENTRY BindBufferBaseContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLuint index,
                                            GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindBufferBase",
          "context = %d, GLenum target = %s, GLuint index = %u, GLuint buffer = %u", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), index, buffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindBufferBase(context, targetPacked, index, bufferPacked));
        if (isCallValid)
        {
            context->bindBufferBase(targetPacked, index, bufferPacked);
        }
        ANGLE_CAPTURE(BindBufferBase, isCallValid, context, targetPacked, index, bufferPacked);
    }
}

void GL_APIENTRY BindBufferRangeContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLuint index,
                                             GLuint buffer,
                                             GLintptr offset,
                                             GLsizeiptr size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindBufferRange",
          "context = %d, GLenum target = %s, GLuint index = %u, GLuint buffer = %u, GLintptr "
          "offset = %llu, GLsizeiptr size = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), index, buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindBufferRange(context, targetPacked, index, bufferPacked, offset, size));
        if (isCallValid)
        {
            context->bindBufferRange(targetPacked, index, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(BindBufferRange, isCallValid, context, targetPacked, index, bufferPacked,
                      offset, size);
    }
}

void GL_APIENTRY BindFragDataLocationEXTContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLuint color,
                                                     const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glBindFragDataLocationEXT",
        "context = %d, GLuint program = %u, GLuint color = %u, const GLchar *name = 0x%016" PRIxPTR
        "",
        CID(context), program, color, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindFragDataLocationEXT(context, programPacked, color, name));
        if (isCallValid)
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationEXT, isCallValid, context, programPacked, color, name);
    }
}

void GL_APIENTRY BindFragDataLocationIndexedEXTContextANGLE(GLeglContext ctx,
                                                            GLuint program,
                                                            GLuint colorNumber,
                                                            GLuint index,
                                                            const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindFragDataLocationIndexedEXT",
          "context = %d, GLuint program = %u, GLuint colorNumber = %u, GLuint index = %u, const "
          "GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindFragDataLocationIndexedEXT(
                                              context, programPacked, colorNumber, index, name));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationIndexedEXT, isCallValid, context, programPacked,
                      colorNumber, index, name);
    }
}

void GL_APIENTRY BindFramebufferContextANGLE(GLeglContext ctx, GLenum target, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindFramebuffer", "context = %d, GLenum target = %s, GLuint framebuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindFramebuffer(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebuffer, isCallValid, context, target, framebufferPacked);
    }
}

void GL_APIENTRY BindFramebufferOESContextANGLE(GLeglContext ctx, GLenum target, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindFramebufferOES", "context = %d, GLenum target = %s, GLuint framebuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindFramebufferOES(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebufferOES, isCallValid, context, target, framebufferPacked);
    }
}

void GL_APIENTRY BindImageTextureContextANGLE(GLeglContext ctx,
                                              GLuint unit,
                                              GLuint texture,
                                              GLint level,
                                              GLboolean layered,
                                              GLint layer,
                                              GLenum access,
                                              GLenum format)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindImageTexture",
          "context = %d, GLuint unit = %u, GLuint texture = %u, GLint level = %d, GLboolean "
          "layered = %s, GLint layer = %d, GLenum access = %s, GLenum format = %s",
          CID(context), unit, texture, level, GLbooleanToString(layered), layer,
          GLenumToString(GLenumGroup::BufferAccessARB, access),
          GLenumToString(GLenumGroup::InternalFormat, format));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindImageTexture(context, unit, texturePacked, level, layered,
                                                     layer, access, format));
        if (isCallValid)
        {
            context->bindImageTexture(unit, texturePacked, level, layered, layer, access, format);
        }
        ANGLE_CAPTURE(BindImageTexture, isCallValid, context, unit, texturePacked, level, layered,
                      layer, access, format);
    }
}

void GL_APIENTRY BindProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindProgramPipeline", "context = %d, GLuint pipeline = %u", CID(context), pipeline);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked              = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(BindProgramPipeline, isCallValid, context, pipelinePacked);
    }
}

void GL_APIENTRY BindRenderbufferContextANGLE(GLeglContext ctx, GLenum target, GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindRenderbuffer", "context = %d, GLenum target = %s, GLuint renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindRenderbuffer(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbuffer, isCallValid, context, target, renderbufferPacked);
    }
}

void GL_APIENTRY BindRenderbufferOESContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindRenderbufferOES", "context = %d, GLenum target = %s, GLuint renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindRenderbufferOES(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbufferOES, isCallValid, context, target, renderbufferPacked);
    }
}

void GL_APIENTRY BindSamplerContextANGLE(GLeglContext ctx, GLuint unit, GLuint sampler)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindSampler", "context = %d, GLuint unit = %u, GLuint sampler = %u", CID(context),
          unit, sampler);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindSampler(context, unit, samplerPacked));
        if (isCallValid)
        {
            context->bindSampler(unit, samplerPacked);
        }
        ANGLE_CAPTURE(BindSampler, isCallValid, context, unit, samplerPacked);
    }
}

void GL_APIENTRY BindTextureContextANGLE(GLeglContext ctx, GLenum target, GLuint texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindTexture", "context = %d, GLenum target = %s, GLuint texture = %u", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target), texture);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindTexture(context, targetPacked, texturePacked));
        if (isCallValid)
        {
            context->bindTexture(targetPacked, texturePacked);
        }
        ANGLE_CAPTURE(BindTexture, isCallValid, context, targetPacked, texturePacked);
    }
}

void GL_APIENTRY BindTransformFeedbackContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindTransformFeedback", "context = %d, GLenum target = %s, GLuint id = %u",
          CID(context), GLenumToString(GLenumGroup::BindTransformFeedbackTarget, target), id);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TransformFeedbackID idPacked                  = FromGL<TransformFeedbackID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindTransformFeedback(context, target, idPacked));
        if (isCallValid)
        {
            context->bindTransformFeedback(target, idPacked);
        }
        ANGLE_CAPTURE(BindTransformFeedback, isCallValid, context, target, idPacked);
    }
}

void GL_APIENTRY BindVertexArrayContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindVertexArray", "context = %d, GLuint array = %u", CID(context), array);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                     = FromGL<VertexArrayID>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArray(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArray, isCallValid, context, arrayPacked);
    }
}

void GL_APIENTRY BindVertexArrayOESContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindVertexArrayOES", "context = %d, GLuint array = %u", CID(context), array);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                     = FromGL<VertexArrayID>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArrayOES, isCallValid, context, arrayPacked);
    }
}

void GL_APIENTRY BindVertexBufferContextANGLE(GLeglContext ctx,
                                              GLuint bindingindex,
                                              GLuint buffer,
                                              GLintptr offset,
                                              GLsizei stride)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBindVertexBuffer",
          "context = %d, GLuint bindingindex = %u, GLuint buffer = %u, GLintptr offset = %llu, "
          "GLsizei stride = %d",
          CID(context), bindingindex, buffer, static_cast<unsigned long long>(offset), stride);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindVertexBuffer(context, bindingindex, bufferPacked, offset, stride));
        if (isCallValid)
        {
            context->bindVertexBuffer(bindingindex, bufferPacked, offset, stride);
        }
        ANGLE_CAPTURE(BindVertexBuffer, isCallValid, context, bindingindex, bufferPacked, offset,
                      stride);
    }
}

void GL_APIENTRY BlendBarrierContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendBarrier", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendBarrier(context));
        if (isCallValid)
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE(BlendBarrier, isCallValid, context);
    }
}

void GL_APIENTRY
BlendColorContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glBlendColor",
        "context = %d, GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f",
        CID(context), red, green, blue, alpha);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendColor(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->blendColor(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(BlendColor, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY BlendEquationContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendEquation", "context = %d, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendEquation(context, mode));
        if (isCallValid)
        {
            context->blendEquation(mode);
        }
        ANGLE_CAPTURE(BlendEquation, isCallValid, context, mode);
    }
}

void GL_APIENTRY BlendEquationSeparateContextANGLE(GLeglContext ctx,
                                                   GLenum modeRGB,
                                                   GLenum modeAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendEquationSeparate", "context = %d, GLenum modeRGB = %s, GLenum modeAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBlendEquationSeparate(context, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparate, isCallValid, context, modeRGB, modeAlpha);
    }
}

void GL_APIENTRY BlendEquationSeparateiContextANGLE(GLeglContext ctx,
                                                    GLuint buf,
                                                    GLenum modeRGB,
                                                    GLenum modeAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendEquationSeparatei",
          "context = %d, GLuint buf = %u, GLenum modeRGB = %s, GLenum modeAlpha = %s", CID(context),
          buf, GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBlendEquationSeparatei(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparatei, isCallValid, context, buf, modeRGB, modeAlpha);
    }
}

void GL_APIENTRY BlendEquationiContextANGLE(GLeglContext ctx, GLuint buf, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendEquationi", "context = %d, GLuint buf = %u, GLenum mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationi(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationi, isCallValid, context, buf, mode);
    }
}

void GL_APIENTRY BlendFuncContextANGLE(GLeglContext ctx, GLenum sfactor, GLenum dfactor)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendFunc", "context = %d, GLenum sfactor = %s, GLenum dfactor = %s", CID(context),
          GLenumToString(GLenumGroup::BlendingFactor, sfactor),
          GLenumToString(GLenumGroup::BlendingFactor, dfactor));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunc(context, sfactor, dfactor));
        if (isCallValid)
        {
            context->blendFunc(sfactor, dfactor);
        }
        ANGLE_CAPTURE(BlendFunc, isCallValid, context, sfactor, dfactor);
    }
}

void GL_APIENTRY BlendFuncSeparateContextANGLE(GLeglContext ctx,
                                               GLenum sfactorRGB,
                                               GLenum dfactorRGB,
                                               GLenum sfactorAlpha,
                                               GLenum dfactorAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendFuncSeparate",
          "context = %d, GLenum sfactorRGB = %s, GLenum dfactorRGB = %s, GLenum sfactorAlpha = %s, "
          "GLenum dfactorAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendingFactor, sfactorRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dfactorRGB),
          GLenumToString(GLenumGroup::BlendingFactor, sfactorAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dfactorAlpha));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFuncSeparate(context, sfactorRGB, dfactorRGB,
                                                                    sfactorAlpha, dfactorAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparate, isCallValid, context, sfactorRGB, dfactorRGB, sfactorAlpha,
                      dfactorAlpha);
    }
}

void GL_APIENTRY BlendFuncSeparateiContextANGLE(GLeglContext ctx,
                                                GLuint buf,
                                                GLenum srcRGB,
                                                GLenum dstRGB,
                                                GLenum srcAlpha,
                                                GLenum dstAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendFuncSeparatei",
          "context = %d, GLuint buf = %u, GLenum srcRGB = %s, GLenum dstRGB = %s, GLenum srcAlpha "
          "= %s, GLenum dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparatei(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparatei, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
}

void GL_APIENTRY BlendFunciContextANGLE(GLeglContext ctx, GLuint buf, GLenum src, GLenum dst)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlendFunci", "context = %d, GLuint buf = %u, GLenum src = %s, GLenum dst = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunci(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunci, isCallValid, context, buf, src, dst);
    }
}

void GL_APIENTRY BlitFramebufferContextANGLE(GLeglContext ctx,
                                             GLint srcX0,
                                             GLint srcY0,
                                             GLint srcX1,
                                             GLint srcY1,
                                             GLint dstX0,
                                             GLint dstY0,
                                             GLint dstX1,
                                             GLint dstY1,
                                             GLbitfield mask,
                                             GLenum filter)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlitFramebuffer",
          "context = %d, GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, "
          "GLint dstX0 = %d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask "
          "= %s, GLenum filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBlitFramebuffer(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                    dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebuffer, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
}

void GL_APIENTRY BlitFramebufferANGLEContextANGLE(GLeglContext ctx,
                                                  GLint srcX0,
                                                  GLint srcY0,
                                                  GLint srcX1,
                                                  GLint srcY1,
                                                  GLint dstX0,
                                                  GLint dstY0,
                                                  GLint dstX1,
                                                  GLint dstY1,
                                                  GLbitfield mask,
                                                  GLenum filter)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBlitFramebufferANGLE",
          "context = %d, GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, "
          "GLint dstX0 = %d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask "
          "= %s, GLenum filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                         dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebufferANGLE, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
}

void GL_APIENTRY BufferDataContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLsizeiptr size,
                                        const void *data,
                                        GLenum usage)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBufferData",
          "context = %d, GLenum target = %s, GLsizeiptr size = %llu, const void *data = "
          "0x%016" PRIxPTR ", GLenum usage = %s",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLenumToString(GLenumGroup::BufferUsageARB, usage));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        BufferUsage usagePacked                       = FromGL<BufferUsage>(usage);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBufferData(context, targetPacked, size, data, usagePacked));
        if (isCallValid)
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
        ANGLE_CAPTURE(BufferData, isCallValid, context, targetPacked, size, data, usagePacked);
    }
}

void GL_APIENTRY BufferStorageMemEXTContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLsizeiptr size,
                                                 GLuint memory,
                                                 GLuint64 offset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBufferStorageMemEXT",
          "context = %d, GLenum target = %s, GLsizeiptr size = %llu, GLuint memory = %u, GLuint64 "
          "offset = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBufferStorageMemEXT(context, targetPacked, size, memoryPacked, offset));
        if (isCallValid)
        {
            context->bufferStorageMem(targetPacked, size, memoryPacked, offset);
        }
        ANGLE_CAPTURE(BufferStorageMemEXT, isCallValid, context, targetPacked, size, memoryPacked,
                      offset);
    }
}

void GL_APIENTRY BufferSubDataContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLintptr offset,
                                           GLsizeiptr size,
                                           const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glBufferSubData",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr size = %llu, const "
          "void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBufferSubData(context, targetPacked, offset, size, data));
        if (isCallValid)
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
        ANGLE_CAPTURE(BufferSubData, isCallValid, context, targetPacked, offset, size, data);
    }
}

GLenum GL_APIENTRY CheckFramebufferStatusContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCheckFramebufferStatus", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatus(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatus, isCallValid, context, target, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
    }
    return returnValue;
}

GLenum GL_APIENTRY CheckFramebufferStatusOESContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCheckFramebufferStatusOES", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatusOES(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatusOES, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatusOES, isCallValid, context, target, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatusOES, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY ClearContextANGLE(GLeglContext ctx, GLbitfield mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClear", "context = %d, GLbitfield mask = %s", CID(context),
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str());

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClear(context, mask));
        if (isCallValid)
        {
            context->clear(mask);
        }
        ANGLE_CAPTURE(Clear, isCallValid, context, mask);
    }
}

void GL_APIENTRY ClearBufferfiContextANGLE(GLeglContext ctx,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           GLfloat depth,
                                           GLint stencil)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearBufferfi",
          "context = %d, GLenum buffer = %s, GLint drawbuffer = %d, GLfloat depth = %f, GLint "
          "stencil = %d",
          CID(context), GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, depth, stencil);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearBufferfi(context, buffer, drawbuffer, depth, stencil));
        if (isCallValid)
        {
            context->clearBufferfi(buffer, drawbuffer, depth, stencil);
        }
        ANGLE_CAPTURE(ClearBufferfi, isCallValid, context, buffer, drawbuffer, depth, stencil);
    }
}

void GL_APIENTRY ClearBufferfvContextANGLE(GLeglContext ctx,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearBufferfv",
          "context = %d, GLenum buffer = %s, GLint drawbuffer = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearBufferfv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferfv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferfv, isCallValid, context, buffer, drawbuffer, value);
    }
}

void GL_APIENTRY ClearBufferivContextANGLE(GLeglContext ctx,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearBufferiv",
          "context = %d, GLenum buffer = %s, GLint drawbuffer = %d, const GLint *value = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearBufferiv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferiv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferiv, isCallValid, context, buffer, drawbuffer, value);
    }
}

void GL_APIENTRY ClearBufferuivContextANGLE(GLeglContext ctx,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearBufferuiv",
          "context = %d, GLenum buffer = %s, GLint drawbuffer = %d, const GLuint *value = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearBufferuiv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferuiv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferuiv, isCallValid, context, buffer, drawbuffer, value);
    }
}

void GL_APIENTRY
ClearColorContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glClearColor",
        "context = %d, GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f",
        CID(context), red, green, blue, alpha);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClearColor(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearColor(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ClearColor, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY
ClearColorxContextANGLE(GLeglContext ctx, GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearColorx",
          "context = %d, GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed "
          "alpha = 0x%X",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClearColorx(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearColorx(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ClearColorx, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY ClearDepthfContextANGLE(GLeglContext ctx, GLfloat d)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearDepthf", "context = %d, GLfloat d = %f", CID(context), d);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearDepthf(context, d));
        if (isCallValid)
        {
            context->clearDepthf(d);
        }
        ANGLE_CAPTURE(ClearDepthf, isCallValid, context, d);
    }
}

void GL_APIENTRY ClearDepthxContextANGLE(GLeglContext ctx, GLfixed depth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearDepthx", "context = %d, GLfixed depth = 0x%X", CID(context), depth);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearDepthx(context, depth));
        if (isCallValid)
        {
            context->clearDepthx(depth);
        }
        ANGLE_CAPTURE(ClearDepthx, isCallValid, context, depth);
    }
}

void GL_APIENTRY ClearStencilContextANGLE(GLeglContext ctx, GLint s)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClearStencil", "context = %d, GLint s = %d", CID(context), s);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearStencil(context, s));
        if (isCallValid)
        {
            context->clearStencil(s);
        }
        ANGLE_CAPTURE(ClearStencil, isCallValid, context, s);
    }
}

void GL_APIENTRY ClientActiveTextureContextANGLE(GLeglContext ctx, GLenum texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClientActiveTexture", "context = %d, GLenum texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClientActiveTexture(context, texture));
        if (isCallValid)
        {
            context->clientActiveTexture(texture);
        }
        ANGLE_CAPTURE(ClientActiveTexture, isCallValid, context, texture);
    }
}

GLenum GL_APIENTRY ClientWaitSyncContextANGLE(GLeglContext ctx,
                                              GLsync sync,
                                              GLbitfield flags,
                                              GLuint64 timeout)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClientWaitSync",
          "context = %d, GLsync sync = 0x%016" PRIxPTR
          ", GLbitfield flags = %s, GLuint64 timeout = %llu",
          CID(context), (uintptr_t)sync,
          GLbitfieldToString(GLenumGroup::SyncObjectMask, flags).c_str(),
          static_cast<unsigned long long>(timeout));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClientWaitSync(context, sync, flags, timeout));
        if (isCallValid)
        {
            returnValue = context->clientWaitSync(sync, flags, timeout);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::ClientWaitSync, GLenum>();
        }
        ANGLE_CAPTURE(ClientWaitSync, isCallValid, context, sync, flags, timeout, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::ClientWaitSync, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY ClipPlanefContextANGLE(GLeglContext ctx, GLenum p, const GLfloat *eqn)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClipPlanef", "context = %d, GLenum p = %s, const GLfloat *eqn = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, p), (uintptr_t)eqn);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClipPlanef(context, p, eqn));
        if (isCallValid)
        {
            context->clipPlanef(p, eqn);
        }
        ANGLE_CAPTURE(ClipPlanef, isCallValid, context, p, eqn);
    }
}

void GL_APIENTRY ClipPlanexContextANGLE(GLeglContext ctx, GLenum plane, const GLfixed *equation)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glClipPlanex",
          "context = %d, GLenum plane = %s, const GLfixed *equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClipPlanex(context, plane, equation));
        if (isCallValid)
        {
            context->clipPlanex(plane, equation);
        }
        ANGLE_CAPTURE(ClipPlanex, isCallValid, context, plane, equation);
    }
}

void GL_APIENTRY
Color4fContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glColor4f",
        "context = %d, GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f",
        CID(context), red, green, blue, alpha);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4f(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4f, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY
Color4ubContextANGLE(GLeglContext ctx, GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glColor4ub",
        "context = %d, GLubyte red = %d, GLubyte green = %d, GLubyte blue = %d, GLubyte alpha = %d",
        CID(context), red, green, blue, alpha);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4ub(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4ub, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY
Color4xContextANGLE(GLeglContext ctx, GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glColor4x",
          "context = %d, GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed "
          "alpha = 0x%X",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4x(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4x(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4x, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY ColorMaskContextANGLE(GLeglContext ctx,
                                       GLboolean red,
                                       GLboolean green,
                                       GLboolean blue,
                                       GLboolean alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glColorMask",
          "context = %d, GLboolean red = %s, GLboolean green = %s, GLboolean blue = %s, GLboolean "
          "alpha = %s",
          CID(context), GLbooleanToString(red), GLbooleanToString(green), GLbooleanToString(blue),
          GLbooleanToString(alpha));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMask(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->colorMask(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ColorMask, isCallValid, context, red, green, blue, alpha);
    }
}

void GL_APIENTRY ColorMaskiContextANGLE(GLeglContext ctx,
                                        GLuint index,
                                        GLboolean r,
                                        GLboolean g,
                                        GLboolean b,
                                        GLboolean a)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glColorMaski",
          "context = %d, GLuint index = %u, GLboolean r = %s, GLboolean g = %s, GLboolean b = %s, "
          "GLboolean a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaski(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaski, isCallValid, context, index, r, g, b, a);
    }
}

void GL_APIENTRY ColorPointerContextANGLE(GLeglContext ctx,
                                          GLint size,
                                          GLenum type,
                                          GLsizei stride,
                                          const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glColorPointer",
          "context = %d, GLint size = %d, GLenum type = %s, GLsizei stride = %d, const void "
          "*pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked                   = FromGL<VertexAttribType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateColorPointer(context, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(ColorPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
}

void GL_APIENTRY CompileShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompileShader", "context = %d, GLuint shader = %u", CID(context), shader);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompileShader(context, shaderPacked));
        if (isCallValid)
        {
            context->compileShader(shaderPacked);
        }
        ANGLE_CAPTURE(CompileShader, isCallValid, context, shaderPacked);
    }
}

void GL_APIENTRY CompressedTexImage2DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLint border,
                                                  GLsizei imageSize,
                                                  const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompressedTexImage2D",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, const void "
          "*data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage2D(context, targetPacked, level, internalformat, width,
                                          height, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage2D(targetPacked, level, internalformat, width, height,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage2D, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, imageSize, data);
    }
}

void GL_APIENTRY CompressedTexImage3DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLsizei depth,
                                                  GLint border,
                                                  GLsizei imageSize,
                                                  const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompressedTexImage3D",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei "
          "imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3D(context, targetPacked, level, internalformat, width,
                                          height, depth, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3D, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, data);
    }
}

void GL_APIENTRY CompressedTexImage3DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLsizei depth,
                                                     GLint border,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompressedTexImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei "
          "imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3DOES(context, targetPacked, level, internalformat, width,
                                             height, depth, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3DOES, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, data);
    }
}

void GL_APIENTRY CompressedTexSubImage2DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLint xoffset,
                                                     GLint yoffset,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLenum format,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompressedTexSubImage2D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLsizei width = %d, GLsizei height = %d, GLenum format = %s, GLsizei imageSize = "
          "%d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::PixelFormat, format), imageSize,
          (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexSubImage2D(context, targetPacked, level, xoffset, yoffset, width,
                                             height, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage2D(targetPacked, level, xoffset, yoffset, width, height,
                                             format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage2D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, width, height, format, imageSize, data);
    }
}

void GL_APIENTRY CompressedTexSubImage3DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLint xoffset,
                                                     GLint yoffset,
                                                     GLint zoffset,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLsizei depth,
                                                     GLenum format,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompressedTexSubImage3D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3D(context, targetPacked, level, xoffset,
                                                            yoffset, zoffset, width, height, depth,
                                                            format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
}

void GL_APIENTRY CompressedTexSubImage3DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLint level,
                                                        GLint xoffset,
                                                        GLint yoffset,
                                                        GLint zoffset,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLenum format,
                                                        GLsizei imageSize,
                                                        const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCompressedTexSubImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3DOES(
                                context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3DOES, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
}

void GL_APIENTRY CopyBufferSubDataContextANGLE(GLeglContext ctx,
                                               GLenum readTarget,
                                               GLenum writeTarget,
                                               GLintptr readOffset,
                                               GLintptr writeOffset,
                                               GLsizeiptr size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCopyBufferSubData",
          "context = %d, GLenum readTarget = %s, GLenum writeTarget = %s, GLintptr readOffset = "
          "%llu, GLintptr writeOffset = %llu, GLsizeiptr size = %llu",
          CID(context), GLenumToString(GLenumGroup::CopyBufferSubDataTarget, readTarget),
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, writeTarget),
          static_cast<unsigned long long>(readOffset), static_cast<unsigned long long>(writeOffset),
          static_cast<unsigned long long>(size));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding readTargetPacked                = FromGL<BufferBinding>(readTarget);
        BufferBinding writeTargetPacked               = FromGL<BufferBinding>(writeTarget);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyBufferSubData(context, readTargetPacked, writeTargetPacked,
                                                      readOffset, writeOffset, size));
        if (isCallValid)
        {
            context->copyBufferSubData(readTargetPacked, writeTargetPacked, readOffset, writeOffset,
                                       size);
        }
        ANGLE_CAPTURE(CopyBufferSubData, isCallValid, context, readTargetPacked, writeTargetPacked,
                      readOffset, writeOffset, size);
    }
}

void GL_APIENTRY CopyImageSubDataContextANGLE(GLeglContext ctx,
                                              GLuint srcName,
                                              GLenum srcTarget,
                                              GLint srcLevel,
                                              GLint srcX,
                                              GLint srcY,
                                              GLint srcZ,
                                              GLuint dstName,
                                              GLenum dstTarget,
                                              GLint dstLevel,
                                              GLint dstX,
                                              GLint dstY,
                                              GLint dstZ,
                                              GLsizei srcWidth,
                                              GLsizei srcHeight,
                                              GLsizei srcDepth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCopyImageSubData",
          "context = %d, GLuint srcName = %u, GLenum srcTarget = %s, GLint srcLevel = %d, GLint "
          "srcX = %d, GLint srcY = %d, GLint srcZ = %d, GLuint dstName = %u, GLenum dstTarget = "
          "%s, GLint dstLevel = %d, GLint dstX = %d, GLint dstY = %d, GLint dstZ = %d, GLsizei "
          "srcWidth = %d, GLsizei srcHeight = %d, GLsizei srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyImageSubData(context, srcName, srcTarget, srcLevel, srcX,
                                                     srcY, srcZ, dstName, dstTarget, dstLevel, dstX,
                                                     dstY, dstZ, srcWidth, srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubData, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
}

void GL_APIENTRY CopyTexImage2DContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLint level,
                                            GLenum internalformat,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height,
                                            GLint border)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCopyTexImage2D",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLint x "
          "= %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLint border = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), x, y, width, height, border);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTexImage2D(context, targetPacked, level, internalformat, x,
                                                   y, width, height, border));
        if (isCallValid)
        {
            context->copyTexImage2D(targetPacked, level, internalformat, x, y, width, height,
                                    border);
        }
        ANGLE_CAPTURE(CopyTexImage2D, isCallValid, context, targetPacked, level, internalformat, x,
                      y, width, height, border);
    }
}

void GL_APIENTRY CopyTexSubImage2DContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint x,
                                               GLint y,
                                               GLsizei width,
                                               GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCopyTexSubImage2D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          x, y, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTexSubImage2D(context, targetPacked, level, xoffset,
                                                      yoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage2D(targetPacked, level, xoffset, yoffset, x, y, width, height);
        }
        ANGLE_CAPTURE(CopyTexSubImage2D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, x, y, width, height);
    }
}

void GL_APIENTRY CopyTexSubImage3DContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint zoffset,
                                               GLint x,
                                               GLint y,
                                               GLsizei width,
                                               GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCopyTexSubImage3D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTexSubImage3D(context, targetPacked, level, xoffset,
                                                      yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE(CopyTexSubImage3D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
}

void GL_APIENTRY CopyTexSubImage3DOESContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLint xoffset,
                                                  GLint yoffset,
                                                  GLint zoffset,
                                                  GLint x,
                                                  GLint y,
                                                  GLsizei width,
                                                  GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCopyTexSubImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTexSubImage3DOES(context, targetPacked, level, xoffset,
                                                         yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE(CopyTexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
}

void GL_APIENTRY CreateMemoryObjectsEXTContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    GLuint *memoryObjects)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCreateMemoryObjectsEXT",
          "context = %d, GLsizei n = %d, GLuint *memoryObjects = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)memoryObjects);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID *memoryObjectsPacked           = FromGL<MemoryObjectID *>(memoryObjects);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCreateMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->createMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(CreateMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
}

GLuint GL_APIENTRY CreateProgramContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCreateProgram", "context = %d", CID(context));

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateProgram(context));
        if (isCallValid)
        {
            returnValue = context->createProgram();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
        }
        ANGLE_CAPTURE(CreateProgram, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY CreateShaderContextANGLE(GLeglContext ctx, GLenum type)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCreateShader", "context = %d, GLenum type = %s", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type));

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked                         = FromGL<ShaderType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateShader(context, typePacked));
        if (isCallValid)
        {
            returnValue = context->createShader(typePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
        }
        ANGLE_CAPTURE(CreateShader, isCallValid, context, typePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY CreateShaderProgramvContextANGLE(GLeglContext ctx,
                                                    GLenum type,
                                                    GLsizei count,
                                                    const GLchar *const *strings)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCreateShaderProgramv",
          "context = %d, GLenum type = %s, GLsizei count = %d, const GLchar *const*strings = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ShaderType, type), count, (uintptr_t)strings);

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked                         = FromGL<ShaderType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCreateShaderProgramv(context, typePacked, count, strings));
        if (isCallValid)
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CreateShaderProgramv, GLuint>();
        }
        ANGLE_CAPTURE(CreateShaderProgramv, isCallValid, context, typePacked, count, strings,
                      returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CreateShaderProgramv, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY CullFaceContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCullFace", "context = %d, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::CullFaceMode, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        CullFaceMode modePacked                       = FromGL<CullFaceMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCullFace(context, modePacked));
        if (isCallValid)
        {
            context->cullFace(modePacked);
        }
        ANGLE_CAPTURE(CullFace, isCallValid, context, modePacked);
    }
}

void GL_APIENTRY CurrentPaletteMatrixOESContextANGLE(GLeglContext ctx, GLuint matrixpaletteindex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glCurrentPaletteMatrixOES", "context = %d, GLuint matrixpaletteindex = %u", CID(context),
          matrixpaletteindex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex));
        if (isCallValid)
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
        ANGLE_CAPTURE(CurrentPaletteMatrixOES, isCallValid, context, matrixpaletteindex);
    }
}

void GL_APIENTRY DebugMessageCallbackContextANGLE(GLeglContext ctx,
                                                  GLDEBUGPROC callback,
                                                  const void *userParam)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDebugMessageCallback",
          "context = %d, GLDEBUGPROC callback = 0x%016" PRIxPTR
          ", const void *userParam = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)callback, (uintptr_t)userParam);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDebugMessageCallback(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallback, isCallValid, context, callback, userParam);
    }
}

void GL_APIENTRY DebugMessageCallbackKHRContextANGLE(GLeglContext ctx,
                                                     GLDEBUGPROCKHR callback,
                                                     const void *userParam)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDebugMessageCallbackKHR",
          "context = %d, GLDEBUGPROCKHR callback = 0x%016" PRIxPTR
          ", const void *userParam = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)callback, (uintptr_t)userParam);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDebugMessageCallbackKHR(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallbackKHR, isCallValid, context, callback, userParam);
    }
}

void GL_APIENTRY DebugMessageControlContextANGLE(GLeglContext ctx,
                                                 GLenum source,
                                                 GLenum type,
                                                 GLenum severity,
                                                 GLsizei count,
                                                 const GLuint *ids,
                                                 GLboolean enabled)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDebugMessageControl",
          "context = %d, GLenum source = %s, GLenum type = %s, GLenum severity = %s, GLsizei count "
          "= %d, const GLuint *ids = 0x%016" PRIxPTR ", GLboolean enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControl(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControl, isCallValid, context, source, type, severity, count, ids,
                      enabled);
    }
}

void GL_APIENTRY DebugMessageControlKHRContextANGLE(GLeglContext ctx,
                                                    GLenum source,
                                                    GLenum type,
                                                    GLenum severity,
                                                    GLsizei count,
                                                    const GLuint *ids,
                                                    GLboolean enabled)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDebugMessageControlKHR",
          "context = %d, GLenum source = %s, GLenum type = %s, GLenum severity = %s, GLsizei count "
          "= %d, const GLuint *ids = 0x%016" PRIxPTR ", GLboolean enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControlKHR, isCallValid, context, source, type, severity, count,
                      ids, enabled);
    }
}

void GL_APIENTRY DebugMessageInsertContextANGLE(GLeglContext ctx,
                                                GLenum source,
                                                GLenum type,
                                                GLuint id,
                                                GLenum severity,
                                                GLsizei length,
                                                const GLchar *buf)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDebugMessageInsert",
          "context = %d, GLenum source = %s, GLenum type = %s, GLuint id = %u, GLenum severity = "
          "%s, GLsizei length = %d, const GLchar *buf = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsert(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsert, isCallValid, context, source, type, id, severity, length,
                      buf);
    }
}

void GL_APIENTRY DebugMessageInsertKHRContextANGLE(GLeglContext ctx,
                                                   GLenum source,
                                                   GLenum type,
                                                   GLuint id,
                                                   GLenum severity,
                                                   GLsizei length,
                                                   const GLchar *buf)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDebugMessageInsertKHR",
          "context = %d, GLenum source = %s, GLenum type = %s, GLuint id = %u, GLenum severity = "
          "%s, GLsizei length = %d, const GLchar *buf = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsertKHR, isCallValid, context, source, type, id, severity,
                      length, buf);
    }
}

void GL_APIENTRY DeleteBuffersContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *buffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteBuffers",
          "context = %d, GLsizei n = %d, const GLuint *buffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)buffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteBuffers(context, n, buffersPacked));
        if (isCallValid)
        {
            context->deleteBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE(DeleteBuffers, isCallValid, context, n, buffersPacked);
    }
}

void GL_APIENTRY DeleteFencesNVContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *fences)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteFencesNV",
          "context = %d, GLsizei n = %d, const GLuint *fences = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)fences);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const FenceNVID *fencesPacked                 = FromGL<const FenceNVID *>(fences);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->deleteFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(DeleteFencesNV, isCallValid, context, n, fencesPacked);
    }
}

void GL_APIENTRY DeleteFramebuffersContextANGLE(GLeglContext ctx,
                                                GLsizei n,
                                                const GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteFramebuffers",
          "context = %d, GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const FramebufferID *framebuffersPacked       = FromGL<const FramebufferID *>(framebuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteFramebuffers(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
}

void GL_APIENTRY DeleteFramebuffersOESContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   const GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteFramebuffersOES",
          "context = %d, GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const FramebufferID *framebuffersPacked       = FromGL<const FramebufferID *>(framebuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
}

void GL_APIENTRY DeleteMemoryObjectsEXTContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *memoryObjects)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteMemoryObjectsEXT",
          "context = %d, GLsizei n = %d, const GLuint *memoryObjects = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)memoryObjects);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const MemoryObjectID *memoryObjectsPacked = FromGL<const MemoryObjectID *>(memoryObjects);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->deleteMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(DeleteMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
}

void GL_APIENTRY DeleteProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteProgram", "context = %d, GLuint program = %u", CID(context), program);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteProgram(context, programPacked));
        if (isCallValid)
        {
            context->deleteProgram(programPacked);
        }
        ANGLE_CAPTURE(DeleteProgram, isCallValid, context, programPacked);
    }
}

void GL_APIENTRY DeleteProgramPipelinesContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *pipelines)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteProgramPipelines",
          "context = %d, GLsizei n = %d, const GLuint *pipelines = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)pipelines);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const ProgramPipelineID *pipelinesPacked = FromGL<const ProgramPipelineID *>(pipelines);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteProgramPipelines(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(DeleteProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
}

void GL_APIENTRY DeleteQueriesContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteQueries", "context = %d, GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const QueryID *idsPacked                      = FromGL<const QueryID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteQueries(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteQueries, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY DeleteQueriesEXTContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteQueriesEXT",
          "context = %d, GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const QueryID *idsPacked                      = FromGL<const QueryID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteQueriesEXT, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY DeleteRenderbuffersContextANGLE(GLeglContext ctx,
                                                 GLsizei n,
                                                 const GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteRenderbuffers",
          "context = %d, GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const RenderbufferID *renderbuffersPacked = FromGL<const RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY DeleteRenderbuffersOESContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteRenderbuffersOES",
          "context = %d, GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const RenderbufferID *renderbuffersPacked = FromGL<const RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY DeleteSamplersContextANGLE(GLeglContext ctx, GLsizei count, const GLuint *samplers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteSamplers",
          "context = %d, GLsizei count = %d, const GLuint *samplers = 0x%016" PRIxPTR "",
          CID(context), count, (uintptr_t)samplers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const SamplerID *samplersPacked               = FromGL<const SamplerID *>(samplers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->deleteSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(DeleteSamplers, isCallValid, context, count, samplersPacked);
    }
}

void GL_APIENTRY DeleteSemaphoresEXTContextANGLE(GLeglContext ctx,
                                                 GLsizei n,
                                                 const GLuint *semaphores)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteSemaphoresEXT",
          "context = %d, GLsizei n = %d, const GLuint *semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const SemaphoreID *semaphoresPacked           = FromGL<const SemaphoreID *>(semaphores);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDeleteSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->deleteSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(DeleteSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
}

void GL_APIENTRY DeleteShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteShader", "context = %d, GLuint shader = %u", CID(context), shader);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteShader(context, shaderPacked));
        if (isCallValid)
        {
            context->deleteShader(shaderPacked);
        }
        ANGLE_CAPTURE(DeleteShader, isCallValid, context, shaderPacked);
    }
}

void GL_APIENTRY DeleteSyncContextANGLE(GLeglContext ctx, GLsync sync)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteSync", "context = %d, GLsync sync = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)sync);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDeleteSync(context, sync));
        if (isCallValid)
        {
            context->deleteSync(sync);
        }
        ANGLE_CAPTURE(DeleteSync, isCallValid, context, sync);
    }
}

void GL_APIENTRY DeleteTexturesContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *textures)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteTextures",
          "context = %d, GLsizei n = %d, const GLuint *textures = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)textures);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const TextureID *texturesPacked               = FromGL<const TextureID *>(textures);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteTextures(context, n, texturesPacked));
        if (isCallValid)
        {
            context->deleteTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE(DeleteTextures, isCallValid, context, n, texturesPacked);
    }
}

void GL_APIENTRY DeleteTransformFeedbacksContextANGLE(GLeglContext ctx,
                                                      GLsizei n,
                                                      const GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteTransformFeedbacks",
          "context = %d, GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const TransformFeedbackID *idsPacked          = FromGL<const TransformFeedbackID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteTransformFeedbacks(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteTransformFeedbacks(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteTransformFeedbacks, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY DeleteVertexArraysContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteVertexArrays",
          "context = %d, GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)arrays);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const VertexArrayID *arraysPacked             = FromGL<const VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArrays, isCallValid, context, n, arraysPacked);
    }
}

void GL_APIENTRY DeleteVertexArraysOESContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   const GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDeleteVertexArraysOES",
          "context = %d, GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)arrays);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const VertexArrayID *arraysPacked             = FromGL<const VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
}

void GL_APIENTRY DepthFuncContextANGLE(GLeglContext ctx, GLenum func)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDepthFunc", "context = %d, GLenum func = %s", CID(context),
          GLenumToString(GLenumGroup::DepthFunction, func));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthFunc(context, func));
        if (isCallValid)
        {
            context->depthFunc(func);
        }
        ANGLE_CAPTURE(DepthFunc, isCallValid, context, func);
    }
}

void GL_APIENTRY DepthMaskContextANGLE(GLeglContext ctx, GLboolean flag)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDepthMask", "context = %d, GLboolean flag = %s", CID(context),
          GLbooleanToString(flag));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthMask(context, flag));
        if (isCallValid)
        {
            context->depthMask(flag);
        }
        ANGLE_CAPTURE(DepthMask, isCallValid, context, flag);
    }
}

void GL_APIENTRY DepthRangefContextANGLE(GLeglContext ctx, GLfloat n, GLfloat f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDepthRangef", "context = %d, GLfloat n = %f, GLfloat f = %f", CID(context), n, f);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthRangef(context, n, f));
        if (isCallValid)
        {
            context->depthRangef(n, f);
        }
        ANGLE_CAPTURE(DepthRangef, isCallValid, context, n, f);
    }
}

void GL_APIENTRY DepthRangexContextANGLE(GLeglContext ctx, GLfixed n, GLfixed f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDepthRangex", "context = %d, GLfixed n = 0x%X, GLfixed f = 0x%X", CID(context), n, f);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthRangex(context, n, f));
        if (isCallValid)
        {
            context->depthRangex(n, f);
        }
        ANGLE_CAPTURE(DepthRangex, isCallValid, context, n, f);
    }
}

void GL_APIENTRY DetachShaderContextANGLE(GLeglContext ctx, GLuint program, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDetachShader", "context = %d, GLuint program = %u, GLuint shader = %u", CID(context),
          program, shader);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDetachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->detachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(DetachShader, isCallValid, context, programPacked, shaderPacked);
    }
}

void GL_APIENTRY DisableContextANGLE(GLeglContext ctx, GLenum cap)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDisable", "context = %d, GLenum cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDisable(context, cap));
        if (isCallValid)
        {
            context->disable(cap);
        }
        ANGLE_CAPTURE(Disable, isCallValid, context, cap);
    }
}

void GL_APIENTRY DisableClientStateContextANGLE(GLeglContext ctx, GLenum array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDisableClientState", "context = %d, GLenum array = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, array));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ClientVertexArrayType arrayPacked             = FromGL<ClientVertexArrayType>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableClientState(context, arrayPacked));
        if (isCallValid)
        {
            context->disableClientState(arrayPacked);
        }
        ANGLE_CAPTURE(DisableClientState, isCallValid, context, arrayPacked);
    }
}

void GL_APIENTRY DisableVertexAttribArrayContextANGLE(GLeglContext ctx, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDisableVertexAttribArray", "context = %d, GLuint index = %u", CID(context), index);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->disableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(DisableVertexAttribArray, isCallValid, context, index);
    }
}

void GL_APIENTRY DisableiContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDisablei", "context = %d, GLenum target = %s, GLuint index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDisablei(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(Disablei, isCallValid, context, target, index);
    }
}

void GL_APIENTRY DiscardFramebufferEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLsizei numAttachments,
                                                   const GLenum *attachments)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDiscardFramebufferEXT",
          "context = %d, GLenum target = %s, GLsizei numAttachments = %d, const GLenum "
          "*attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), numAttachments,
          (uintptr_t)attachments);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments));
        if (isCallValid)
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE(DiscardFramebufferEXT, isCallValid, context, target, numAttachments,
                      attachments);
    }
}

void GL_APIENTRY DispatchComputeContextANGLE(GLeglContext ctx,
                                             GLuint num_groups_x,
                                             GLuint num_groups_y,
                                             GLuint num_groups_z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDispatchCompute",
          "context = %d, GLuint num_groups_x = %u, GLuint num_groups_y = %u, GLuint num_groups_z = "
          "%u",
          CID(context), num_groups_x, num_groups_y, num_groups_z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDispatchCompute(context, num_groups_x, num_groups_y, num_groups_z));
        if (isCallValid)
        {
            context->dispatchCompute(num_groups_x, num_groups_y, num_groups_z);
        }
        ANGLE_CAPTURE(DispatchCompute, isCallValid, context, num_groups_x, num_groups_y,
                      num_groups_z);
    }
}

void GL_APIENTRY DispatchComputeIndirectContextANGLE(GLeglContext ctx, GLintptr indirect)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDispatchComputeIndirect", "context = %d, GLintptr indirect = %llu", CID(context),
          static_cast<unsigned long long>(indirect));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDispatchComputeIndirect(context, indirect));
        if (isCallValid)
        {
            context->dispatchComputeIndirect(indirect);
        }
        ANGLE_CAPTURE(DispatchComputeIndirect, isCallValid, context, indirect);
    }
}

void GL_APIENTRY DrawArraysContextANGLE(GLeglContext ctx, GLenum mode, GLint first, GLsizei count)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawArrays", "context = %d, GLenum mode = %s, GLint first = %d, GLsizei count = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), first, count);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawArrays(context, modePacked, first, count));
        if (isCallValid)
        {
            context->drawArrays(modePacked, first, count);
        }
        ANGLE_CAPTURE(DrawArrays, isCallValid, context, modePacked, first, count);
    }
}

void GL_APIENTRY DrawArraysIndirectContextANGLE(GLeglContext ctx, GLenum mode, const void *indirect)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawArraysIndirect",
          "context = %d, GLenum mode = %s, const void *indirect = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)indirect);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawArraysIndirect(context, modePacked, indirect));
        if (isCallValid)
        {
            context->drawArraysIndirect(modePacked, indirect);
        }
        ANGLE_CAPTURE(DrawArraysIndirect, isCallValid, context, modePacked, indirect);
    }
}

void GL_APIENTRY DrawArraysInstancedContextANGLE(GLeglContext ctx,
                                                 GLenum mode,
                                                 GLint first,
                                                 GLsizei count,
                                                 GLsizei instancecount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawArraysInstanced",
          "context = %d, GLenum mode = %s, GLint first = %d, GLsizei count = %d, GLsizei "
          "instancecount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), first, count,
          instancecount);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstanced(context, modePacked, first, count, instancecount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, first, count, instancecount);
        }
        ANGLE_CAPTURE(DrawArraysInstanced, isCallValid, context, modePacked, first, count,
                      instancecount);
    }
}

void GL_APIENTRY DrawArraysInstancedANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum mode,
                                                      GLint first,
                                                      GLsizei count,
                                                      GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawArraysInstancedANGLE",
          "context = %d, GLenum mode = %s, GLint first = %d, GLsizei count = %d, GLsizei primcount "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), first, count, primcount);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedANGLE(context, modePacked, first, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedANGLE, isCallValid, context, modePacked, first, count,
                      primcount);
    }
}

void GL_APIENTRY DrawArraysInstancedEXTContextANGLE(GLeglContext ctx,
                                                    GLenum mode,
                                                    GLint start,
                                                    GLsizei count,
                                                    GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawArraysInstancedEXT",
          "context = %d, GLenum mode = %s, GLint start = %d, GLsizei count = %d, GLsizei primcount "
          "= %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, count, primcount);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedEXT(context, modePacked, start, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedEXT, isCallValid, context, modePacked, start, count,
                      primcount);
    }
}

void GL_APIENTRY DrawBuffersContextANGLE(GLeglContext ctx, GLsizei n, const GLenum *bufs)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawBuffers", "context = %d, GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)bufs);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffers(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffers, isCallValid, context, n, bufs);
    }
}

void GL_APIENTRY DrawBuffersEXTContextANGLE(GLeglContext ctx, GLsizei n, const GLenum *bufs)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawBuffersEXT",
          "context = %d, GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)bufs);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffersEXT, isCallValid, context, n, bufs);
    }
}

void GL_APIENTRY DrawElementsContextANGLE(GLeglContext ctx,
                                          GLenum mode,
                                          GLsizei count,
                                          GLenum type,
                                          const void *indices)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElements",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElements(context, modePacked, count, typePacked, indices));
        if (isCallValid)
        {
            context->drawElements(modePacked, count, typePacked, indices);
        }
        ANGLE_CAPTURE(DrawElements, isCallValid, context, modePacked, count, typePacked, indices);
    }
}

void GL_APIENTRY DrawElementsBaseVertexContextANGLE(GLeglContext ctx,
                                                    GLenum mode,
                                                    GLsizei count,
                                                    GLenum type,
                                                    const void *indices,
                                                    GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsBaseVertex",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertex(context, modePacked, count, typePacked,
                                                           indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertex, isCallValid, context, modePacked, count, typePacked,
                      indices, basevertex);
    }
}

void GL_APIENTRY DrawElementsBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                       GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsBaseVertexEXT",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexEXT(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawElementsBaseVertexOESContextANGLE(GLeglContext ctx,
                                                       GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsBaseVertexOES",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexOES(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawElementsIndirectContextANGLE(GLeglContext ctx,
                                                  GLenum mode,
                                                  GLenum type,
                                                  const void *indirect)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsIndirect",
          "context = %d, GLenum mode = %s, GLenum type = %s, const void *indirect = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode),
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indirect);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawElementsIndirect(context, modePacked, typePacked, indirect));
        if (isCallValid)
        {
            context->drawElementsIndirect(modePacked, typePacked, indirect);
        }
        ANGLE_CAPTURE(DrawElementsIndirect, isCallValid, context, modePacked, typePacked, indirect);
    }
}

void GL_APIENTRY DrawElementsInstancedContextANGLE(GLeglContext ctx,
                                                   GLenum mode,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLsizei instancecount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsInstanced",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei instancecount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsInstanced(context, modePacked, count, typePacked,
                                                          indices, instancecount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, instancecount);
        }
        ANGLE_CAPTURE(DrawElementsInstanced, isCallValid, context, modePacked, count, typePacked,
                      indices, instancecount);
    }
}

void GL_APIENTRY DrawElementsInstancedANGLEContextANGLE(GLeglContext ctx,
                                                        GLenum mode,
                                                        GLsizei count,
                                                        GLenum type,
                                                        const void *indices,
                                                        GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsInstancedANGLE",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::PrimitiveType, type), (uintptr_t)indices, primcount);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsInstancedANGLE(context, modePacked, count,
                                                               typePacked, indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedANGLE, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount);
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertexContextANGLE(GLeglContext ctx,
                                                             GLenum mode,
                                                             GLsizei count,
                                                             GLenum type,
                                                             const void *indices,
                                                             GLsizei instancecount,
                                                             GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsInstancedBaseVertex",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei instancecount = %d, GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertex(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertex, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                                GLenum mode,
                                                                GLsizei count,
                                                                GLenum type,
                                                                const void *indices,
                                                                GLsizei instancecount,
                                                                GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsInstancedBaseVertexEXT",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei instancecount = %d, GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertexOESContextANGLE(GLeglContext ctx,
                                                                GLenum mode,
                                                                GLsizei count,
                                                                GLenum type,
                                                                const void *indices,
                                                                GLsizei instancecount,
                                                                GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsInstancedBaseVertexOES",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei instancecount = %d, GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexOES(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
}

void GL_APIENTRY DrawElementsInstancedEXTContextANGLE(GLeglContext ctx,
                                                      GLenum mode,
                                                      GLsizei count,
                                                      GLenum type,
                                                      const void *indices,
                                                      GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawElementsInstancedEXT",
          "context = %d, GLenum mode = %s, GLsizei count = %d, GLenum type = %s, const void "
          "*indices = 0x%016" PRIxPTR ", GLsizei primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDrawElementsInstancedEXT(context, modePacked, count, typePacked,
                                                             indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedEXT, isCallValid, context, modePacked, count, typePacked,
                      indices, primcount);
    }
}

void GL_APIENTRY DrawRangeElementsContextANGLE(GLeglContext ctx,
                                               GLenum mode,
                                               GLuint start,
                                               GLuint end,
                                               GLsizei count,
                                               GLenum type,
                                               const void *indices)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawRangeElements",
          "context = %d, GLenum mode = %s, GLuint start = %u, GLuint end = %u, GLsizei count = %d, "
          "GLenum type = %s, const void *indices = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawRangeElements(context, modePacked, start, end,
                                                                    count, typePacked, indices));
        if (isCallValid)
        {
            context->drawRangeElements(modePacked, start, end, count, typePacked, indices);
        }
        ANGLE_CAPTURE(DrawRangeElements, isCallValid, context, modePacked, start, end, count,
                      typePacked, indices);
    }
}

void GL_APIENTRY DrawRangeElementsBaseVertexContextANGLE(GLeglContext ctx,
                                                         GLenum mode,
                                                         GLuint start,
                                                         GLuint end,
                                                         GLsizei count,
                                                         GLenum type,
                                                         const void *indices,
                                                         GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawRangeElementsBaseVertex",
          "context = %d, GLenum mode = %s, GLuint start = %u, GLuint end = %u, GLsizei count = %d, "
          "GLenum type = %s, const void *indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertex(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertex, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawRangeElementsBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                            GLenum mode,
                                                            GLuint start,
                                                            GLuint end,
                                                            GLsizei count,
                                                            GLenum type,
                                                            const void *indices,
                                                            GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawRangeElementsBaseVertexEXT",
          "context = %d, GLenum mode = %s, GLuint start = %u, GLuint end = %u, GLsizei count = %d, "
          "GLenum type = %s, const void *indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexEXT(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexEXT, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawRangeElementsBaseVertexOESContextANGLE(GLeglContext ctx,
                                                            GLenum mode,
                                                            GLuint start,
                                                            GLuint end,
                                                            GLsizei count,
                                                            GLenum type,
                                                            const void *indices,
                                                            GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawRangeElementsBaseVertexOES",
          "context = %d, GLenum mode = %s, GLuint start = %u, GLuint end = %u, GLsizei count = %d, "
          "GLenum type = %s, const void *indices = 0x%016" PRIxPTR ", GLint basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexOES(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexOES, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
}

void GL_APIENTRY DrawTexfOESContextANGLE(GLeglContext ctx,
                                         GLfloat x,
                                         GLfloat y,
                                         GLfloat z,
                                         GLfloat width,
                                         GLfloat height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexfOES",
          "context = %d, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat width = %f, "
          "GLfloat height = %f",
          CID(context), x, y, z, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexf(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexfOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexfvOESContextANGLE(GLeglContext ctx, const GLfloat *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexfvOES", "context = %d, const GLfloat *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexfvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexfv(coords);
        }
        ANGLE_CAPTURE(DrawTexfvOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY
DrawTexiOESContextANGLE(GLeglContext ctx, GLint x, GLint y, GLint z, GLint width, GLint height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexiOES",
          "context = %d, GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height "
          "= %d",
          CID(context), x, y, z, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexi(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexiOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexivOESContextANGLE(GLeglContext ctx, const GLint *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexivOES", "context = %d, const GLint *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexivOES(context, coords));
        if (isCallValid)
        {
            context->drawTexiv(coords);
        }
        ANGLE_CAPTURE(DrawTexivOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY DrawTexsOESContextANGLE(GLeglContext ctx,
                                         GLshort x,
                                         GLshort y,
                                         GLshort z,
                                         GLshort width,
                                         GLshort height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexsOES",
          "context = %d, GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort width = %d, "
          "GLshort height = %d",
          CID(context), x, y, z, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexs(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexsOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexsvOESContextANGLE(GLeglContext ctx, const GLshort *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexsvOES", "context = %d, const GLshort *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexsvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexsv(coords);
        }
        ANGLE_CAPTURE(DrawTexsvOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY DrawTexxOESContextANGLE(GLeglContext ctx,
                                         GLfixed x,
                                         GLfixed y,
                                         GLfixed z,
                                         GLfixed width,
                                         GLfixed height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexxOES",
          "context = %d, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X, GLfixed width = "
          "0x%X, GLfixed height = 0x%X",
          CID(context), x, y, z, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexx(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexxOES, isCallValid, context, x, y, z, width, height);
    }
}

void GL_APIENTRY DrawTexxvOESContextANGLE(GLeglContext ctx, const GLfixed *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glDrawTexxvOES", "context = %d, const GLfixed *coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexxvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexxv(coords);
        }
        ANGLE_CAPTURE(DrawTexxvOES, isCallValid, context, coords);
    }
}

void GL_APIENTRY EGLImageTargetRenderbufferStorageOESContextANGLE(GLeglContext ctx,
                                                                  GLenum target,
                                                                  GLeglImageOES image)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEGLImageTargetRenderbufferStorageOES",
          "context = %d, GLenum target = %s, GLeglImageOES image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image));
        if (isCallValid)
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
        ANGLE_CAPTURE(EGLImageTargetRenderbufferStorageOES, isCallValid, context, target, image);
    }
}

void GL_APIENTRY EGLImageTargetTexture2DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLeglImageOES image)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEGLImageTargetTexture2DOES",
          "context = %d, GLenum target = %s, GLeglImageOES image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateEGLImageTargetTexture2DOES(context, targetPacked, image));
        if (isCallValid)
        {
            context->eGLImageTargetTexture2D(targetPacked, image);
        }
        ANGLE_CAPTURE(EGLImageTargetTexture2DOES, isCallValid, context, targetPacked, image);
    }
}

void GL_APIENTRY EnableContextANGLE(GLeglContext ctx, GLenum cap)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEnable", "context = %d, GLenum cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEnable(context, cap));
        if (isCallValid)
        {
            context->enable(cap);
        }
        ANGLE_CAPTURE(Enable, isCallValid, context, cap);
    }
}

void GL_APIENTRY EnableClientStateContextANGLE(GLeglContext ctx, GLenum array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEnableClientState", "context = %d, GLenum array = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, array));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ClientVertexArrayType arrayPacked             = FromGL<ClientVertexArrayType>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableClientState(context, arrayPacked));
        if (isCallValid)
        {
            context->enableClientState(arrayPacked);
        }
        ANGLE_CAPTURE(EnableClientState, isCallValid, context, arrayPacked);
    }
}

void GL_APIENTRY EnableVertexAttribArrayContextANGLE(GLeglContext ctx, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEnableVertexAttribArray", "context = %d, GLuint index = %u", CID(context), index);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->enableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(EnableVertexAttribArray, isCallValid, context, index);
    }
}

void GL_APIENTRY EnableiContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEnablei", "context = %d, GLenum target = %s, GLuint index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEnablei(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(Enablei, isCallValid, context, target, index);
    }
}

void GL_APIENTRY EndQueryContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEndQuery", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEndQuery(context, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE(EndQuery, isCallValid, context, targetPacked);
    }
}

void GL_APIENTRY EndQueryEXTContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEndQueryEXT", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEndQueryEXT(context, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE(EndQueryEXT, isCallValid, context, targetPacked);
    }
}

void GL_APIENTRY EndTransformFeedbackContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glEndTransformFeedback", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEndTransformFeedback(context));
        if (isCallValid)
        {
            context->endTransformFeedback();
        }
        ANGLE_CAPTURE(EndTransformFeedback, isCallValid, context);
    }
}

GLsync GL_APIENTRY FenceSyncContextANGLE(GLeglContext ctx, GLenum condition, GLbitfield flags)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFenceSync", "context = %d, GLenum condition = %s, GLbitfield flags = %s", CID(context),
          GLenumToString(GLenumGroup::SyncCondition, condition),
          GLbitfieldToString(GLenumGroup::DefaultGroup, flags).c_str());

    GLsync returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFenceSync(context, condition, flags));
        if (isCallValid)
        {
            returnValue = context->fenceSync(condition, flags);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::FenceSync, GLsync>();
        }
        ANGLE_CAPTURE(FenceSync, isCallValid, context, condition, flags, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::FenceSync, GLsync>();
    }
    return returnValue;
}

void GL_APIENTRY FinishContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFinish", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFinish(context));
        if (isCallValid)
        {
            context->finish();
        }
        ANGLE_CAPTURE(Finish, isCallValid, context);
    }
}

void GL_APIENTRY FinishFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFinishFenceNV", "context = %d, GLuint fence = %u", CID(context), fence);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFinishFenceNV(context, fencePacked));
        if (isCallValid)
        {
            context->finishFenceNV(fencePacked);
        }
        ANGLE_CAPTURE(FinishFenceNV, isCallValid, context, fencePacked);
    }
}

void GL_APIENTRY FlushContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFlush", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFlush(context));
        if (isCallValid)
        {
            context->flush();
        }
        ANGLE_CAPTURE(Flush, isCallValid, context);
    }
}

void GL_APIENTRY FlushMappedBufferRangeContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLintptr offset,
                                                    GLsizeiptr length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFlushMappedBufferRange",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr length = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFlushMappedBufferRange(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRange, isCallValid, context, targetPacked, offset, length);
    }
}

void GL_APIENTRY FlushMappedBufferRangeEXTContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLintptr offset,
                                                       GLsizeiptr length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFlushMappedBufferRangeEXT",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr length = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRangeEXT, isCallValid, context, targetPacked, offset,
                      length);
    }
}

void GL_APIENTRY FogfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFogf", "context = %d, GLenum pname = %s, GLfloat param = %f", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogf(context, pname, param));
        if (isCallValid)
        {
            context->fogf(pname, param);
        }
        ANGLE_CAPTURE(Fogf, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY FogfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFogfv", "context = %d, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FogParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogfv(context, pname, params));
        if (isCallValid)
        {
            context->fogfv(pname, params);
        }
        ANGLE_CAPTURE(Fogfv, isCallValid, context, pname, params);
    }
}

void GL_APIENTRY FogxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFogx", "context = %d, GLenum pname = %s, GLfixed param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::FogPName, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogx(context, pname, param));
        if (isCallValid)
        {
            context->fogx(pname, param);
        }
        ANGLE_CAPTURE(Fogx, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY FogxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFogxv", "context = %d, GLenum pname = %s, const GLfixed *param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FogPName, pname), (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogxv(context, pname, param));
        if (isCallValid)
        {
            context->fogxv(pname, param);
        }
        ANGLE_CAPTURE(Fogxv, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY FramebufferParameteriContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferParameteri",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint param = %d", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferParameterName, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferParameteri(context, target, pname, param));
        if (isCallValid)
        {
            context->framebufferParameteri(target, pname, param);
        }
        ANGLE_CAPTURE(FramebufferParameteri, isCallValid, context, target, pname, param);
    }
}

void GL_APIENTRY FramebufferRenderbufferContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum renderbuffertarget,
                                                     GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferRenderbuffer",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum renderbuffertarget = "
          "%s, GLuint renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                             renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbuffer, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
}

void GL_APIENTRY FramebufferRenderbufferOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLenum renderbuffertarget,
                                                        GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferRenderbufferOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum renderbuffertarget = "
          "%s, GLuint renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbufferOES(context, target, attachment, renderbuffertarget,
                                                renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbufferOES, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
}

void GL_APIENTRY FramebufferTextureContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLenum attachment,
                                                GLuint texture,
                                                GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTexture",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLuint texture = %u, GLint "
          "level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTexture, isCallValid, context, target, attachment, texturePacked,
                      level);
    }
}

void GL_APIENTRY FramebufferTexture2DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum attachment,
                                                  GLenum textarget,
                                                  GLuint texture,
                                                  GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTexture2D",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                 = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferTexture2D(context, target, attachment,
                                                         textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2D, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
}

void GL_APIENTRY FramebufferTexture2DMultisampleEXTContextANGLE(GLeglContext ctx,
                                                                GLenum target,
                                                                GLenum attachment,
                                                                GLenum textarget,
                                                                GLuint texture,
                                                                GLint level,
                                                                GLsizei samples)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTexture2DMultisampleEXT",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d, GLsizei samples = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, samples);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferTexture2DMultisampleEXT(
                                context, target, attachment, textarget, texture, level, samples));
        if (isCallValid)
        {
            context->framebufferTexture2DMultisample(target, attachment, textarget, texture, level,
                                                     samples);
        }
        ANGLE_CAPTURE(FramebufferTexture2DMultisampleEXT, isCallValid, context, target, attachment,
                      textarget, texture, level, samples);
    }
}

void GL_APIENTRY FramebufferTexture2DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum textarget,
                                                     GLuint texture,
                                                     GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTexture2DOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                 = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferTexture2DOES(context, target, attachment,
                                                            textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
}

void GL_APIENTRY FramebufferTexture3DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum textarget,
                                                     GLuint texture,
                                                     GLint level,
                                                     GLint zoffset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTexture3DOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum textarget = %s, GLuint "
          "texture = %u, GLint level = %d, GLint zoffset = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, zoffset);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                 = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture3DOES(context, target, attachment, textargetPacked,
                                             texturePacked, level, zoffset));
        if (isCallValid)
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE(FramebufferTexture3DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, zoffset);
    }
}

void GL_APIENTRY FramebufferTextureEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum attachment,
                                                   GLuint texture,
                                                   GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTextureEXT",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLuint texture = %u, GLint "
          "level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureEXT(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTextureEXT, isCallValid, context, target, attachment,
                      texturePacked, level);
    }
}

void GL_APIENTRY FramebufferTextureLayerContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLuint texture,
                                                     GLint level,
                                                     GLint layer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTextureLayer",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLuint texture = %u, GLint "
          "level = %d, GLint layer = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level, layer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateFramebufferTextureLayer(context, target, attachment,
                                                            texturePacked, level, layer));
        if (isCallValid)
        {
            context->framebufferTextureLayer(target, attachment, texturePacked, level, layer);
        }
        ANGLE_CAPTURE(FramebufferTextureLayer, isCallValid, context, target, attachment,
                      texturePacked, level, layer);
    }
}

void GL_APIENTRY FramebufferTextureMultiviewOVRContextANGLE(GLeglContext ctx,
                                                            GLenum target,
                                                            GLenum attachment,
                                                            GLuint texture,
                                                            GLint level,
                                                            GLint baseViewIndex,
                                                            GLsizei numViews)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFramebufferTextureMultiviewOVR",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLuint texture = %u, GLint "
          "level = %d, GLint baseViewIndex = %d, GLsizei numViews = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level,
          baseViewIndex, numViews);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureMultiviewOVR(context, target, attachment, texturePacked,
                                                    level, baseViewIndex, numViews));
        if (isCallValid)
        {
            context->framebufferTextureMultiview(target, attachment, texturePacked, level,
                                                 baseViewIndex, numViews);
        }
        ANGLE_CAPTURE(FramebufferTextureMultiviewOVR, isCallValid, context, target, attachment,
                      texturePacked, level, baseViewIndex, numViews);
    }
}

void GL_APIENTRY FrontFaceContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFrontFace", "context = %d, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::FrontFaceDirection, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFrontFace(context, mode));
        if (isCallValid)
        {
            context->frontFace(mode);
        }
        ANGLE_CAPTURE(FrontFace, isCallValid, context, mode);
    }
}

void GL_APIENTRY FrustumfContextANGLE(GLeglContext ctx,
                                      GLfloat l,
                                      GLfloat r,
                                      GLfloat b,
                                      GLfloat t,
                                      GLfloat n,
                                      GLfloat f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFrustumf",
          "context = %d, GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n "
          "= %f, GLfloat f = %f",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustumf(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->frustumf(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Frustumf, isCallValid, context, l, r, b, t, n, f);
    }
}

void GL_APIENTRY FrustumxContextANGLE(GLeglContext ctx,
                                      GLfixed l,
                                      GLfixed r,
                                      GLfixed b,
                                      GLfixed t,
                                      GLfixed n,
                                      GLfixed f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glFrustumx",
          "context = %d, GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, "
          "GLfixed n = 0x%X, GLfixed f = 0x%X",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustumx(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->frustumx(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Frustumx, isCallValid, context, l, r, b, t, n, f);
    }
}

void GL_APIENTRY GenBuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *buffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenBuffers", "context = %d, GLsizei n = %d, GLuint *buffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)buffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID *buffersPacked                       = FromGL<BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenBuffers(context, n, buffersPacked));
        if (isCallValid)
        {
            context->genBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE(GenBuffers, isCallValid, context, n, buffersPacked);
    }
}

void GL_APIENTRY GenFencesNVContextANGLE(GLeglContext ctx, GLsizei n, GLuint *fences)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenFencesNV", "context = %d, GLsizei n = %d, GLuint *fences = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)fences);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID *fencesPacked                       = FromGL<FenceNVID *>(fences);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->genFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(GenFencesNV, isCallValid, context, n, fencesPacked);
    }
}

void GL_APIENTRY GenFramebuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenFramebuffers",
          "context = %d, GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID *framebuffersPacked             = FromGL<FramebufferID *>(framebuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
}

void GL_APIENTRY GenFramebuffersOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenFramebuffersOES",
          "context = %d, GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID *framebuffersPacked             = FromGL<FramebufferID *>(framebuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGenFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
}

void GL_APIENTRY GenProgramPipelinesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *pipelines)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenProgramPipelines",
          "context = %d, GLsizei n = %d, GLuint *pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID *pipelinesPacked            = FromGL<ProgramPipelineID *>(pipelines);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenProgramPipelines(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(GenProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
}

void GL_APIENTRY GenQueriesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenQueries", "context = %d, GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID *idsPacked                            = FromGL<QueryID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGenQueries(context, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(GenQueries, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY GenQueriesEXTContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenQueriesEXT", "context = %d, GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID *idsPacked                            = FromGL<QueryID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(GenQueriesEXT, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY GenRenderbuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenRenderbuffers",
          "context = %d, GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)renderbuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID *renderbuffersPacked           = FromGL<RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGenRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY GenRenderbuffersOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenRenderbuffersOES",
          "context = %d, GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)renderbuffers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID *renderbuffersPacked           = FromGL<RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGenRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY GenSamplersContextANGLE(GLeglContext ctx, GLsizei count, GLuint *samplers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenSamplers", "context = %d, GLsizei count = %d, GLuint *samplers = 0x%016" PRIxPTR "",
          CID(context), count, (uintptr_t)samplers);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID *samplersPacked                     = FromGL<SamplerID *>(samplers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->genSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(GenSamplers, isCallValid, context, count, samplersPacked);
    }
}

void GL_APIENTRY GenSemaphoresEXTContextANGLE(GLeglContext ctx, GLsizei n, GLuint *semaphores)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenSemaphoresEXT",
          "context = %d, GLsizei n = %d, GLuint *semaphores = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)semaphores);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID *semaphoresPacked                 = FromGL<SemaphoreID *>(semaphores);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->genSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(GenSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
}

void GL_APIENTRY GenTexturesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *textures)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenTextures", "context = %d, GLsizei n = %d, GLuint *textures = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID *texturesPacked                     = FromGL<TextureID *>(textures);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenTextures(context, n, texturesPacked));
        if (isCallValid)
        {
            context->genTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE(GenTextures, isCallValid, context, n, texturesPacked);
    }
}

void GL_APIENTRY GenTransformFeedbacksContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenTransformFeedbacks",
          "context = %d, GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TransformFeedbackID *idsPacked                = FromGL<TransformFeedbackID *>(ids);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenTransformFeedbacks(context, n, idsPacked));
        if (isCallValid)
        {
            context->genTransformFeedbacks(n, idsPacked);
        }
        ANGLE_CAPTURE(GenTransformFeedbacks, isCallValid, context, n, idsPacked);
    }
}

void GL_APIENTRY GenVertexArraysContextANGLE(GLeglContext ctx, GLsizei n, GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenVertexArrays", "context = %d, GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID *arraysPacked                   = FromGL<VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArrays, isCallValid, context, n, arraysPacked);
    }
}

void GL_APIENTRY GenVertexArraysOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenVertexArraysOES",
          "context = %d, GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)arrays);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID *arraysPacked                   = FromGL<VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
}

void GL_APIENTRY GenerateMipmapContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenerateMipmap", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmap(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmap, isCallValid, context, targetPacked);
    }
}

void GL_APIENTRY GenerateMipmapOESContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGenerateMipmapOES", "context = %d, GLenum target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmapOES(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmapOES, isCallValid, context, targetPacked);
    }
}

void GL_APIENTRY GetActiveAttribContextANGLE(GLeglContext ctx,
                                             GLuint program,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *size,
                                             GLenum *type,
                                             GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetActiveAttrib",
          "context = %d, GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR
          ", GLenum *type = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetActiveAttrib(context, programPacked, index, bufSize, length,
                                                    size, type, name));
        if (isCallValid)
        {
            context->getActiveAttrib(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveAttrib, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
}

void GL_APIENTRY GetActiveUniformContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *size,
                                              GLenum *type,
                                              GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetActiveUniform",
          "context = %d, GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR
          ", GLenum *type = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetActiveUniform(context, programPacked, index, bufSize, length,
                                                     size, type, name));
        if (isCallValid)
        {
            context->getActiveUniform(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveUniform, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
}

void GL_APIENTRY GetActiveUniformBlockNameContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLuint uniformBlockIndex,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLchar *uniformBlockName)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetActiveUniformBlockName",
          "context = %d, GLuint program = %u, GLuint uniformBlockIndex = %u, GLsizei bufSize = %d, "
          "GLsizei *length = 0x%016" PRIxPTR ", GLchar *uniformBlockName = 0x%016" PRIxPTR "",
          CID(context), program, uniformBlockIndex, bufSize, (uintptr_t)length,
          (uintptr_t)uniformBlockName);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetActiveUniformBlockName(context, programPacked, uniformBlockIndex, bufSize,
                                               length, uniformBlockName));
        if (isCallValid)
        {
            context->getActiveUniformBlockName(programPacked, uniformBlockIndex, bufSize, length,
                                               uniformBlockName);
        }
        ANGLE_CAPTURE(GetActiveUniformBlockName, isCallValid, context, programPacked,
                      uniformBlockIndex, bufSize, length, uniformBlockName);
    }
}

void GL_APIENTRY GetActiveUniformBlockivContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLuint uniformBlockIndex,
                                                     GLenum pname,
                                                     GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetActiveUniformBlockiv",
          "context = %d, GLuint program = %u, GLuint uniformBlockIndex = %u, GLenum pname = %s, "
          "GLint *params = 0x%016" PRIxPTR "",
          CID(context), program, uniformBlockIndex,
          GLenumToString(GLenumGroup::UniformBlockPName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetActiveUniformBlockiv(context, programPacked,
                                                            uniformBlockIndex, pname, params));
        if (isCallValid)
        {
            context->getActiveUniformBlockiv(programPacked, uniformBlockIndex, pname, params);
        }
        ANGLE_CAPTURE(GetActiveUniformBlockiv, isCallValid, context, programPacked,
                      uniformBlockIndex, pname, params);
    }
}

void GL_APIENTRY GetActiveUniformsivContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLsizei uniformCount,
                                                 const GLuint *uniformIndices,
                                                 GLenum pname,
                                                 GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetActiveUniformsiv",
          "context = %d, GLuint program = %u, GLsizei uniformCount = %d, const GLuint "
          "*uniformIndices = 0x%016" PRIxPTR ", GLenum pname = %s, GLint *params = 0x%016" PRIxPTR
          "",
          CID(context), program, uniformCount, (uintptr_t)uniformIndices,
          GLenumToString(GLenumGroup::UniformPName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetActiveUniformsiv(context, programPacked, uniformCount,
                                                        uniformIndices, pname, params));
        if (isCallValid)
        {
            context->getActiveUniformsiv(programPacked, uniformCount, uniformIndices, pname,
                                         params);
        }
        ANGLE_CAPTURE(GetActiveUniformsiv, isCallValid, context, programPacked, uniformCount,
                      uniformIndices, pname, params);
    }
}

void GL_APIENTRY GetAttachedShadersContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLsizei maxCount,
                                                GLsizei *count,
                                                GLuint *shaders)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetAttachedShaders",
        "context = %d, GLuint program = %u, GLsizei maxCount = %d, GLsizei *count = 0x%016" PRIxPTR
        ", GLuint *shaders = 0x%016" PRIxPTR "",
        CID(context), program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        ShaderProgramID *shadersPacked                = FromGL<ShaderProgramID *>(shaders);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetAttachedShaders(context, programPacked, maxCount, count, shadersPacked));
        if (isCallValid)
        {
            context->getAttachedShaders(programPacked, maxCount, count, shadersPacked);
        }
        ANGLE_CAPTURE(GetAttachedShaders, isCallValid, context, programPacked, maxCount, count,
                      shadersPacked);
    }
}

GLint GL_APIENTRY GetAttribLocationContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetAttribLocation",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetAttribLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getAttribLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
        }
        ANGLE_CAPTURE(GetAttribLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetBooleani_vContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLuint index,
                                           GLboolean *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetBooleani_v",
        "context = %d, GLenum target = %s, GLuint index = %u, GLboolean *data = 0x%016" PRIxPTR "",
        CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), index, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetBooleani_v(context, target, index, data));
        if (isCallValid)
        {
            context->getBooleani_v(target, index, data);
        }
        ANGLE_CAPTURE(GetBooleani_v, isCallValid, context, target, index, data);
    }
}

void GL_APIENTRY GetBooleanvContextANGLE(GLeglContext ctx, GLenum pname, GLboolean *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetBooleanv", "context = %d, GLenum pname = %s, GLboolean *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetBooleanv(context, pname, data));
        if (isCallValid)
        {
            context->getBooleanv(pname, data);
        }
        ANGLE_CAPTURE(GetBooleanv, isCallValid, context, pname, data);
    }
}

void GL_APIENTRY GetBufferParameteri64vContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum pname,
                                                    GLint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetBufferParameteri64v",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint64 *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferParameteri64v(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferParameteri64v(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferParameteri64v, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetBufferParameterivContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetBufferParameteriv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferParameteriv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferParameteriv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetBufferPointervContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetBufferPointerv",
          "context = %d, GLenum target = %s, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferPointerv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferPointerv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetBufferPointervOESContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetBufferPointervOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetBufferPointervOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferPointervOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetClipPlanefContextANGLE(GLeglContext ctx, GLenum plane, GLfloat *equation)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetClipPlanef",
          "context = %d, GLenum plane = %s, GLfloat *equation = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetClipPlanef(context, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanef(plane, equation);
        }
        ANGLE_CAPTURE(GetClipPlanef, isCallValid, context, plane, equation);
    }
}

void GL_APIENTRY GetClipPlanexContextANGLE(GLeglContext ctx, GLenum plane, GLfixed *equation)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetClipPlanex",
          "context = %d, GLenum plane = %s, GLfixed *equation = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetClipPlanex(context, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanex(plane, equation);
        }
        ANGLE_CAPTURE(GetClipPlanex, isCallValid, context, plane, equation);
    }
}

GLuint GL_APIENTRY GetDebugMessageLogContextANGLE(GLeglContext ctx,
                                                  GLuint count,
                                                  GLsizei bufSize,
                                                  GLenum *sources,
                                                  GLenum *types,
                                                  GLuint *ids,
                                                  GLenum *severities,
                                                  GLsizei *lengths,
                                                  GLchar *messageLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetDebugMessageLog",
          "context = %d, GLuint count = %u, GLsizei bufSize = %d, GLenum *sources = 0x%016" PRIxPTR
          ", GLenum *types = 0x%016" PRIxPTR ", GLuint *ids = 0x%016" PRIxPTR
          ", GLenum *severities = 0x%016" PRIxPTR ", GLsizei *lengths = 0x%016" PRIxPTR
          ", GLchar *messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetDebugMessageLog(context, count, bufSize, sources, types, ids,
                                                       severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLog, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLog, isCallValid, context, count, bufSize, sources, types, ids,
                      severities, lengths, messageLog, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLog, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY GetDebugMessageLogKHRContextANGLE(GLeglContext ctx,
                                                     GLuint count,
                                                     GLsizei bufSize,
                                                     GLenum *sources,
                                                     GLenum *types,
                                                     GLuint *ids,
                                                     GLenum *severities,
                                                     GLsizei *lengths,
                                                     GLchar *messageLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetDebugMessageLogKHR",
          "context = %d, GLuint count = %u, GLsizei bufSize = %d, GLenum *sources = 0x%016" PRIxPTR
          ", GLenum *types = 0x%016" PRIxPTR ", GLuint *ids = 0x%016" PRIxPTR
          ", GLenum *severities = 0x%016" PRIxPTR ", GLsizei *lengths = 0x%016" PRIxPTR
          ", GLchar *messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types,
                                                          ids, severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLogKHR, isCallValid, context, count, bufSize, sources, types,
                      ids, severities, lengths, messageLog, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
    }
    return returnValue;
}

GLenum GL_APIENTRY GetErrorContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetError", "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetError(context));
        if (isCallValid)
        {
            returnValue = context->getError();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetError, GLenum>();
        }
        ANGLE_CAPTURE(GetError, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetError, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GetFenceivNVContextANGLE(GLeglContext ctx,
                                          GLuint fence,
                                          GLenum pname,
                                          GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFenceivNV",
          "context = %d, GLuint fence = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), fence, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFenceivNV(context, fencePacked, pname, params));
        if (isCallValid)
        {
            context->getFenceivNV(fencePacked, pname, params);
        }
        ANGLE_CAPTURE(GetFenceivNV, isCallValid, context, fencePacked, pname, params);
    }
}

void GL_APIENTRY GetFixedvContextANGLE(GLeglContext ctx, GLenum pname, GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFixedv", "context = %d, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetFixedv(context, pname, params));
        if (isCallValid)
        {
            context->getFixedv(pname, params);
        }
        ANGLE_CAPTURE(GetFixedv, isCallValid, context, pname, params);
    }
}

void GL_APIENTRY GetFloatvContextANGLE(GLeglContext ctx, GLenum pname, GLfloat *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFloatv", "context = %d, GLenum pname = %s, GLfloat *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetFloatv(context, pname, data));
        if (isCallValid)
        {
            context->getFloatv(pname, data);
        }
        ANGLE_CAPTURE(GetFloatv, isCallValid, context, pname, data);
    }
}

GLint GL_APIENTRY GetFragDataIndexEXTContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFragDataIndexEXT",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFragDataIndexEXT(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndexEXT, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataIndexEXT, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndexEXT, GLint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GetFragDataLocationContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFragDataLocation",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFragDataLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetFramebufferAttachmentParameterivContextANGLE(GLeglContext ctx,
                                                                 GLenum target,
                                                                 GLenum attachment,
                                                                 GLenum pname,
                                                                 GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFramebufferAttachmentParameteriv",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum pname = %s, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameteriv(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameteriv, isCallValid, context, target, attachment,
                      pname, params);
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivOESContextANGLE(GLeglContext ctx,
                                                                    GLenum target,
                                                                    GLenum attachment,
                                                                    GLenum pname,
                                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFramebufferAttachmentParameterivOES",
          "context = %d, GLenum target = %s, GLenum attachment = %s, GLenum pname = %s, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameterivOES(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivOES, isCallValid, context, target,
                      attachment, pname, params);
    }
}

void GL_APIENTRY GetFramebufferParameterivContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetFramebufferParameteriv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetFramebufferParameteriv(context, target, pname, params));
        if (isCallValid)
        {
            context->getFramebufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferParameteriv, isCallValid, context, target, pname, params);
    }
}

GLenum GL_APIENTRY GetGraphicsResetStatusContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetGraphicsResetStatus", "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetGraphicsResetStatus(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatus, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatus, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatus, GLenum>();
    }
    return returnValue;
}

GLenum GL_APIENTRY GetGraphicsResetStatusEXTContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetGraphicsResetStatusEXT", "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatusEXT, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GetInteger64i_vContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLuint index,
                                             GLint64 *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetInteger64i_v",
          "context = %d, GLenum target = %s, GLuint index = %u, GLint64 *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetInteger64i_v(context, target, index, data));
        if (isCallValid)
        {
            context->getInteger64i_v(target, index, data);
        }
        ANGLE_CAPTURE(GetInteger64i_v, isCallValid, context, target, index, data);
    }
}

void GL_APIENTRY GetInteger64vContextANGLE(GLeglContext ctx, GLenum pname, GLint64 *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetInteger64v", "context = %d, GLenum pname = %s, GLint64 *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetInteger64v(context, pname, data));
        if (isCallValid)
        {
            context->getInteger64v(pname, data);
        }
        ANGLE_CAPTURE(GetInteger64v, isCallValid, context, pname, data);
    }
}

void GL_APIENTRY GetIntegeri_vContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLuint index,
                                           GLint *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetIntegeri_v",
          "context = %d, GLenum target = %s, GLuint index = %u, GLint *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetIntegeri_v(context, target, index, data));
        if (isCallValid)
        {
            context->getIntegeri_v(target, index, data);
        }
        ANGLE_CAPTURE(GetIntegeri_v, isCallValid, context, target, index, data);
    }
}

void GL_APIENTRY GetIntegervContextANGLE(GLeglContext ctx, GLenum pname, GLint *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetIntegerv", "context = %d, GLenum pname = %s, GLint *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetIntegerv(context, pname, data));
        if (isCallValid)
        {
            context->getIntegerv(pname, data);
        }
        ANGLE_CAPTURE(GetIntegerv, isCallValid, context, pname, data);
    }
}

void GL_APIENTRY GetInternalformativContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum internalformat,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetInternalformativ",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLenum pname = %s, "
          "GLsizei bufSize = %d, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat),
          GLenumToString(GLenumGroup::InternalFormatPName, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInternalformativ(context, target, internalformat, pname, bufSize, params));
        if (isCallValid)
        {
            context->getInternalformativ(target, internalformat, pname, bufSize, params);
        }
        ANGLE_CAPTURE(GetInternalformativ, isCallValid, context, target, internalformat, pname,
                      bufSize, params);
    }
}

void GL_APIENTRY GetLightfvContextANGLE(GLeglContext ctx,
                                        GLenum light,
                                        GLenum pname,
                                        GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetLightfv",
          "context = %d, GLenum light = %s, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                    = FromGL<LightParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetLightfv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->getLightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetLightfv, isCallValid, context, light, pnamePacked, params);
    }
}

void GL_APIENTRY GetLightxvContextANGLE(GLeglContext ctx,
                                        GLenum light,
                                        GLenum pname,
                                        GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetLightxv",
          "context = %d, GLenum light = %s, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                    = FromGL<LightParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetLightxv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->getLightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetLightxv, isCallValid, context, light, pnamePacked, params);
    }
}

void GL_APIENTRY GetMaterialfvContextANGLE(GLeglContext ctx,
                                           GLenum face,
                                           GLenum pname,
                                           GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetMaterialfv",
          "context = %d, GLenum face = %s, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                 = FromGL<MaterialParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetMaterialfv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetMaterialfv, isCallValid, context, face, pnamePacked, params);
    }
}

void GL_APIENTRY GetMaterialxvContextANGLE(GLeglContext ctx,
                                           GLenum face,
                                           GLenum pname,
                                           GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetMaterialxv",
          "context = %d, GLenum face = %s, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                 = FromGL<MaterialParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetMaterialxv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialxv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetMaterialxv, isCallValid, context, face, pnamePacked, params);
    }
}

void GL_APIENTRY GetMemoryObjectParameterivEXTContextANGLE(GLeglContext ctx,
                                                           GLuint memoryObject,
                                                           GLenum pname,
                                                           GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetMemoryObjectParameterivEXT",
        "context = %d, GLuint memoryObject = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
        (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryObjectPacked             = FromGL<MemoryObjectID>(memoryObject);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->getMemoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(GetMemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked,
                      pname, params);
    }
}

void GL_APIENTRY GetMultisamplefvContextANGLE(GLeglContext ctx,
                                              GLenum pname,
                                              GLuint index,
                                              GLfloat *val)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetMultisamplefv",
          "context = %d, GLenum pname = %s, GLuint index = %u, GLfloat *val = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), index, (uintptr_t)val);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetMultisamplefv(context, pname, index, val));
        if (isCallValid)
        {
            context->getMultisamplefv(pname, index, val);
        }
        ANGLE_CAPTURE(GetMultisamplefv, isCallValid, context, pname, index, val);
    }
}

void GL_APIENTRY GetObjectLabelContextANGLE(GLeglContext ctx,
                                            GLenum identifier,
                                            GLuint name,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetObjectLabel",
          "context = %d, GLenum identifier = %s, GLuint name = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLchar *label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabel(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabel, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
}

void GL_APIENTRY GetObjectLabelKHRContextANGLE(GLeglContext ctx,
                                               GLenum identifier,
                                               GLuint name,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetObjectLabelKHR",
          "context = %d, GLenum identifier = %s, GLuint name = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLchar *label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabelKHR, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
}

void GL_APIENTRY GetObjectPtrLabelContextANGLE(GLeglContext ctx,
                                               const void *ptr,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetObjectPtrLabel",
          "context = %d, const void *ptr = 0x%016" PRIxPTR
          ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetObjectPtrLabel(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabel, isCallValid, context, ptr, bufSize, length, label);
    }
}

void GL_APIENTRY GetObjectPtrLabelKHRContextANGLE(GLeglContext ctx,
                                                  const void *ptr,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetObjectPtrLabelKHR",
          "context = %d, const void *ptr = 0x%016" PRIxPTR
          ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabelKHR, isCallValid, context, ptr, bufSize, length, label);
    }
}

void GL_APIENTRY GetPointervContextANGLE(GLeglContext ctx, GLenum pname, void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetPointerv", "context = %d, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPointervPName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointerv(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointerv, isCallValid, context, pname, params);
    }
}

void GL_APIENTRY GetPointervKHRContextANGLE(GLeglContext ctx, GLenum pname, void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetPointervKHR", "context = %d, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointervKHR(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointervKHR, isCallValid, context, pname, params);
    }
}

void GL_APIENTRY GetProgramBinaryContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLenum *binaryFormat,
                                              void *binary)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetProgramBinary",
        "context = %d, GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR "",
        CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
        (uintptr_t)binary);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramBinary(context, programPacked, bufSize,
                                                                   length, binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinary, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
}

void GL_APIENTRY GetProgramBinaryOESContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLenum *binaryFormat,
                                                 void *binary)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetProgramBinaryOES",
        "context = %d, GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR "",
        CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
        (uintptr_t)binary);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramBinaryOES(context, programPacked, bufSize, length,
                                                        binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinaryOES, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
}

void GL_APIENTRY GetProgramInfoLogContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetProgramInfoLog",
        "context = %d, GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLchar *infoLog = 0x%016" PRIxPTR "",
        CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramInfoLog(context, programPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramInfoLog(programPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramInfoLog, isCallValid, context, programPacked, bufSize, length,
                      infoLog);
    }
}

void GL_APIENTRY GetProgramInterfaceivContextANGLE(GLeglContext ctx,
                                                   GLuint program,
                                                   GLenum programInterface,
                                                   GLenum pname,
                                                   GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramInterfaceiv",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, GLenum pname = %s, "
          "GLint *params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          GLenumToString(GLenumGroup::ProgramInterfacePName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramInterfaceiv(context, programPacked, programInterface,
                                                          pname, params));
        if (isCallValid)
        {
            context->getProgramInterfaceiv(programPacked, programInterface, pname, params);
        }
        ANGLE_CAPTURE(GetProgramInterfaceiv, isCallValid, context, programPacked, programInterface,
                      pname, params);
    }
}

void GL_APIENTRY GetProgramPipelineInfoLogContextANGLE(GLeglContext ctx,
                                                       GLuint pipeline,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetProgramPipelineInfoLog",
        "context = %d, GLuint pipeline = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLchar *infoLog = 0x%016" PRIxPTR "",
        CID(context), pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked              = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramPipelineInfoLog(context, pipelinePacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramPipelineInfoLog, isCallValid, context, pipelinePacked, bufSize,
                      length, infoLog);
    }
}

void GL_APIENTRY GetProgramPipelineivContextANGLE(GLeglContext ctx,
                                                  GLuint pipeline,
                                                  GLenum pname,
                                                  GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramPipelineiv",
          "context = %d, GLuint pipeline = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR
          "",
          CID(context), pipeline, GLenumToString(GLenumGroup::PipelineParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked              = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramPipelineiv(context, pipelinePacked, pname, params));
        if (isCallValid)
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramPipelineiv, isCallValid, context, pipelinePacked, pname, params);
    }
}

GLuint GL_APIENTRY GetProgramResourceIndexContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLenum programInterface,
                                                       const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramResourceIndex",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, const GLchar *name = "
          "0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramResourceIndex(context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue = context->getProgramResourceIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetProgramResourceIndex, GLuint>();
        }
        ANGLE_CAPTURE(GetProgramResourceIndex, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetProgramResourceIndex, GLuint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GetProgramResourceLocationContextANGLE(GLeglContext ctx,
                                                         GLuint program,
                                                         GLenum programInterface,
                                                         const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramResourceLocation",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, const GLchar *name = "
          "0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramResourceLocation(context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocation(programPacked, programInterface, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetProgramResourceLocation, GLint>();
        }
        ANGLE_CAPTURE(GetProgramResourceLocation, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetProgramResourceLocation, GLint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GetProgramResourceLocationIndexEXTContextANGLE(GLeglContext ctx,
                                                                 GLuint program,
                                                                 GLenum programInterface,
                                                                 const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramResourceLocationIndexEXT",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, const GLchar *name = "
          "0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramResourceLocationIndexEXT(
                                              context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocationIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<EntryPoint::GetProgramResourceLocationIndexEXT, GLint>();
        }
        ANGLE_CAPTURE(GetProgramResourceLocationIndexEXT, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        returnValue =
            GetDefaultReturnValue<EntryPoint::GetProgramResourceLocationIndexEXT, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetProgramResourceNameContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    GLenum programInterface,
                                                    GLuint index,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramResourceName",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, GLuint index = %u, "
          "GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR
          "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          index, bufSize, (uintptr_t)length, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramResourceName(context, programPacked, programInterface,
                                                           index, bufSize, length, name));
        if (isCallValid)
        {
            context->getProgramResourceName(programPacked, programInterface, index, bufSize, length,
                                            name);
        }
        ANGLE_CAPTURE(GetProgramResourceName, isCallValid, context, programPacked, programInterface,
                      index, bufSize, length, name);
    }
}

void GL_APIENTRY GetProgramResourceivContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  GLenum programInterface,
                                                  GLuint index,
                                                  GLsizei propCount,
                                                  const GLenum *props,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramResourceiv",
          "context = %d, GLuint program = %u, GLenum programInterface = %s, GLuint index = %u, "
          "GLsizei propCount = %d, const GLenum *props = 0x%016" PRIxPTR
          ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLint *params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          index, propCount, (uintptr_t)props, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramResourceiv(context, programPacked, programInterface, index,
                                          propCount, props, bufSize, length, params));
        if (isCallValid)
        {
            context->getProgramResourceiv(programPacked, programInterface, index, propCount, props,
                                          bufSize, length, params);
        }
        ANGLE_CAPTURE(GetProgramResourceiv, isCallValid, context, programPacked, programInterface,
                      index, propCount, props, bufSize, length, params);
    }
}

void GL_APIENTRY GetProgramivContextANGLE(GLeglContext ctx,
                                          GLuint program,
                                          GLenum pname,
                                          GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetProgramiv",
          "context = %d, GLuint program = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramPropertyARB, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramiv(context, programPacked, pname, params));
        if (isCallValid)
        {
            context->getProgramiv(programPacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramiv, isCallValid, context, programPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjecti64vEXTContextANGLE(GLeglContext ctx,
                                                   GLuint id,
                                                   GLenum pname,
                                                   GLint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryObjecti64vEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLint64 *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjecti64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64vEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectivEXTContextANGLE(GLeglContext ctx,
                                                 GLuint id,
                                                 GLenum pname,
                                                 GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryObjectivEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectivEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectui64vEXTContextANGLE(GLeglContext ctx,
                                                    GLuint id,
                                                    GLenum pname,
                                                    GLuint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryObjectui64vEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLuint64 *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectui64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64vEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectuivContextANGLE(GLeglContext ctx,
                                               GLuint id,
                                               GLenum pname,
                                               GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryObjectuiv",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectuiv(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuiv, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryObjectuivEXTContextANGLE(GLeglContext ctx,
                                                  GLuint id,
                                                  GLenum pname,
                                                  GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryObjectuivEXT",
          "context = %d, GLuint id = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryObjectuivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuivEXT, isCallValid, context, idPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryivContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLenum pname,
                                        GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryiv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryiv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetQueryivEXTContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetQueryivEXT",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetQueryivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryivEXT, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetRenderbufferParameterivContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum pname,
                                                        GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetRenderbufferParameteriv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetRenderbufferParameteriv(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameteriv, isCallValid, context, target, pname, params);
    }
}

void GL_APIENTRY GetRenderbufferParameterivOESContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLenum pname,
                                                           GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetRenderbufferParameterivOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetRenderbufferParameterivOES(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameterivOES, isCallValid, context, target, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterIivContextANGLE(GLeglContext ctx,
                                                    GLuint sampler,
                                                    GLenum pname,
                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSamplerParameterIiv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterIiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIiv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterIivOESContextANGLE(GLeglContext ctx,
                                                       GLuint sampler,
                                                       GLenum pname,
                                                       GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSamplerParameterIivOES",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
}

void GL_APIENTRY GetSamplerParameterIuivContextANGLE(GLeglContext ctx,
                                                     GLuint sampler,
                                                     GLenum pname,
                                                     GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSamplerParameterIuiv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR
          "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuiv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterIuivOESContextANGLE(GLeglContext ctx,
                                                        GLuint sampler,
                                                        GLenum pname,
                                                        GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSamplerParameterIuivOES",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR
          "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIuivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
}

void GL_APIENTRY GetSamplerParameterfvContextANGLE(GLeglContext ctx,
                                                   GLuint sampler,
                                                   GLenum pname,
                                                   GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSamplerParameterfv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameterfv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterfv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterfv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSamplerParameterivContextANGLE(GLeglContext ctx,
                                                   GLuint sampler,
                                                   GLenum pname,
                                                   GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSamplerParameteriv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSamplerParameteriv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameteriv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameteriv, isCallValid, context, samplerPacked, pname, params);
    }
}

void GL_APIENTRY GetSemaphoreParameterui64vEXTContextANGLE(GLeglContext ctx,
                                                           GLuint semaphore,
                                                           GLenum pname,
                                                           GLuint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glGetSemaphoreParameterui64vEXT",
        "context = %d, GLuint semaphore = %u, GLenum pname = %s, GLuint64 *params = 0x%016" PRIxPTR
        "",
        CID(context), semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname),
        (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->getSemaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(GetSemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
}

void GL_APIENTRY GetShaderInfoLogContextANGLE(GLeglContext ctx,
                                              GLuint shader,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetShaderInfoLog",
          "context = %d, GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderInfoLog(context, shaderPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getShaderInfoLog(shaderPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetShaderInfoLog, isCallValid, context, shaderPacked, bufSize, length,
                      infoLog);
    }
}

void GL_APIENTRY GetShaderPrecisionFormatContextANGLE(GLeglContext ctx,
                                                      GLenum shadertype,
                                                      GLenum precisiontype,
                                                      GLint *range,
                                                      GLint *precision)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetShaderPrecisionFormat",
          "context = %d, GLenum shadertype = %s, GLenum precisiontype = %s, GLint *range = "
          "0x%016" PRIxPTR ", GLint *precision = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ShaderType, shadertype),
          GLenumToString(GLenumGroup::PrecisionType, precisiontype), (uintptr_t)range,
          (uintptr_t)precision);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetShaderPrecisionFormat(context, shadertype, precisiontype,
                                                             range, precision));
        if (isCallValid)
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
        ANGLE_CAPTURE(GetShaderPrecisionFormat, isCallValid, context, shadertype, precisiontype,
                      range, precision);
    }
}

void GL_APIENTRY GetShaderSourceContextANGLE(GLeglContext ctx,
                                             GLuint shader,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *source)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetShaderSource",
          "context = %d, GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderSource(context, shaderPacked, bufSize, length, source));
        if (isCallValid)
        {
            context->getShaderSource(shaderPacked, bufSize, length, source);
        }
        ANGLE_CAPTURE(GetShaderSource, isCallValid, context, shaderPacked, bufSize, length, source);
    }
}

void GL_APIENTRY GetShaderivContextANGLE(GLeglContext ctx,
                                         GLuint shader,
                                         GLenum pname,
                                         GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetShaderiv",
          "context = %d, GLuint shader = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), shader, GLenumToString(GLenumGroup::ShaderParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetShaderiv(context, shaderPacked, pname, params));
        if (isCallValid)
        {
            context->getShaderiv(shaderPacked, pname, params);
        }
        ANGLE_CAPTURE(GetShaderiv, isCallValid, context, shaderPacked, pname, params);
    }
}

const GLubyte *GL_APIENTRY GetStringContextANGLE(GLeglContext ctx, GLenum name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetString", "context = %d, GLenum name = %s", CID(context),
          GLenumToString(GLenumGroup::StringName, name));

    const GLubyte *returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetString(context, name));
        if (isCallValid)
        {
            returnValue = context->getString(name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetString, const GLubyte *>();
        }
        ANGLE_CAPTURE(GetString, isCallValid, context, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetString, const GLubyte *>();
    }
    return returnValue;
}

const GLubyte *GL_APIENTRY GetStringiContextANGLE(GLeglContext ctx, GLenum name, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetStringi", "context = %d, GLenum name = %s, GLuint index = %u", CID(context),
          GLenumToString(GLenumGroup::StringName, name), index);

    const GLubyte *returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetStringi(context, name, index));
        if (isCallValid)
        {
            returnValue = context->getStringi(name, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
        }
        ANGLE_CAPTURE(GetStringi, isCallValid, context, name, index, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
    }
    return returnValue;
}

void GL_APIENTRY GetSyncivContextANGLE(GLeglContext ctx,
                                       GLsync sync,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLint *values)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetSynciv",
          "context = %d, GLsync sync = 0x%016" PRIxPTR
          ", GLenum pname = %s, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLint *values = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)sync, GLenumToString(GLenumGroup::SyncParameterName, pname),
          bufSize, (uintptr_t)length, (uintptr_t)values);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetSynciv(context, sync, pname, bufSize, length, values));
        if (isCallValid)
        {
            context->getSynciv(sync, pname, bufSize, length, values);
        }
        ANGLE_CAPTURE(GetSynciv, isCallValid, context, sync, pname, bufSize, length, values);
    }
}

void GL_APIENTRY GetTexEnvfvContextANGLE(GLeglContext ctx,
                                         GLenum target,
                                         GLenum pname,
                                         GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexEnvfv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexEnvfv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
}

void GL_APIENTRY GetTexEnvivContextANGLE(GLeglContext ctx,
                                         GLenum target,
                                         GLenum pname,
                                         GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexEnviv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexEnviv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
}

void GL_APIENTRY GetTexEnvxvContextANGLE(GLeglContext ctx,
                                         GLenum target,
                                         GLenum pname,
                                         GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexEnvxv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexEnvxv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
}

void GL_APIENTRY GetTexGenfvOESContextANGLE(GLeglContext ctx,
                                            GLenum coord,
                                            GLenum pname,
                                            GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexGenfvOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenfvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY GetTexGenivOESContextANGLE(GLeglContext ctx,
                                            GLenum coord,
                                            GLenum pname,
                                            GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexGenivOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenivOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY GetTexGenxvOESContextANGLE(GLeglContext ctx,
                                            GLenum coord,
                                            GLenum pname,
                                            GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexGenxvOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenxvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY GetTexLevelParameterfvContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLint level,
                                                    GLenum pname,
                                                    GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexLevelParameterfv",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum pname = %s, GLfloat *params "
          "= 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterfv(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterfv, isCallValid, context, targetPacked, level, pname,
                      params);
    }
}

void GL_APIENTRY GetTexLevelParameterivContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLint level,
                                                    GLenum pname,
                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexLevelParameteriv",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum pname = %s, GLint *params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameteriv(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameteriv, isCallValid, context, targetPacked, level, pname,
                      params);
    }
}

void GL_APIENTRY GetTexParameterIivContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLenum pname,
                                                GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameterIiv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterIivOESContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameterIivOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterIuivContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum pname,
                                                 GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameterIuiv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterIuivOESContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum pname,
                                                    GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameterIuivOES",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterfvContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameterfv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterfv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterivContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameteriv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameteriv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTexParameterxvContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTexParameterxv",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLfixed *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTexParameterxv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY GetTransformFeedbackVaryingContextANGLE(GLeglContext ctx,
                                                         GLuint program,
                                                         GLuint index,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLsizei *size,
                                                         GLenum *type,
                                                         GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTransformFeedbackVarying",
          "context = %d, GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLsizei *size = 0x%016" PRIxPTR
          ", GLenum *type = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTransformFeedbackVarying(context, programPacked, index,
                                                                bufSize, length, size, type, name));
        if (isCallValid)
        {
            context->getTransformFeedbackVarying(programPacked, index, bufSize, length, size, type,
                                                 name);
        }
        ANGLE_CAPTURE(GetTransformFeedbackVarying, isCallValid, context, programPacked, index,
                      bufSize, length, size, type, name);
    }
}

void GL_APIENTRY GetTranslatedShaderSourceANGLEContextANGLE(GLeglContext ctx,
                                                            GLuint shader,
                                                            GLsizei bufsize,
                                                            GLsizei *length,
                                                            GLchar *source)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetTranslatedShaderSourceANGLE",
          "context = %d, GLuint shader = %u, GLsizei bufsize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR "",
          CID(context), shader, bufsize, (uintptr_t)length, (uintptr_t)source);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTranslatedShaderSourceANGLE(
                                              context, shaderPacked, bufsize, length, source));
        if (isCallValid)
        {
            context->getTranslatedShaderSource(shaderPacked, bufsize, length, source);
        }
        ANGLE_CAPTURE(GetTranslatedShaderSourceANGLE, isCallValid, context, shaderPacked, bufsize,
                      length, source);
    }
}

GLuint GL_APIENTRY GetUniformBlockIndexContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    const GLchar *uniformBlockName)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUniformBlockIndex",
          "context = %d, GLuint program = %u, const GLchar *uniformBlockName = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)uniformBlockName);

    GLuint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformBlockIndex(context, programPacked, uniformBlockName));
        if (isCallValid)
        {
            returnValue = context->getUniformBlockIndex(programPacked, uniformBlockName);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetUniformBlockIndex, GLuint>();
        }
        ANGLE_CAPTURE(GetUniformBlockIndex, isCallValid, context, programPacked, uniformBlockName,
                      returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetUniformBlockIndex, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GetUniformIndicesContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLsizei uniformCount,
                                               const GLchar *const *uniformNames,
                                               GLuint *uniformIndices)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUniformIndices",
          "context = %d, GLuint program = %u, GLsizei uniformCount = %d, const GLchar "
          "*const*uniformNames = 0x%016" PRIxPTR ", GLuint *uniformIndices = 0x%016" PRIxPTR "",
          CID(context), program, uniformCount, (uintptr_t)uniformNames, (uintptr_t)uniformIndices);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformIndices(context, programPacked, uniformCount,
                                                      uniformNames, uniformIndices));
        if (isCallValid)
        {
            context->getUniformIndices(programPacked, uniformCount, uniformNames, uniformIndices);
        }
        ANGLE_CAPTURE(GetUniformIndices, isCallValid, context, programPacked, uniformCount,
                      uniformNames, uniformIndices);
    }
}

GLint GL_APIENTRY GetUniformLocationContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUniformLocation",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUniformLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getUniformLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
        }
        ANGLE_CAPTURE(GetUniformLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetUniformfvContextANGLE(GLeglContext ctx,
                                          GLuint program,
                                          GLint location,
                                          GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUniformfv",
          "context = %d, GLuint program = %u, GLint location = %d, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), program, location, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformfv(context, programPacked, location, params));
        if (isCallValid)
        {
            context->getUniformfv(programPacked, location, params);
        }
        ANGLE_CAPTURE(GetUniformfv, isCallValid, context, programPacked, location, params);
    }
}

void GL_APIENTRY GetUniformivContextANGLE(GLeglContext ctx,
                                          GLuint program,
                                          GLint location,
                                          GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUniformiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLint *params = 0x%016" PRIxPTR
          "",
          CID(context), program, location, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformiv(context, programPacked, location, params));
        if (isCallValid)
        {
            context->getUniformiv(programPacked, location, params);
        }
        ANGLE_CAPTURE(GetUniformiv, isCallValid, context, programPacked, location, params);
    }
}

void GL_APIENTRY GetUniformuivContextANGLE(GLeglContext ctx,
                                           GLuint program,
                                           GLint location,
                                           GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUniformuiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLuint *params = 0x%016" PRIxPTR
          "",
          CID(context), program, location, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformuiv(context, programPacked, location, params));
        if (isCallValid)
        {
            context->getUniformuiv(programPacked, location, params);
        }
        ANGLE_CAPTURE(GetUniformuiv, isCallValid, context, programPacked, location, params);
    }
}

void GL_APIENTRY GetUnsignedBytevEXTContextANGLE(GLeglContext ctx, GLenum pname, GLubyte *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUnsignedBytevEXT",
          "context = %d, GLenum pname = %s, GLubyte *data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUnsignedBytevEXT(context, pname, data));
        if (isCallValid)
        {
            context->getUnsignedBytev(pname, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytevEXT, isCallValid, context, pname, data);
    }
}

void GL_APIENTRY GetUnsignedBytei_vEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLuint index,
                                                   GLubyte *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetUnsignedBytei_vEXT",
          "context = %d, GLenum target = %s, GLuint index = %u, GLubyte *data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUnsignedBytei_vEXT(context, target, index, data));
        if (isCallValid)
        {
            context->getUnsignedBytei_v(target, index, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytei_vEXT, isCallValid, context, target, index, data);
    }
}

void GL_APIENTRY GetVertexAttribIivContextANGLE(GLeglContext ctx,
                                                GLuint index,
                                                GLenum pname,
                                                GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetVertexAttribIiv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribEnum, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetVertexAttribIiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribIiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIiv, isCallValid, context, index, pname, params);
    }
}

void GL_APIENTRY GetVertexAttribIuivContextANGLE(GLeglContext ctx,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetVertexAttribIuiv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribEnum, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetVertexAttribIuiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribIuiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIuiv, isCallValid, context, index, pname, params);
    }
}

void GL_APIENTRY GetVertexAttribPointervContextANGLE(GLeglContext ctx,
                                                     GLuint index,
                                                     GLenum pname,
                                                     void **pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetVertexAttribPointerv",
          "context = %d, GLuint index = %u, GLenum pname = %s, void **pointer = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname),
          (uintptr_t)pointer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetVertexAttribPointerv(context, index, pname, pointer));
        if (isCallValid)
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
        ANGLE_CAPTURE(GetVertexAttribPointerv, isCallValid, context, index, pname, pointer);
    }
}

void GL_APIENTRY GetVertexAttribfvContextANGLE(GLeglContext ctx,
                                               GLuint index,
                                               GLenum pname,
                                               GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetVertexAttribfv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribfv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribfv, isCallValid, context, index, pname, params);
    }
}

void GL_APIENTRY GetVertexAttribivContextANGLE(GLeglContext ctx,
                                               GLuint index,
                                               GLenum pname,
                                               GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetVertexAttribiv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribiv, isCallValid, context, index, pname, params);
    }
}

void GL_APIENTRY GetnUniformfvContextANGLE(GLeglContext ctx,
                                           GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetnUniformfv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformfvEXTContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetnUniformfvEXT",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfvEXT(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfvEXT, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformivContextANGLE(GLeglContext ctx,
                                           GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetnUniformiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformiv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformiv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformivEXTContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetnUniformivEXT",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformivEXT(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformivEXT, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformuivContextANGLE(GLeglContext ctx,
                                            GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glGetnUniformuiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLuint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformuiv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformuiv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformuiv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY HintContextANGLE(GLeglContext ctx, GLenum target, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glHint", "context = %d, GLenum target = %s, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::HintTarget, target),
          GLenumToString(GLenumGroup::HintMode, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateHint(context, target, mode));
        if (isCallValid)
        {
            context->hint(target, mode);
        }
        ANGLE_CAPTURE(Hint, isCallValid, context, target, mode);
    }
}

void GL_APIENTRY ImportMemoryFdEXTContextANGLE(GLeglContext ctx,
                                               GLuint memory,
                                               GLuint64 size,
                                               GLenum handleType,
                                               GLint fd)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glImportMemoryFdEXT",
          "context = %d, GLuint memory = %u, GLuint64 size = %llu, GLenum handleType = %s, GLint "
          "fd = %d",
          CID(context), memory, static_cast<unsigned long long>(size),
          GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        HandleType handleTypePacked                   = FromGL<HandleType>(handleType);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportMemoryFdEXT(context, memoryPacked, size, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importMemoryFd(memoryPacked, size, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportMemoryFdEXT, isCallValid, context, memoryPacked, size, handleTypePacked,
                      fd);
    }
}

void GL_APIENTRY ImportSemaphoreFdEXTContextANGLE(GLeglContext ctx,
                                                  GLuint semaphore,
                                                  GLenum handleType,
                                                  GLint fd)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glImportSemaphoreFdEXT",
          "context = %d, GLuint semaphore = %u, GLenum handleType = %s, GLint fd = %d",
          CID(context), semaphore, GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        HandleType handleTypePacked                   = FromGL<HandleType>(handleType);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportSemaphoreFdEXT(context, semaphorePacked, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importSemaphoreFd(semaphorePacked, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportSemaphoreFdEXT, isCallValid, context, semaphorePacked, handleTypePacked,
                      fd);
    }
}

void GL_APIENTRY InsertEventMarkerEXTContextANGLE(GLeglContext ctx,
                                                  GLsizei length,
                                                  const GLchar *marker)
{
    Context *context = static_cast<gl::Context *>(ctx);
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("glInsertEventMarkerEXT", "context = %d, GLsizei length = %d, const GLchar *marker =
    // 0x%016" PRIxPTR "", CID(context), length, (uintptr_t)marker);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->insertEventMarker(length, marker);
        }
        ANGLE_CAPTURE(InsertEventMarkerEXT, isCallValid, context, length, marker);
    }
}

void GL_APIENTRY InvalidateFramebufferContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLsizei numAttachments,
                                                   const GLenum *attachments)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glInvalidateFramebuffer",
          "context = %d, GLenum target = %s, GLsizei numAttachments = %d, const GLenum "
          "*attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), numAttachments,
          (uintptr_t)attachments);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateInvalidateFramebuffer(context, target, numAttachments, attachments));
        if (isCallValid)
        {
            context->invalidateFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE(InvalidateFramebuffer, isCallValid, context, target, numAttachments,
                      attachments);
    }
}

void GL_APIENTRY InvalidateSubFramebufferContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLsizei numAttachments,
                                                      const GLenum *attachments,
                                                      GLint x,
                                                      GLint y,
                                                      GLsizei width,
                                                      GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glInvalidateSubFramebuffer",
          "context = %d, GLenum target = %s, GLsizei numAttachments = %d, const GLenum "
          "*attachments = 0x%016" PRIxPTR
          ", GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), numAttachments,
          (uintptr_t)attachments, x, y, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateInvalidateSubFramebuffer(context, target, numAttachments,
                                                             attachments, x, y, width, height));
        if (isCallValid)
        {
            context->invalidateSubFramebuffer(target, numAttachments, attachments, x, y, width,
                                              height);
        }
        ANGLE_CAPTURE(InvalidateSubFramebuffer, isCallValid, context, target, numAttachments,
                      attachments, x, y, width, height);
    }
}

GLboolean GL_APIENTRY IsBufferContextANGLE(GLeglContext ctx, GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsBuffer", "context = %d, GLuint buffer = %u", CID(context), buffer);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsBuffer(context, bufferPacked));
        if (isCallValid)
        {
            returnValue = context->isBuffer(bufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsBuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsBuffer, isCallValid, context, bufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsBuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsEnabledContextANGLE(GLeglContext ctx, GLenum cap)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsEnabled", "context = %d, GLenum cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsEnabled(context, cap));
        if (isCallValid)
        {
            returnValue = context->isEnabled(cap);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsEnabled, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnabled, isCallValid, context, cap, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsEnabled, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsEnablediContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsEnabledi", "context = %d, GLenum target = %s, GLuint index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnabledi(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnabledi, isCallValid, context, target, index, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsFenceNV", "context = %d, GLuint fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->isFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(IsFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsFramebufferContextANGLE(GLeglContext ctx, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsFramebuffer", "context = %d, GLuint framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebuffer(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebuffer, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsFramebufferOESContextANGLE(GLeglContext ctx, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsFramebufferOES", "context = %d, GLuint framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebufferOES(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsFramebufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebufferOES, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsFramebufferOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsMemoryObjectEXTContextANGLE(GLeglContext ctx, GLuint memoryObject)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsMemoryObjectEXT", "context = %d, GLuint memoryObject = %u", CID(context),
          memoryObject);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryObjectPacked             = FromGL<MemoryObjectID>(memoryObject);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsMemoryObjectEXT(context, memoryObjectPacked));
        if (isCallValid)
        {
            returnValue = context->isMemoryObject(memoryObjectPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsMemoryObjectEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsMemoryObjectEXT, isCallValid, context, memoryObjectPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsMemoryObjectEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsProgram", "context = %d, GLuint program = %u", CID(context), program);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsProgram(context, programPacked));
        if (isCallValid)
        {
            returnValue = context->isProgram(programPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgram, isCallValid, context, programPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsProgramPipeline", "context = %d, GLuint pipeline = %u", CID(context), pipeline);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked              = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsProgramPipeline, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgramPipeline, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsProgramPipeline, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsQueryContextANGLE(GLeglContext ctx, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsQuery", "context = %d, GLuint id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsQuery(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsQuery, GLboolean>();
        }
        ANGLE_CAPTURE(IsQuery, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsQuery, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsQueryEXTContextANGLE(GLeglContext ctx, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsQueryEXT", "context = %d, GLuint id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsQueryEXT(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsQueryEXT, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsRenderbufferContextANGLE(GLeglContext ctx, GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsRenderbuffer", "context = %d, GLuint renderbuffer = %u", CID(context), renderbuffer);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbuffer(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbuffer, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsRenderbufferOESContextANGLE(GLeglContext ctx, GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsRenderbufferOES", "context = %d, GLuint renderbuffer = %u", CID(context),
          renderbuffer);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbufferOES(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbufferOES, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbufferOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsSemaphoreEXTContextANGLE(GLeglContext ctx, GLuint semaphore)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsSemaphoreEXT", "context = %d, GLuint semaphore = %u", CID(context), semaphore);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsSemaphoreEXT(context, semaphorePacked));
        if (isCallValid)
        {
            returnValue = context->isSemaphore(semaphorePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsSemaphoreEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsSemaphoreEXT, isCallValid, context, semaphorePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsSemaphoreEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsSamplerContextANGLE(GLeglContext ctx, GLuint sampler)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsSampler", "context = %d, GLuint sampler = %u", CID(context), sampler);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsSampler(context, samplerPacked));
        if (isCallValid)
        {
            returnValue = context->isSampler(samplerPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
        }
        ANGLE_CAPTURE(IsSampler, isCallValid, context, samplerPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsShader", "context = %d, GLuint shader = %u", CID(context), shader);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsShader(context, shaderPacked));
        if (isCallValid)
        {
            returnValue = context->isShader(shaderPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
        }
        ANGLE_CAPTURE(IsShader, isCallValid, context, shaderPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsSyncContextANGLE(GLeglContext ctx, GLsync sync)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsSync", "context = %d, GLsync sync = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)sync);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsSync(context, sync));
        if (isCallValid)
        {
            returnValue = context->isSync(sync);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsSync, GLboolean>();
        }
        ANGLE_CAPTURE(IsSync, isCallValid, context, sync, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsSync, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsTextureContextANGLE(GLeglContext ctx, GLuint texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsTexture", "context = %d, GLuint texture = %u", CID(context), texture);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsTexture(context, texturePacked));
        if (isCallValid)
        {
            returnValue = context->isTexture(texturePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsTexture, GLboolean>();
        }
        ANGLE_CAPTURE(IsTexture, isCallValid, context, texturePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsTexture, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsTransformFeedbackContextANGLE(GLeglContext ctx, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsTransformFeedback", "context = %d, GLuint id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TransformFeedbackID idPacked                  = FromGL<TransformFeedbackID>(id);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsTransformFeedback(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isTransformFeedback(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsTransformFeedback, GLboolean>();
        }
        ANGLE_CAPTURE(IsTransformFeedback, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsTransformFeedback, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsVertexArrayContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsVertexArray", "context = %d, GLuint array = %u", CID(context), array);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                     = FromGL<VertexArrayID>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArray(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArray, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsVertexArrayOESContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glIsVertexArrayOES", "context = %d, GLuint array = %u", CID(context), array);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                     = FromGL<VertexArrayID>(array);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArrayOES, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY LightModelfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLightModelf", "context = %d, GLenum pname = %s, GLfloat param = %f", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelf(context, pname, param));
        if (isCallValid)
        {
            context->lightModelf(pname, param);
        }
        ANGLE_CAPTURE(LightModelf, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY LightModelfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLightModelfv",
          "context = %d, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelfv(context, pname, params));
        if (isCallValid)
        {
            context->lightModelfv(pname, params);
        }
        ANGLE_CAPTURE(LightModelfv, isCallValid, context, pname, params);
    }
}

void GL_APIENTRY LightModelxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLightModelx", "context = %d, GLenum pname = %s, GLfixed param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelx(context, pname, param));
        if (isCallValid)
        {
            context->lightModelx(pname, param);
        }
        ANGLE_CAPTURE(LightModelx, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY LightModelxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLightModelxv",
          "context = %d, GLenum pname = %s, const GLfixed *param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelxv(context, pname, param));
        if (isCallValid)
        {
            context->lightModelxv(pname, param);
        }
        ANGLE_CAPTURE(LightModelxv, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY LightfContextANGLE(GLeglContext ctx, GLenum light, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLightf", "context = %d, GLenum light = %s, GLenum pname = %s, GLfloat param = %f",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                    = FromGL<LightParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightf(context, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightf(light, pnamePacked, param);
        }
        ANGLE_CAPTURE(Lightf, isCallValid, context, light, pnamePacked, param);
    }
}

void GL_APIENTRY LightfvContextANGLE(GLeglContext ctx,
                                     GLenum light,
                                     GLenum pname,
                                     const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glLightfv",
        "context = %d, GLenum light = %s, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::LightName, light),
        GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                    = FromGL<LightParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightfv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(Lightfv, isCallValid, context, light, pnamePacked, params);
    }
}

void GL_APIENTRY LightxContextANGLE(GLeglContext ctx, GLenum light, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLightx", "context = %d, GLenum light = %s, GLenum pname = %s, GLfixed param = 0x%X",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                    = FromGL<LightParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightx(context, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightx(light, pnamePacked, param);
        }
        ANGLE_CAPTURE(Lightx, isCallValid, context, light, pnamePacked, param);
    }
}

void GL_APIENTRY LightxvContextANGLE(GLeglContext ctx,
                                     GLenum light,
                                     GLenum pname,
                                     const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glLightxv",
        "context = %d, GLenum light = %s, GLenum pname = %s, const GLfixed *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::LightName, light),
        GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                    = FromGL<LightParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightxv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(Lightxv, isCallValid, context, light, pnamePacked, params);
    }
}

void GL_APIENTRY LineWidthContextANGLE(GLeglContext ctx, GLfloat width)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLineWidth", "context = %d, GLfloat width = %f", CID(context), width);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLineWidth(context, width));
        if (isCallValid)
        {
            context->lineWidth(width);
        }
        ANGLE_CAPTURE(LineWidth, isCallValid, context, width);
    }
}

void GL_APIENTRY LineWidthxContextANGLE(GLeglContext ctx, GLfixed width)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLineWidthx", "context = %d, GLfixed width = 0x%X", CID(context), width);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLineWidthx(context, width));
        if (isCallValid)
        {
            context->lineWidthx(width);
        }
        ANGLE_CAPTURE(LineWidthx, isCallValid, context, width);
    }
}

void GL_APIENTRY LinkProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLinkProgram", "context = %d, GLuint program = %u", CID(context), program);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLinkProgram(context, programPacked));
        if (isCallValid)
        {
            context->linkProgram(programPacked);
        }
        ANGLE_CAPTURE(LinkProgram, isCallValid, context, programPacked);
    }
}

void GL_APIENTRY LoadIdentityContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLoadIdentity", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadIdentity(context));
        if (isCallValid)
        {
            context->loadIdentity();
        }
        ANGLE_CAPTURE(LoadIdentity, isCallValid, context);
    }
}

void GL_APIENTRY LoadMatrixfContextANGLE(GLeglContext ctx, const GLfloat *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLoadMatrixf", "context = %d, const GLfloat *m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadMatrixf(context, m));
        if (isCallValid)
        {
            context->loadMatrixf(m);
        }
        ANGLE_CAPTURE(LoadMatrixf, isCallValid, context, m);
    }
}

void GL_APIENTRY LoadMatrixxContextANGLE(GLeglContext ctx, const GLfixed *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLoadMatrixx", "context = %d, const GLfixed *m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadMatrixx(context, m));
        if (isCallValid)
        {
            context->loadMatrixx(m);
        }
        ANGLE_CAPTURE(LoadMatrixx, isCallValid, context, m);
    }
}

void GL_APIENTRY LoadPaletteFromModelViewMatrixOESContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLoadPaletteFromModelViewMatrixOES", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context));
        if (isCallValid)
        {
            context->loadPaletteFromModelViewMatrix();
        }
        ANGLE_CAPTURE(LoadPaletteFromModelViewMatrixOES, isCallValid, context);
    }
}

void GL_APIENTRY LogicOpContextANGLE(GLeglContext ctx, GLenum opcode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glLogicOp", "context = %d, GLenum opcode = %s", CID(context),
          GLenumToString(GLenumGroup::LogicOp, opcode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LogicalOperation opcodePacked                 = FromGL<LogicalOperation>(opcode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLogicOp(context, opcodePacked));
        if (isCallValid)
        {
            context->logicOp(opcodePacked);
        }
        ANGLE_CAPTURE(LogicOp, isCallValid, context, opcodePacked);
    }
}

void *GL_APIENTRY MapBufferOESContextANGLE(GLeglContext ctx, GLenum target, GLenum access)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMapBufferOES", "context = %d, GLenum target = %s, GLenum access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::BufferAccessARB, access));

    void *returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access));
        if (isCallValid)
        {
            returnValue = context->mapBuffer(targetPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
        }
        ANGLE_CAPTURE(MapBufferOES, isCallValid, context, targetPacked, access, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
    }
    return returnValue;
}

void *GL_APIENTRY MapBufferRangeContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLintptr offset,
                                             GLsizeiptr length,
                                             GLbitfield access)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMapBufferRange",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr length = %llu, "
          "GLbitfield access = %s",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateMapBufferRange(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
        }
        ANGLE_CAPTURE(MapBufferRange, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
    }
    return returnValue;
}

void *GL_APIENTRY MapBufferRangeEXTContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLintptr offset,
                                                GLsizeiptr length,
                                                GLbitfield access)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMapBufferRangeEXT",
          "context = %d, GLenum target = %s, GLintptr offset = %llu, GLsizeiptr length = %llu, "
          "GLbitfield access = %s",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                    = FromGL<BufferBinding>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
        }
        ANGLE_CAPTURE(MapBufferRangeEXT, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
    }
    return returnValue;
}

void GL_APIENTRY MaterialfContextANGLE(GLeglContext ctx, GLenum face, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMaterialf", "context = %d, GLenum face = %s, GLenum pname = %s, GLfloat param = %f",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                 = FromGL<MaterialParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialf(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialf(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialf, isCallValid, context, face, pnamePacked, param);
    }
}

void GL_APIENTRY MaterialfvContextANGLE(GLeglContext ctx,
                                        GLenum face,
                                        GLenum pname,
                                        const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glMaterialfv",
        "context = %d, GLenum face = %s, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
        GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                 = FromGL<MaterialParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialfv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->materialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(Materialfv, isCallValid, context, face, pnamePacked, params);
    }
}

void GL_APIENTRY MaterialxContextANGLE(GLeglContext ctx, GLenum face, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMaterialx", "context = %d, GLenum face = %s, GLenum pname = %s, GLfixed param = 0x%X",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                 = FromGL<MaterialParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialx(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialx(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialx, isCallValid, context, face, pnamePacked, param);
    }
}

void GL_APIENTRY MaterialxvContextANGLE(GLeglContext ctx,
                                        GLenum face,
                                        GLenum pname,
                                        const GLfixed *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMaterialxv",
          "context = %d, GLenum face = %s, GLenum pname = %s, const GLfixed *param = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                 = FromGL<MaterialParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialxv(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialxv(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialxv, isCallValid, context, face, pnamePacked, param);
    }
}

void GL_APIENTRY MatrixIndexPointerOESContextANGLE(GLeglContext ctx,
                                                   GLint size,
                                                   GLenum type,
                                                   GLsizei stride,
                                                   const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMatrixIndexPointerOES",
          "context = %d, GLint size = %d, GLenum type = %s, GLsizei stride = %d, const void "
          "*pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::DefaultGroup, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer));
        if (isCallValid)
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE(MatrixIndexPointerOES, isCallValid, context, size, type, stride, pointer);
    }
}

void GL_APIENTRY MatrixModeContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMatrixMode", "context = %d, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::MatrixMode, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MatrixType modePacked                         = FromGL<MatrixType>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMatrixMode(context, modePacked));
        if (isCallValid)
        {
            context->matrixMode(modePacked);
        }
        ANGLE_CAPTURE(MatrixMode, isCallValid, context, modePacked);
    }
}

void GL_APIENTRY MaxShaderCompilerThreadsKHRContextANGLE(GLeglContext ctx, GLuint count)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMaxShaderCompilerThreadsKHR", "context = %d, GLuint count = %u", CID(context), count);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaxShaderCompilerThreadsKHR(context, count));
        if (isCallValid)
        {
            context->maxShaderCompilerThreads(count);
        }
        ANGLE_CAPTURE(MaxShaderCompilerThreadsKHR, isCallValid, context, count);
    }
}

void GL_APIENTRY MemoryBarrierContextANGLE(GLeglContext ctx, GLbitfield barriers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMemoryBarrier", "context = %d, GLbitfield barriers = %s", CID(context),
          GLbitfieldToString(GLenumGroup::MemoryBarrierMask, barriers).c_str());

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMemoryBarrier(context, barriers));
        if (isCallValid)
        {
            context->memoryBarrier(barriers);
        }
        ANGLE_CAPTURE(MemoryBarrier, isCallValid, context, barriers);
    }
}

void GL_APIENTRY MemoryBarrierByRegionContextANGLE(GLeglContext ctx, GLbitfield barriers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMemoryBarrierByRegion", "context = %d, GLbitfield barriers = %s", CID(context),
          GLbitfieldToString(GLenumGroup::MemoryBarrierMask, barriers).c_str());

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMemoryBarrierByRegion(context, barriers));
        if (isCallValid)
        {
            context->memoryBarrierByRegion(barriers);
        }
        ANGLE_CAPTURE(MemoryBarrierByRegion, isCallValid, context, barriers);
    }
}

void GL_APIENTRY MemoryObjectParameterivEXTContextANGLE(GLeglContext ctx,
                                                        GLuint memoryObject,
                                                        GLenum pname,
                                                        const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMemoryObjectParameterivEXT",
          "context = %d, GLuint memoryObject = %u, GLenum pname = %s, const GLint *params = "
          "0x%016" PRIxPTR "",
          CID(context), memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryObjectPacked             = FromGL<MemoryObjectID>(memoryObject);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->memoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(MemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked, pname,
                      params);
    }
}

void GL_APIENTRY MinSampleShadingContextANGLE(GLeglContext ctx, GLfloat value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMinSampleShading", "context = %d, GLfloat value = %f", CID(context), value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMinSampleShading(context, value));
        if (isCallValid)
        {
            context->minSampleShading(value);
        }
        ANGLE_CAPTURE(MinSampleShading, isCallValid, context, value);
    }
}

void GL_APIENTRY MultMatrixfContextANGLE(GLeglContext ctx, const GLfloat *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMultMatrixf", "context = %d, const GLfloat *m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultMatrixf(context, m));
        if (isCallValid)
        {
            context->multMatrixf(m);
        }
        ANGLE_CAPTURE(MultMatrixf, isCallValid, context, m);
    }
}

void GL_APIENTRY MultMatrixxContextANGLE(GLeglContext ctx, const GLfixed *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMultMatrixx", "context = %d, const GLfixed *m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultMatrixx(context, m));
        if (isCallValid)
        {
            context->multMatrixx(m);
        }
        ANGLE_CAPTURE(MultMatrixx, isCallValid, context, m);
    }
}

void GL_APIENTRY MultiDrawElementsBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                            GLenum mode,
                                                            const GLsizei *count,
                                                            GLenum type,
                                                            const void *const *indices,
                                                            GLsizei primcount,
                                                            const GLint *basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMultiDrawElementsBaseVertexEXT",
          "context = %d, GLenum mode = %s, const GLsizei *count = 0x%016" PRIxPTR
          ", GLenum type = %s, const void *const*indices = 0x%016" PRIxPTR
          ", GLsizei primcount = %d, const GLint *basevertex = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount,
          (uintptr_t)basevertex);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                      = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                   = FromGL<DrawElementsType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultiDrawElementsBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, primcount, basevertex));
        if (isCallValid)
        {
            context->multiDrawElementsBaseVertex(modePacked, count, typePacked, indices, primcount,
                                                 basevertex);
        }
        ANGLE_CAPTURE(MultiDrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount, basevertex);
    }
}

void GL_APIENTRY MultiTexCoord4fContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLfloat s,
                                             GLfloat t,
                                             GLfloat r,
                                             GLfloat q)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMultiTexCoord4f",
          "context = %d, GLenum target = %s, GLfloat s = %f, GLfloat t = %f, GLfloat r = %f, "
          "GLfloat q = %f",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMultiTexCoord4f(context, target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
        ANGLE_CAPTURE(MultiTexCoord4f, isCallValid, context, target, s, t, r, q);
    }
}

void GL_APIENTRY MultiTexCoord4xContextANGLE(GLeglContext ctx,
                                             GLenum texture,
                                             GLfixed s,
                                             GLfixed t,
                                             GLfixed r,
                                             GLfixed q)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glMultiTexCoord4x",
          "context = %d, GLenum texture = %s, GLfixed s = 0x%X, GLfixed t = 0x%X, GLfixed r = "
          "0x%X, GLfixed q = 0x%X",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, texture), s, t, r, q);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMultiTexCoord4x(context, texture, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
        ANGLE_CAPTURE(MultiTexCoord4x, isCallValid, context, texture, s, t, r, q);
    }
}

void GL_APIENTRY Normal3fContextANGLE(GLeglContext ctx, GLfloat nx, GLfloat ny, GLfloat nz)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glNormal3f", "context = %d, GLfloat nx = %f, GLfloat ny = %f, GLfloat nz = %f",
          CID(context), nx, ny, nz);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3f(nx, ny, nz);
        }
        ANGLE_CAPTURE(Normal3f, isCallValid, context, nx, ny, nz);
    }
}

void GL_APIENTRY Normal3xContextANGLE(GLeglContext ctx, GLfixed nx, GLfixed ny, GLfixed nz)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glNormal3x", "context = %d, GLfixed nx = 0x%X, GLfixed ny = 0x%X, GLfixed nz = 0x%X",
          CID(context), nx, ny, nz);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormal3x(context, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3x(nx, ny, nz);
        }
        ANGLE_CAPTURE(Normal3x, isCallValid, context, nx, ny, nz);
    }
}

void GL_APIENTRY NormalPointerContextANGLE(GLeglContext ctx,
                                           GLenum type,
                                           GLsizei stride,
                                           const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glNormalPointer",
        "context = %d, GLenum type = %s, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::NormalPointerType, type), stride,
        (uintptr_t)pointer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked                   = FromGL<VertexAttribType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNormalPointer(context, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->normalPointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(NormalPointer, isCallValid, context, typePacked, stride, pointer);
    }
}

void GL_APIENTRY ObjectLabelContextANGLE(GLeglContext ctx,
                                         GLenum identifier,
                                         GLuint name,
                                         GLsizei length,
                                         const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glObjectLabel",
          "context = %d, GLenum identifier = %s, GLuint name = %u, GLsizei length = %d, const "
          "GLchar *label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateObjectLabel(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabel, isCallValid, context, identifier, name, length, label);
    }
}

void GL_APIENTRY ObjectLabelKHRContextANGLE(GLeglContext ctx,
                                            GLenum identifier,
                                            GLuint name,
                                            GLsizei length,
                                            const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glObjectLabelKHR",
          "context = %d, GLenum identifier = %s, GLuint name = %u, GLsizei length = %d, const "
          "GLchar *label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateObjectLabelKHR(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabelKHR, isCallValid, context, identifier, name, length, label);
    }
}

void GL_APIENTRY ObjectPtrLabelContextANGLE(GLeglContext ctx,
                                            const void *ptr,
                                            GLsizei length,
                                            const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glObjectPtrLabel",
          "context = %d, const void *ptr = 0x%016" PRIxPTR
          ", GLsizei length = %d, const GLchar *label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabel(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabel, isCallValid, context, ptr, length, label);
    }
}

void GL_APIENTRY ObjectPtrLabelKHRContextANGLE(GLeglContext ctx,
                                               const void *ptr,
                                               GLsizei length,
                                               const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glObjectPtrLabelKHR",
          "context = %d, const void *ptr = 0x%016" PRIxPTR
          ", GLsizei length = %d, const GLchar *label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabelKHR, isCallValid, context, ptr, length, label);
    }
}

void GL_APIENTRY OrthofContextANGLE(GLeglContext ctx,
                                    GLfloat l,
                                    GLfloat r,
                                    GLfloat b,
                                    GLfloat t,
                                    GLfloat n,
                                    GLfloat f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glOrthof",
          "context = %d, GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n "
          "= %f, GLfloat f = %f",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateOrthof(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->orthof(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Orthof, isCallValid, context, l, r, b, t, n, f);
    }
}

void GL_APIENTRY OrthoxContextANGLE(GLeglContext ctx,
                                    GLfixed l,
                                    GLfixed r,
                                    GLfixed b,
                                    GLfixed t,
                                    GLfixed n,
                                    GLfixed f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glOrthox",
          "context = %d, GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, "
          "GLfixed n = 0x%X, GLfixed f = 0x%X",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateOrthox(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->orthox(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Orthox, isCallValid, context, l, r, b, t, n, f);
    }
}

void GL_APIENTRY PatchParameteriContextANGLE(GLeglContext ctx, GLenum pname, GLint value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPatchParameteri", "context = %d, GLenum pname = %s, GLint value = %d", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameteri(context, pname, value));
        if (isCallValid)
        {
            context->patchParameteri(pname, value);
        }
        ANGLE_CAPTURE(PatchParameteri, isCallValid, context, pname, value);
    }
}

void GL_APIENTRY PauseTransformFeedbackContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPauseTransformFeedback", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePauseTransformFeedback(context));
        if (isCallValid)
        {
            context->pauseTransformFeedback();
        }
        ANGLE_CAPTURE(PauseTransformFeedback, isCallValid, context);
    }
}

void GL_APIENTRY PixelStoreiContextANGLE(GLeglContext ctx, GLenum pname, GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPixelStorei", "context = %d, GLenum pname = %s, GLint param = %d", CID(context),
          GLenumToString(GLenumGroup::PixelStoreParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePixelStorei(context, pname, param));
        if (isCallValid)
        {
            context->pixelStorei(pname, param);
        }
        ANGLE_CAPTURE(PixelStorei, isCallValid, context, pname, param);
    }
}

void GL_APIENTRY PointParameterfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPointParameterf", "context = %d, GLenum pname = %s, GLfloat param = %f", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                    = FromGL<PointParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterf(context, pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterf(pnamePacked, param);
        }
        ANGLE_CAPTURE(PointParameterf, isCallValid, context, pnamePacked, param);
    }
}

void GL_APIENTRY PointParameterfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPointParameterfv",
          "context = %d, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                    = FromGL<PointParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterfv(context, pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterfv(pnamePacked, params);
        }
        ANGLE_CAPTURE(PointParameterfv, isCallValid, context, pnamePacked, params);
    }
}

void GL_APIENTRY PointParameterxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPointParameterx", "context = %d, GLenum pname = %s, GLfixed param = 0x%X",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                    = FromGL<PointParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterx(context, pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterx(pnamePacked, param);
        }
        ANGLE_CAPTURE(PointParameterx, isCallValid, context, pnamePacked, param);
    }
}

void GL_APIENTRY PointParameterxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPointParameterxv",
          "context = %d, GLenum pname = %s, const GLfixed *params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                    = FromGL<PointParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterxv(context, pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterxv(pnamePacked, params);
        }
        ANGLE_CAPTURE(PointParameterxv, isCallValid, context, pnamePacked, params);
    }
}

void GL_APIENTRY PointSizeContextANGLE(GLeglContext ctx, GLfloat size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPointSize", "context = %d, GLfloat size = %f", CID(context), size);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePointSize(context, size));
        if (isCallValid)
        {
            context->pointSize(size);
        }
        ANGLE_CAPTURE(PointSize, isCallValid, context, size);
    }
}

void GL_APIENTRY PointSizePointerOESContextANGLE(GLeglContext ctx,
                                                 GLenum type,
                                                 GLsizei stride,
                                                 const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glPointSizePointerOES",
        "context = %d, GLenum type = %s, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::DefaultGroup, type), stride, (uintptr_t)pointer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked                   = FromGL<VertexAttribType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePointSizePointerOES(context, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->pointSizePointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(PointSizePointerOES, isCallValid, context, typePacked, stride, pointer);
    }
}

void GL_APIENTRY PointSizexContextANGLE(GLeglContext ctx, GLfixed size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPointSizex", "context = %d, GLfixed size = 0x%X", CID(context), size);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePointSizex(context, size));
        if (isCallValid)
        {
            context->pointSizex(size);
        }
        ANGLE_CAPTURE(PointSizex, isCallValid, context, size);
    }
}

void GL_APIENTRY PolygonOffsetContextANGLE(GLeglContext ctx, GLfloat factor, GLfloat units)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPolygonOffset", "context = %d, GLfloat factor = %f, GLfloat units = %f", CID(context),
          factor, units);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePolygonOffset(context, factor, units));
        if (isCallValid)
        {
            context->polygonOffset(factor, units);
        }
        ANGLE_CAPTURE(PolygonOffset, isCallValid, context, factor, units);
    }
}

void GL_APIENTRY PolygonOffsetxContextANGLE(GLeglContext ctx, GLfixed factor, GLfixed units)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPolygonOffsetx", "context = %d, GLfixed factor = 0x%X, GLfixed units = 0x%X",
          CID(context), factor, units);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePolygonOffsetx(context, factor, units));
        if (isCallValid)
        {
            context->polygonOffsetx(factor, units);
        }
        ANGLE_CAPTURE(PolygonOffsetx, isCallValid, context, factor, units);
    }
}

void GL_APIENTRY PopDebugGroupContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPopDebugGroup", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopDebugGroup(context));
        if (isCallValid)
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE(PopDebugGroup, isCallValid, context);
    }
}

void GL_APIENTRY PopDebugGroupKHRContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPopDebugGroupKHR", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopDebugGroupKHR(context));
        if (isCallValid)
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE(PopDebugGroupKHR, isCallValid, context);
    }
}

void GL_APIENTRY PopGroupMarkerEXTContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("glPopGroupMarkerEXT", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopGroupMarkerEXT(context));
        if (isCallValid)
        {
            context->popGroupMarker();
        }
        ANGLE_CAPTURE(PopGroupMarkerEXT, isCallValid, context);
    }
}

void GL_APIENTRY PopMatrixContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPopMatrix", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopMatrix(context));
        if (isCallValid)
        {
            context->popMatrix();
        }
        ANGLE_CAPTURE(PopMatrix, isCallValid, context);
    }
}

void GL_APIENTRY PrimitiveBoundingBoxContextANGLE(GLeglContext ctx,
                                                  GLfloat minX,
                                                  GLfloat minY,
                                                  GLfloat minZ,
                                                  GLfloat minW,
                                                  GLfloat maxX,
                                                  GLfloat maxY,
                                                  GLfloat maxZ,
                                                  GLfloat maxW)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPrimitiveBoundingBox",
          "context = %d, GLfloat minX = %f, GLfloat minY = %f, GLfloat minZ = %f, GLfloat minW = "
          "%f, GLfloat maxX = %f, GLfloat maxY = %f, GLfloat maxZ = %f, GLfloat maxW = %f",
          CID(context), minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePrimitiveBoundingBox(context, minX, minY, minZ, minW, maxX, maxY, maxZ, maxW));
        if (isCallValid)
        {
            context->primitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
        }
        ANGLE_CAPTURE(PrimitiveBoundingBox, isCallValid, context, minX, minY, minZ, minW, maxX,
                      maxY, maxZ, maxW);
    }
}

void GL_APIENTRY ProgramBinaryContextANGLE(GLeglContext ctx,
                                           GLuint program,
                                           GLenum binaryFormat,
                                           const void *binary,
                                           GLsizei length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramBinary",
          "context = %d, GLuint program = %u, GLenum binaryFormat = %s, const void *binary = "
          "0x%016" PRIxPTR ", GLsizei length = %d",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, binaryFormat),
          (uintptr_t)binary, length);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramBinary(context, programPacked, binaryFormat, binary, length));
        if (isCallValid)
        {
            context->programBinary(programPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE(ProgramBinary, isCallValid, context, programPacked, binaryFormat, binary,
                      length);
    }
}

void GL_APIENTRY ProgramBinaryOESContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLenum binaryFormat,
                                              const void *binary,
                                              GLint length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramBinaryOES",
          "context = %d, GLuint program = %u, GLenum binaryFormat = %s, const void *binary = "
          "0x%016" PRIxPTR ", GLint length = %d",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, binaryFormat),
          (uintptr_t)binary, length);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramBinaryOES(context, programPacked, binaryFormat, binary, length));
        if (isCallValid)
        {
            context->programBinary(programPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE(ProgramBinaryOES, isCallValid, context, programPacked, binaryFormat, binary,
                      length);
    }
}

void GL_APIENTRY ProgramParameteriContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLenum pname,
                                               GLint value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramParameteri",
          "context = %d, GLuint program = %u, GLenum pname = %s, GLint value = %d", CID(context),
          program, GLenumToString(GLenumGroup::ProgramParameterPName, pname), value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramParameteri(context, programPacked, pname, value));
        if (isCallValid)
        {
            context->programParameteri(programPacked, pname, value);
        }
        ANGLE_CAPTURE(ProgramParameteri, isCallValid, context, programPacked, pname, value);
    }
}

void GL_APIENTRY ProgramUniform1fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform1f",
          "context = %d, GLuint program = %u, GLint location = %d, GLfloat v0 = %f", CID(context),
          program, location, v0);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform1f(context, programPacked, location, v0));
        if (isCallValid)
        {
            context->programUniform1f(programPacked, location, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1f, isCallValid, context, programPacked, location, v0);
    }
}

void GL_APIENTRY ProgramUniform1fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform1fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1fv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform1fv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1fv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform1iContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLint v0)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform1i",
          "context = %d, GLuint program = %u, GLint location = %d, GLint v0 = %d", CID(context),
          program, location, v0);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform1i(context, programPacked, location, v0));
        if (isCallValid)
        {
            context->programUniform1i(programPacked, location, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1i, isCallValid, context, programPacked, location, v0);
    }
}

void GL_APIENTRY ProgramUniform1ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform1iv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint "
          "*value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1iv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform1iv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1iv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform1uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform1ui",
          "context = %d, GLuint program = %u, GLint location = %d, GLuint v0 = %u", CID(context),
          program, location, v0);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform1ui(context, programPacked, location, v0));
        if (isCallValid)
        {
            context->programUniform1ui(programPacked, location, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1ui, isCallValid, context, programPacked, location, v0);
    }
}

void GL_APIENTRY ProgramUniform1uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform1uiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1uiv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform1uiv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1uiv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform2fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0,
                                              GLfloat v1)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glProgramUniform2f",
        "context = %d, GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f",
        CID(context), program, location, v0, v1);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform2f(context, programPacked, location, v0, v1));
        if (isCallValid)
        {
            context->programUniform2f(programPacked, location, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2f, isCallValid, context, programPacked, location, v0, v1);
    }
}

void GL_APIENTRY ProgramUniform2fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform2fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2fv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform2fv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2fv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY
ProgramUniform2iContextANGLE(GLeglContext ctx, GLuint program, GLint location, GLint v0, GLint v1)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform2i",
          "context = %d, GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d",
          CID(context), program, location, v0, v1);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform2i(context, programPacked, location, v0, v1));
        if (isCallValid)
        {
            context->programUniform2i(programPacked, location, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2i, isCallValid, context, programPacked, location, v0, v1);
    }
}

void GL_APIENTRY ProgramUniform2ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform2iv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint "
          "*value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2iv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform2iv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2iv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform2uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0,
                                               GLuint v1)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform2ui",
          "context = %d, GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u",
          CID(context), program, location, v0, v1);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform2ui(context, programPacked, location, v0, v1));
        if (isCallValid)
        {
            context->programUniform2ui(programPacked, location, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2ui, isCallValid, context, programPacked, location, v0, v1);
    }
}

void GL_APIENTRY ProgramUniform2uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform2uiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2uiv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform2uiv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2uiv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform3fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0,
                                              GLfloat v1,
                                              GLfloat v2)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform3f",
          "context = %d, GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = "
          "%f, GLfloat v2 = %f",
          CID(context), program, location, v0, v1, v2);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform3f(context, programPacked, location, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3f(programPacked, location, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3f, isCallValid, context, programPacked, location, v0, v1, v2);
    }
}

void GL_APIENTRY ProgramUniform3fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform3fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3fv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform3fv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3fv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform3iContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLint v0,
                                              GLint v1,
                                              GLint v2)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform3i",
          "context = %d, GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d, "
          "GLint v2 = %d",
          CID(context), program, location, v0, v1, v2);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniform3i(context, programPacked, location, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3i(programPacked, location, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3i, isCallValid, context, programPacked, location, v0, v1, v2);
    }
}

void GL_APIENTRY ProgramUniform3ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform3iv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint "
          "*value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3iv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform3iv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3iv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform3uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0,
                                               GLuint v1,
                                               GLuint v2)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform3ui",
          "context = %d, GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, "
          "GLuint v2 = %u",
          CID(context), program, location, v0, v1, v2);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3ui(context, programPacked, location, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3ui(programPacked, location, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3ui, isCallValid, context, programPacked, location, v0, v1, v2);
    }
}

void GL_APIENTRY ProgramUniform3uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform3uiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3uiv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform3uiv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3uiv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform4fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0,
                                              GLfloat v1,
                                              GLfloat v2,
                                              GLfloat v3)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform4f",
          "context = %d, GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = "
          "%f, GLfloat v2 = %f, GLfloat v3 = %f",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4f(context, programPacked, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4f(programPacked, location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4f, isCallValid, context, programPacked, location, v0, v1, v2,
                      v3);
    }
}

void GL_APIENTRY ProgramUniform4fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform4fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4fv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform4fv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4fv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform4iContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLint v0,
                                              GLint v1,
                                              GLint v2,
                                              GLint v3)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform4i",
          "context = %d, GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d, "
          "GLint v2 = %d, GLint v3 = %d",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4i(context, programPacked, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4i(programPacked, location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4i, isCallValid, context, programPacked, location, v0, v1, v2,
                      v3);
    }
}

void GL_APIENTRY ProgramUniform4ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform4iv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint "
          "*value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4iv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform4iv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4iv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniform4uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0,
                                               GLuint v1,
                                               GLuint v2,
                                               GLuint v3)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform4ui",
          "context = %d, GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, "
          "GLuint v2 = %u, GLuint v3 = %u",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4ui(context, programPacked, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4ui(programPacked, location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4ui, isCallValid, context, programPacked, location, v0, v1, v2,
                      v3);
    }
}

void GL_APIENTRY ProgramUniform4uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniform4uiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4uiv(context, programPacked, location, count, value));
        if (isCallValid)
        {
            context->programUniform4uiv(programPacked, location, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4uiv, isCallValid, context, programPacked, location, count,
                      value);
    }
}

void GL_APIENTRY ProgramUniformMatrix2fvContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei count,
                                                     GLboolean transpose,
                                                     const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix2fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2fv(context, programPacked, location, count,
                                                            transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2fv, isCallValid, context, programPacked, location, count,
                      transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix2x3fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix2x3fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x3fv(context, programPacked, location,
                                                              count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x3fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x3fv, isCallValid, context, programPacked, location,
                      count, transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix2x4fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix2x4fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x4fv(context, programPacked, location,
                                                              count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x4fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x4fv, isCallValid, context, programPacked, location,
                      count, transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix3fvContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei count,
                                                     GLboolean transpose,
                                                     const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix3fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3fv(context, programPacked, location, count,
                                                            transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3fv, isCallValid, context, programPacked, location, count,
                      transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix3x2fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix3x2fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x2fv(context, programPacked, location,
                                                              count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x2fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x2fv, isCallValid, context, programPacked, location,
                      count, transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix3x4fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix3x4fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x4fv(context, programPacked, location,
                                                              count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x4fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x4fv, isCallValid, context, programPacked, location,
                      count, transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix4fvContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei count,
                                                     GLboolean transpose,
                                                     const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix4fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4fv(context, programPacked, location, count,
                                                            transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4fv, isCallValid, context, programPacked, location, count,
                      transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix4x2fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix4x2fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x2fv(context, programPacked, location,
                                                              count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x2fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x2fv, isCallValid, context, programPacked, location,
                      count, transpose, value);
    }
}

void GL_APIENTRY ProgramUniformMatrix4x3fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glProgramUniformMatrix4x3fv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean "
          "transpose = %s, const GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x3fv(context, programPacked, location,
                                                              count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x3fv(programPacked, location, count, transpose, value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x3fv, isCallValid, context, programPacked, location,
                      count, transpose, value);
    }
}

void GL_APIENTRY PushDebugGroupContextANGLE(GLeglContext ctx,
                                            GLenum source,
                                            GLuint id,
                                            GLsizei length,
                                            const GLchar *message)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPushDebugGroup",
          "context = %d, GLenum source = %s, GLuint id = %u, GLsizei length = %d, const GLchar "
          "*message = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source), id, length,
          (uintptr_t)message);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePushDebugGroup(context, source, id, length, message));
        if (isCallValid)
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE(PushDebugGroup, isCallValid, context, source, id, length, message);
    }
}

void GL_APIENTRY PushDebugGroupKHRContextANGLE(GLeglContext ctx,
                                               GLenum source,
                                               GLuint id,
                                               GLsizei length,
                                               const GLchar *message)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPushDebugGroupKHR",
          "context = %d, GLenum source = %s, GLuint id = %u, GLsizei length = %d, const GLchar "
          "*message = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source), id, length,
          (uintptr_t)message);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidatePushDebugGroupKHR(context, source, id, length, message));
        if (isCallValid)
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE(PushDebugGroupKHR, isCallValid, context, source, id, length, message);
    }
}

void GL_APIENTRY PushGroupMarkerEXTContextANGLE(GLeglContext ctx,
                                                GLsizei length,
                                                const GLchar *marker)
{
    Context *context = static_cast<gl::Context *>(ctx);
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("glPushGroupMarkerEXT", "context = %d, GLsizei length = %d, const GLchar *marker =
    // 0x%016" PRIxPTR "", CID(context), length, (uintptr_t)marker);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePushGroupMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->pushGroupMarker(length, marker);
        }
        ANGLE_CAPTURE(PushGroupMarkerEXT, isCallValid, context, length, marker);
    }
}

void GL_APIENTRY PushMatrixContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glPushMatrix", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePushMatrix(context));
        if (isCallValid)
        {
            context->pushMatrix();
        }
        ANGLE_CAPTURE(PushMatrix, isCallValid, context);
    }
}

void GL_APIENTRY QueryCounterEXTContextANGLE(GLeglContext ctx, GLuint id, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glQueryCounterEXT", "context = %d, GLuint id = %u, GLenum target = %s", CID(context), id,
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                              = FromGL<QueryID>(id);
        QueryType targetPacked                        = FromGL<QueryType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryCounterEXT(context, idPacked, targetPacked));
        if (isCallValid)
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE(QueryCounterEXT, isCallValid, context, idPacked, targetPacked);
    }
}

GLbitfield GL_APIENTRY QueryMatrixxOESContextANGLE(GLeglContext ctx,
                                                   GLfixed *mantissa,
                                                   GLint *exponent)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glQueryMatrixxOES",
          "context = %d, GLfixed *mantissa = 0x%016" PRIxPTR ", GLint *exponent = 0x%016" PRIxPTR
          "",
          CID(context), (uintptr_t)mantissa, (uintptr_t)exponent);

    GLbitfield returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryMatrixxOES(context, mantissa, exponent));
        if (isCallValid)
        {
            returnValue = context->queryMatrixx(mantissa, exponent);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
        }
        ANGLE_CAPTURE(QueryMatrixxOES, isCallValid, context, mantissa, exponent, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
    }
    return returnValue;
}

void GL_APIENTRY ReadBufferContextANGLE(GLeglContext ctx, GLenum src)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glReadBuffer", "context = %d, GLenum src = %s", CID(context),
          GLenumToString(GLenumGroup::ReadBufferMode, src));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateReadBuffer(context, src));
        if (isCallValid)
        {
            context->readBuffer(src);
        }
        ANGLE_CAPTURE(ReadBuffer, isCallValid, context, src);
    }
}

void GL_APIENTRY ReadPixelsContextANGLE(GLeglContext ctx,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height,
                                        GLenum format,
                                        GLenum type,
                                        void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glReadPixels",
          "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, "
          "GLenum format = %s, GLenum type = %s, void *pixels = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateReadPixels(context, x, y, width, height, format, type, pixels));
        if (isCallValid)
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
        ANGLE_CAPTURE(ReadPixels, isCallValid, context, x, y, width, height, format, type, pixels);
    }
}

void GL_APIENTRY ReadnPixelsContextANGLE(GLeglContext ctx,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glReadnPixels",
          "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, "
          "GLenum format = %s, GLenum type = %s, GLsizei bufSize = %d, void *data = 0x%016" PRIxPTR
          "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixels(context, x, y, width, height, format, type, bufSize, data));
        if (isCallValid)
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE(ReadnPixels, isCallValid, context, x, y, width, height, format, type, bufSize,
                      data);
    }
}

void GL_APIENTRY ReadnPixelsEXTContextANGLE(GLeglContext ctx,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glReadnPixelsEXT",
          "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, "
          "GLenum format = %s, GLenum type = %s, GLsizei bufSize = %d, void *data = 0x%016" PRIxPTR
          "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)data);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixelsEXT(context, x, y, width, height, format, type, bufSize, data));
        if (isCallValid)
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE(ReadnPixelsEXT, isCallValid, context, x, y, width, height, format, type,
                      bufSize, data);
    }
}

void GL_APIENTRY ReleaseShaderCompilerContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glReleaseShaderCompiler", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateReleaseShaderCompiler(context));
        if (isCallValid)
        {
            context->releaseShaderCompiler();
        }
        ANGLE_CAPTURE(ReleaseShaderCompiler, isCallValid, context);
    }
}

void GL_APIENTRY RenderbufferStorageContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glRenderbufferStorage",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLsizei width = %d, "
          "GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRenderbufferStorage(context, target, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorage, isCallValid, context, target, internalformat, width,
                      height);
    }
}

void GL_APIENTRY RenderbufferStorageMultisampleContextANGLE(GLeglContext ctx,
                                                            GLenum target,
                                                            GLsizei samples,
                                                            GLenum internalformat,
                                                            GLsizei width,
                                                            GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glRenderbufferStorageMultisample",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisample(context, target, samples,
                                                                   internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisample, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
}

void GL_APIENTRY RenderbufferStorageMultisampleANGLEContextANGLE(GLeglContext ctx,
                                                                 GLenum target,
                                                                 GLsizei samples,
                                                                 GLenum internalformat,
                                                                 GLsizei width,
                                                                 GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glRenderbufferStorageMultisampleANGLE",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisampleANGLE(
                                context, target, samples, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisampleANGLE, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
}

void GL_APIENTRY RenderbufferStorageMultisampleEXTContextANGLE(GLeglContext ctx,
                                                               GLenum target,
                                                               GLsizei samples,
                                                               GLenum internalformat,
                                                               GLsizei width,
                                                               GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glRenderbufferStorageMultisampleEXT",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisampleEXT(
                                context, target, samples, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisampleEXT, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
}

void GL_APIENTRY RenderbufferStorageOESContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum internalformat,
                                                    GLsizei width,
                                                    GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glRenderbufferStorageOES",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLsizei width = %d, "
          "GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRenderbufferStorageOES(context, target, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageOES, isCallValid, context, target, internalformat, width,
                      height);
    }
}

void GL_APIENTRY ResumeTransformFeedbackContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glResumeTransformFeedback", "context = %d", CID(context));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateResumeTransformFeedback(context));
        if (isCallValid)
        {
            context->resumeTransformFeedback();
        }
        ANGLE_CAPTURE(ResumeTransformFeedback, isCallValid, context);
    }
}

void GL_APIENTRY
RotatefContextANGLE(GLeglContext ctx, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glRotatef",
          "context = %d, GLfloat angle = %f, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f",
          CID(context), angle, x, y, z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateRotatef(context, angle, x, y, z));
        if (isCallValid)
        {
            context->rotatef(angle, x, y, z);
        }
        ANGLE_CAPTURE(Rotatef, isCallValid, context, angle, x, y, z);
    }
}

void GL_APIENTRY
RotatexContextANGLE(GLeglContext ctx, GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glRotatex",
        "context = %d, GLfixed angle = 0x%X, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X",
        CID(context), angle, x, y, z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateRotatex(context, angle, x, y, z));
        if (isCallValid)
        {
            context->rotatex(angle, x, y, z);
        }
        ANGLE_CAPTURE(Rotatex, isCallValid, context, angle, x, y, z);
    }
}

void GL_APIENTRY SampleCoverageContextANGLE(GLeglContext ctx, GLfloat value, GLboolean invert)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSampleCoverage", "context = %d, GLfloat value = %f, GLboolean invert = %s",
          CID(context), value, GLbooleanToString(invert));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSampleCoverage(context, value, invert));
        if (isCallValid)
        {
            context->sampleCoverage(value, invert);
        }
        ANGLE_CAPTURE(SampleCoverage, isCallValid, context, value, invert);
    }
}

void GL_APIENTRY SampleCoveragexContextANGLE(GLeglContext ctx, GLclampx value, GLboolean invert)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSampleCoveragex", "context = %d, GLclampx value = 0x%X, GLboolean invert = %s",
          CID(context), value, GLbooleanToString(invert));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSampleCoveragex(context, value, invert));
        if (isCallValid)
        {
            context->sampleCoveragex(value, invert);
        }
        ANGLE_CAPTURE(SampleCoveragex, isCallValid, context, value, invert);
    }
}

void GL_APIENTRY SampleMaskiContextANGLE(GLeglContext ctx, GLuint maskNumber, GLbitfield mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSampleMaski", "context = %d, GLuint maskNumber = %u, GLbitfield mask = %s",
          CID(context), maskNumber, GLbitfieldToString(GLenumGroup::DefaultGroup, mask).c_str());

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSampleMaski(context, maskNumber, mask));
        if (isCallValid)
        {
            context->sampleMaski(maskNumber, mask);
        }
        ANGLE_CAPTURE(SampleMaski, isCallValid, context, maskNumber, mask);
    }
}

void GL_APIENTRY SamplerParameterIivContextANGLE(GLeglContext ctx,
                                                 GLuint sampler,
                                                 GLenum pname,
                                                 const GLint *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glSamplerParameterIiv",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterIiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIiv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterIivOESContextANGLE(GLeglContext ctx,
                                                    GLuint sampler,
                                                    GLenum pname,
                                                    const GLint *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glSamplerParameterIivOES",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterIivOES(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIivOES, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterIuivContextANGLE(GLeglContext ctx,
                                                  GLuint sampler,
                                                  GLenum pname,
                                                  const GLuint *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glSamplerParameterIuiv",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLuint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterIuiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuiv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterIuivOESContextANGLE(GLeglContext ctx,
                                                     GLuint sampler,
                                                     GLenum pname,
                                                     const GLuint *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glSamplerParameterIuivOES",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLuint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterIuivOES(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuivOES, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterfContextANGLE(GLeglContext ctx,
                                               GLuint sampler,
                                               GLenum pname,
                                               GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSamplerParameterf",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLfloat param = %f", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterf(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterf(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterf, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterfvContextANGLE(GLeglContext ctx,
                                                GLuint sampler,
                                                GLenum pname,
                                                const GLfloat *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSamplerParameterfv",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLfloat *param = "
          "0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
          (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameterfv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterfv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterfv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameteriContextANGLE(GLeglContext ctx,
                                               GLuint sampler,
                                               GLenum pname,
                                               GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSamplerParameteri",
          "context = %d, GLuint sampler = %u, GLenum pname = %s, GLint param = %d", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameteri(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameteri(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameteri, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY SamplerParameterivContextANGLE(GLeglContext ctx,
                                                GLuint sampler,
                                                GLenum pname,
                                                const GLint *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glSamplerParameteriv",
        "context = %d, GLuint sampler = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                       = FromGL<SamplerID>(sampler);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateSamplerParameteriv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameteriv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameteriv, isCallValid, context, samplerPacked, pname, param);
    }
}

void GL_APIENTRY ScalefContextANGLE(GLeglContext ctx, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glScalef", "context = %d, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f", CID(context),
          x, y, z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateScalef(context, x, y, z));
        if (isCallValid)
        {
            context->scalef(x, y, z);
        }
        ANGLE_CAPTURE(Scalef, isCallValid, context, x, y, z);
    }
}

void GL_APIENTRY ScalexContextANGLE(GLeglContext ctx, GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glScalex", "context = %d, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X",
          CID(context), x, y, z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateScalex(context, x, y, z));
        if (isCallValid)
        {
            context->scalex(x, y, z);
        }
        ANGLE_CAPTURE(Scalex, isCallValid, context, x, y, z);
    }
}

void GL_APIENTRY
ScissorContextANGLE(GLeglContext ctx, GLint x, GLint y, GLsizei width, GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glScissor",
          "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d",
          CID(context), x, y, width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateScissor(context, x, y, width, height));
        if (isCallValid)
        {
            context->scissor(x, y, width, height);
        }
        ANGLE_CAPTURE(Scissor, isCallValid, context, x, y, width, height);
    }
}

void GL_APIENTRY SemaphoreParameterui64vEXTContextANGLE(GLeglContext ctx,
                                                        GLuint semaphore,
                                                        GLenum pname,
                                                        const GLuint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSemaphoreParameterui64vEXT",
          "context = %d, GLuint semaphore = %u, GLenum pname = %s, const GLuint64 *params = "
          "0x%016" PRIxPTR "",
          CID(context), semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->semaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(SemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
}

void GL_APIENTRY SetFenceNVContextANGLE(GLeglContext ctx, GLuint fence, GLenum condition)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSetFenceNV", "context = %d, GLuint fence = %u, GLenum condition = %s", CID(context),
          fence, GLenumToString(GLenumGroup::DefaultGroup, condition));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSetFenceNV(context, fencePacked, condition));
        if (isCallValid)
        {
            context->setFenceNV(fencePacked, condition);
        }
        ANGLE_CAPTURE(SetFenceNV, isCallValid, context, fencePacked, condition);
    }
}

void GL_APIENTRY ShadeModelContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glShadeModel", "context = %d, GLenum mode = %s", CID(context),
          GLenumToString(GLenumGroup::ShadingModel, mode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShadingModel modePacked                       = FromGL<ShadingModel>(mode);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateShadeModel(context, modePacked));
        if (isCallValid)
        {
            context->shadeModel(modePacked);
        }
        ANGLE_CAPTURE(ShadeModel, isCallValid, context, modePacked);
    }
}

void GL_APIENTRY ShaderBinaryContextANGLE(GLeglContext ctx,
                                          GLsizei count,
                                          const GLuint *shaders,
                                          GLenum binaryformat,
                                          const void *binary,
                                          GLsizei length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glShaderBinary",
          "context = %d, GLsizei count = %d, const GLuint *shaders = 0x%016" PRIxPTR
          ", GLenum binaryformat = %s, const void *binary = 0x%016" PRIxPTR ", GLsizei length = %d",
          CID(context), count, (uintptr_t)shaders,
          GLenumToString(GLenumGroup::DefaultGroup, binaryformat), (uintptr_t)binary, length);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        const ShaderProgramID *shadersPacked          = FromGL<const ShaderProgramID *>(shaders);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateShaderBinary(context, count, shadersPacked, binaryformat, binary, length));
        if (isCallValid)
        {
            context->shaderBinary(count, shadersPacked, binaryformat, binary, length);
        }
        ANGLE_CAPTURE(ShaderBinary, isCallValid, context, count, shadersPacked, binaryformat,
                      binary, length);
    }
}

void GL_APIENTRY ShaderSourceContextANGLE(GLeglContext ctx,
                                          GLuint shader,
                                          GLsizei count,
                                          const GLchar *const *string,
                                          const GLint *length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glShaderSource",
          "context = %d, GLuint shader = %u, GLsizei count = %d, const GLchar *const*string = "
          "0x%016" PRIxPTR ", const GLint *length = 0x%016" PRIxPTR "",
          CID(context), shader, count, (uintptr_t)string, (uintptr_t)length);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateShaderSource(context, shaderPacked, count, string, length));
        if (isCallValid)
        {
            context->shaderSource(shaderPacked, count, string, length);
        }
        ANGLE_CAPTURE(ShaderSource, isCallValid, context, shaderPacked, count, string, length);
    }
}

void GL_APIENTRY SignalSemaphoreEXTContextANGLE(GLeglContext ctx,
                                                GLuint semaphore,
                                                GLuint numBufferBarriers,
                                                const GLuint *buffers,
                                                GLuint numTextureBarriers,
                                                const GLuint *textures,
                                                const GLenum *dstLayouts)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glSignalSemaphoreEXT",
          "context = %d, GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint "
          "*buffers = 0x%016" PRIxPTR
          ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
          ", const GLenum *dstLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)dstLayouts);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                   = FromGL<SemaphoreID>(semaphore);
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        const TextureID *texturesPacked               = FromGL<const TextureID *>(textures);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSignalSemaphoreEXT(context, semaphorePacked, numBufferBarriers, buffersPacked,
                                        numTextureBarriers, texturesPacked, dstLayouts));
        if (isCallValid)
        {
            context->signalSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                     numTextureBarriers, texturesPacked, dstLayouts);
        }
        ANGLE_CAPTURE(SignalSemaphoreEXT, isCallValid, context, semaphorePacked, numBufferBarriers,
                      buffersPacked, numTextureBarriers, texturesPacked, dstLayouts);
    }
}

void GL_APIENTRY StencilFuncContextANGLE(GLeglContext ctx, GLenum func, GLint ref, GLuint mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glStencilFunc", "context = %d, GLenum func = %s, GLint ref = %d, GLuint mask = %u",
          CID(context), GLenumToString(GLenumGroup::StencilFunction, func), ref, mask);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilFunc(context, func, ref, mask));
        if (isCallValid)
        {
            context->stencilFunc(func, ref, mask);
        }
        ANGLE_CAPTURE(StencilFunc, isCallValid, context, func, ref, mask);
    }
}

void GL_APIENTRY
StencilFuncSeparateContextANGLE(GLeglContext ctx, GLenum face, GLenum func, GLint ref, GLuint mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glStencilFuncSeparate",
          "context = %d, GLenum face = %s, GLenum func = %s, GLint ref = %d, GLuint mask = %u",
          CID(context), GLenumToString(GLenumGroup::StencilFaceDirection, face),
          GLenumToString(GLenumGroup::StencilFunction, func), ref, mask);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilFuncSeparate(context, face, func, ref, mask));
        if (isCallValid)
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
        ANGLE_CAPTURE(StencilFuncSeparate, isCallValid, context, face, func, ref, mask);
    }
}

void GL_APIENTRY StencilMaskContextANGLE(GLeglContext ctx, GLuint mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glStencilMask", "context = %d, GLuint mask = %u", CID(context), mask);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateStencilMask(context, mask));
        if (isCallValid)
        {
            context->stencilMask(mask);
        }
        ANGLE_CAPTURE(StencilMask, isCallValid, context, mask);
    }
}

void GL_APIENTRY StencilMaskSeparateContextANGLE(GLeglContext ctx, GLenum face, GLuint mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glStencilMaskSeparate", "context = %d, GLenum face = %s, GLuint mask = %u", CID(context),
          GLenumToString(GLenumGroup::StencilFaceDirection, face), mask);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask));
        if (isCallValid)
        {
            context->stencilMaskSeparate(face, mask);
        }
        ANGLE_CAPTURE(StencilMaskSeparate, isCallValid, context, face, mask);
    }
}

void GL_APIENTRY StencilOpContextANGLE(GLeglContext ctx, GLenum fail, GLenum zfail, GLenum zpass)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glStencilOp", "context = %d, GLenum fail = %s, GLenum zfail = %s, GLenum zpass = %s",
          CID(context), GLenumToString(GLenumGroup::StencilOp, fail),
          GLenumToString(GLenumGroup::StencilOp, zfail),
          GLenumToString(GLenumGroup::StencilOp, zpass));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilOp(context, fail, zfail, zpass));
        if (isCallValid)
        {
            context->stencilOp(fail, zfail, zpass);
        }
        ANGLE_CAPTURE(StencilOp, isCallValid, context, fail, zfail, zpass);
    }
}

void GL_APIENTRY StencilOpSeparateContextANGLE(GLeglContext ctx,
                                               GLenum face,
                                               GLenum sfail,
                                               GLenum dpfail,
                                               GLenum dppass)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glStencilOpSeparate",
        "context = %d, GLenum face = %s, GLenum sfail = %s, GLenum dpfail = %s, GLenum dppass = %s",
        CID(context), GLenumToString(GLenumGroup::StencilFaceDirection, face),
        GLenumToString(GLenumGroup::StencilOp, sfail),
        GLenumToString(GLenumGroup::StencilOp, dpfail),
        GLenumToString(GLenumGroup::StencilOp, dppass));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass));
        if (isCallValid)
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
        ANGLE_CAPTURE(StencilOpSeparate, isCallValid, context, face, sfail, dpfail, dppass);
    }
}

GLboolean GL_APIENTRY TestFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTestFenceNV", "context = %d, GLuint fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                         = FromGL<FenceNVID>(fence);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTestFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->testFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(TestFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY TexBufferContextANGLE(GLeglContext ctx,
                                       GLenum target,
                                       GLenum internalformat,
                                       GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexBuffer",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLuint buffer = %u",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexBuffer(context, target, internalformat, bufferPacked));
        if (isCallValid)
        {
            context->texBuffer(target, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE(TexBuffer, isCallValid, context, target, internalformat, bufferPacked);
    }
}

void GL_APIENTRY TexBufferRangeContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum internalformat,
                                            GLuint buffer,
                                            GLintptr offset,
                                            GLsizeiptr size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexBufferRange",
          "context = %d, GLenum target = %s, GLenum internalformat = %s, GLuint buffer = %u, "
          "GLintptr offset = %llu, GLsizeiptr size = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexBufferRange(context, target, internalformat, bufferPacked, offset, size));
        if (isCallValid)
        {
            context->texBufferRange(target, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(TexBufferRange, isCallValid, context, target, internalformat, bufferPacked,
                      offset, size);
    }
}

void GL_APIENTRY TexCoordPointerContextANGLE(GLeglContext ctx,
                                             GLint size,
                                             GLenum type,
                                             GLsizei stride,
                                             const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexCoordPointer",
          "context = %d, GLint size = %d, GLenum type = %s, GLsizei stride = %d, const void "
          "*pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::TexCoordPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked                   = FromGL<VertexAttribType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexCoordPointer(context, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(TexCoordPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
}

void GL_APIENTRY TexEnvfContextANGLE(GLeglContext ctx, GLenum target, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexEnvf", "context = %d, GLenum target = %s, GLenum pname = %s, GLfloat param = %f",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexEnvf(context, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE(TexEnvf, isCallValid, context, targetPacked, pnamePacked, param);
    }
}

void GL_APIENTRY TexEnvfvContextANGLE(GLeglContext ctx,
                                      GLenum target,
                                      GLenum pname,
                                      const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexEnvfv",
          "context = %d, GLenum target = %s, GLenum pname = %s, const GLfloat *params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexEnvfv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(TexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
}

void GL_APIENTRY TexEnviContextANGLE(GLeglContext ctx, GLenum target, GLenum pname, GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexEnvi", "context = %d, GLenum target = %s, GLenum pname = %s, GLint param = %d",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexEnvi(context, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE(TexEnvi, isCallValid, context, targetPacked, pnamePacked, param);
    }
}

void GL_APIENTRY TexEnvivContextANGLE(GLeglContext ctx,
                                      GLenum target,
                                      GLenum pname,
                                      const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexEnviv",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
        GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexEnviv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(TexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
}

void GL_APIENTRY TexEnvxContextANGLE(GLeglContext ctx, GLenum target, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexEnvx", "context = %d, GLenum target = %s, GLenum pname = %s, GLfixed param = 0x%X",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexEnvx(context, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvx(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE(TexEnvx, isCallValid, context, targetPacked, pnamePacked, param);
    }
}

void GL_APIENTRY TexEnvxvContextANGLE(GLeglContext ctx,
                                      GLenum target,
                                      GLenum pname,
                                      const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexEnvxv",
          "context = %d, GLenum target = %s, GLenum pname = %s, const GLfixed *params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked                 = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked               = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexEnvxv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(TexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
}

void GL_APIENTRY TexGenfOESContextANGLE(GLeglContext ctx, GLenum coord, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexGenfOES", "context = %d, GLenum coord = %s, GLenum pname = %s, GLfloat param = %f",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenfOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGenf(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGenfOES, isCallValid, context, coord, pname, param);
    }
}

void GL_APIENTRY TexGenfvOESContextANGLE(GLeglContext ctx,
                                         GLenum coord,
                                         GLenum pname,
                                         const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexGenfvOES",
        "context = %d, GLenum coord = %s, GLenum pname = %s, const GLfloat *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
        GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenfvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY TexGeniOESContextANGLE(GLeglContext ctx, GLenum coord, GLenum pname, GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexGeniOES", "context = %d, GLenum coord = %s, GLenum pname = %s, GLint param = %d",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGeniOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGeni(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGeniOES, isCallValid, context, coord, pname, param);
    }
}

void GL_APIENTRY TexGenivOESContextANGLE(GLeglContext ctx,
                                         GLenum coord,
                                         GLenum pname,
                                         const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexGenivOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenivOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY TexGenxOESContextANGLE(GLeglContext ctx, GLenum coord, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexGenxOES",
          "context = %d, GLenum coord = %s, GLenum pname = %s, GLfixed param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenxOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGenx(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGenxOES, isCallValid, context, coord, pname, param);
    }
}

void GL_APIENTRY TexGenxvOESContextANGLE(GLeglContext ctx,
                                         GLenum coord,
                                         GLenum pname,
                                         const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexGenxvOES",
        "context = %d, GLenum coord = %s, GLenum pname = %s, const GLfixed *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureCoordName, coord),
        GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenxvOES, isCallValid, context, coord, pname, params);
    }
}

void GL_APIENTRY TexImage2DContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLint level,
                                        GLint internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLint border,
                                        GLenum format,
                                        GLenum type,
                                        const void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexImage2D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint internalformat = %d, GLsizei "
          "width = %d, GLsizei height = %d, GLint border = %d, GLenum format = %s, GLenum type = "
          "%s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
          width, height, border, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexImage2D(context, targetPacked, level, internalformat, width,
                                               height, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage2D(targetPacked, level, internalformat, width, height, border, format,
                                type, pixels);
        }
        ANGLE_CAPTURE(TexImage2D, isCallValid, context, targetPacked, level, internalformat, width,
                      height, border, format, type, pixels);
    }
}

void GL_APIENTRY TexImage3DContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLint level,
                                        GLint internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLint border,
                                        GLenum format,
                                        GLenum type,
                                        const void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexImage3D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint internalformat = %d, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = "
          "%s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
          width, height, depth, border, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexImage3D(context, targetPacked, level, internalformat, width,
                                               height, depth, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
        ANGLE_CAPTURE(TexImage3D, isCallValid, context, targetPacked, level, internalformat, width,
                      height, depth, border, format, type, pixels);
    }
}

void GL_APIENTRY TexImage3DOESContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLenum format,
                                           GLenum type,
                                           const void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum internalformat = %s, GLsizei "
          "width = %d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = "
          "%s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage3DOES(context, targetPacked, level, internalformat, width, height,
                                   depth, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
        ANGLE_CAPTURE(TexImage3DOES, isCallValid, context, targetPacked, level, internalformat,
                      width, height, depth, border, format, type, pixels);
    }
}

void GL_APIENTRY TexParameterIivContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLenum pname,
                                             const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexParameterIiv",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameterIivOESContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLenum pname,
                                                const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexParameterIivOES",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameterIuivContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLenum pname,
                                              const GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexParameterIuiv",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLuint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameterIuivOESContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum pname,
                                                 const GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexParameterIuivOES",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLuint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameterfContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexParameterf",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLfloat param = %f", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterf(context, targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameterf(targetPacked, pname, param);
        }
        ANGLE_CAPTURE(TexParameterf, isCallValid, context, targetPacked, pname, param);
    }
}

void GL_APIENTRY TexParameterfvContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexParameterfv",
          "context = %d, GLenum target = %s, GLenum pname = %s, const GLfloat *params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterfv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameteriContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexParameteri",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLint param = %d", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameteri(context, targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameteri(targetPacked, pname, param);
        }
        ANGLE_CAPTURE(TexParameteri, isCallValid, context, targetPacked, pname, param);
    }
}

void GL_APIENTRY TexParameterivContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glTexParameteriv",
        "context = %d, GLenum target = %s, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
        GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameteriv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexParameterxContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexParameterx",
          "context = %d, GLenum target = %s, GLenum pname = %s, GLfixed param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), param);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterx(context, targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameterx(targetPacked, pname, param);
        }
        ANGLE_CAPTURE(TexParameterx, isCallValid, context, targetPacked, pname, param);
    }
}

void GL_APIENTRY TexParameterxvContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexParameterxv",
          "context = %d, GLenum target = %s, GLenum pname = %s, const GLfixed *params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexParameterxv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
}

void GL_APIENTRY TexStorage1DEXTContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLsizei levels,
                                             GLenum internalformat,
                                             GLsizei width)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage1DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage1DEXT(context, target, levels, internalformat, width));
        if (isCallValid)
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
        ANGLE_CAPTURE(TexStorage1DEXT, isCallValid, context, target, levels, internalformat, width);
    }
}

void GL_APIENTRY TexStorage2DContextANGLE(GLeglContext ctx,
                                          GLenum target,
                                          GLsizei levels,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage2D",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2D(context, targetPacked, levels, internalformat, width, height));
        if (isCallValid)
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE(TexStorage2D, isCallValid, context, targetPacked, levels, internalformat,
                      width, height);
    }
}

void GL_APIENTRY TexStorage2DEXTContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLsizei levels,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage2DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2DEXT(context, targetPacked, levels, internalformat, width, height));
        if (isCallValid)
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE(TexStorage2DEXT, isCallValid, context, targetPacked, levels, internalformat,
                      width, height);
    }
}

void GL_APIENTRY TexStorage2DMultisampleContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLboolean fixedsamplelocations)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage2DMultisample",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLboolean fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2DMultisample(context, targetPacked, samples, internalformat, width,
                                             height, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage2DMultisample, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, fixedsamplelocations);
    }
}

void GL_APIENTRY TexStorage3DContextANGLE(GLeglContext ctx,
                                          GLenum target,
                                          GLsizei levels,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage3D",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexStorage3D(context, targetPacked, levels, internalformat,
                                                 width, height, depth));
        if (isCallValid)
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE(TexStorage3D, isCallValid, context, targetPacked, levels, internalformat,
                      width, height, depth);
    }
}

void GL_APIENTRY TexStorage3DEXTContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLsizei levels,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage3DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexStorage3DEXT(context, targetPacked, levels, internalformat,
                                                    width, height, depth));
        if (isCallValid)
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE(TexStorage3DEXT, isCallValid, context, targetPacked, levels, internalformat,
                      width, height, depth);
    }
}

void GL_APIENTRY TexStorage3DMultisampleContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLsizei depth,
                                                     GLboolean fixedsamplelocations)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage3DMultisample",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLboolean "
          "fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage3DMultisample(context, targetPacked, samples, internalformat, width,
                                             height, depth, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage3DMultisample, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, depth, fixedsamplelocations);
    }
}

void GL_APIENTRY TexStorage3DMultisampleOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLsizei samples,
                                                        GLenum internalformat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLboolean fixedsamplelocations)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorage3DMultisampleOES",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLboolean "
          "fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage3DMultisampleOES(context, targetPacked, samples, internalformat,
                                                width, height, depth, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage3DMultisampleOES, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, depth, fixedsamplelocations);
    }
}

void GL_APIENTRY TexStorageMem2DEXTContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLsizei levels,
                                                GLenum internalFormat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLuint memory,
                                                GLuint64 offset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorageMem2DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLuint memory = %u, GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, memory,
          static_cast<unsigned long long>(offset));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMem2DEXT(context, targetPacked, levels, internalFormat, width,
                                        height, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem2D(targetPacked, levels, internalFormat, width, height,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem2DEXT, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, memoryPacked, offset);
    }
}

void GL_APIENTRY TexStorageMem2DMultisampleEXTContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLsizei samples,
                                                           GLenum internalFormat,
                                                           GLsizei width,
                                                           GLsizei height,
                                                           GLboolean fixedSampleLocations,
                                                           GLuint memory,
                                                           GLuint64 offset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorageMem2DMultisampleEXT",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLboolean fixedSampleLocations = %s, GLuint "
          "memory = %u, GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexStorageMem2DMultisampleEXT(
                                              context, targetPacked, samples, internalFormat, width,
                                              height, fixedSampleLocations, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem2DMultisample(targetPacked, samples, internalFormat, width,
                                                height, fixedSampleLocations, memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem2DMultisampleEXT, isCallValid, context, targetPacked, samples,
                      internalFormat, width, height, fixedSampleLocations, memoryPacked, offset);
    }
}

void GL_APIENTRY TexStorageMem3DEXTContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLsizei levels,
                                                GLenum internalFormat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLuint memory,
                                                GLuint64 offset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorageMem3DEXT",
          "context = %d, GLenum target = %s, GLsizei levels = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLuint memory = %u, "
          "GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth, memory,
          static_cast<unsigned long long>(offset));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMem3DEXT(context, targetPacked, levels, internalFormat, width,
                                        height, depth, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem3D(targetPacked, levels, internalFormat, width, height, depth,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem3DEXT, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, depth, memoryPacked, offset);
    }
}

void GL_APIENTRY TexStorageMem3DMultisampleEXTContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLsizei samples,
                                                           GLenum internalFormat,
                                                           GLsizei width,
                                                           GLsizei height,
                                                           GLsizei depth,
                                                           GLboolean fixedSampleLocations,
                                                           GLuint memory,
                                                           GLuint64 offset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexStorageMem3DMultisampleEXT",
          "context = %d, GLenum target = %s, GLsizei samples = %d, GLenum internalFormat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLboolean "
          "fixedSampleLocations = %s, GLuint memory = %u, GLuint64 offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                      = FromGL<TextureType>(target);
        MemoryObjectID memoryPacked                   = FromGL<MemoryObjectID>(memory);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexStorageMem3DMultisampleEXT(
                                context, targetPacked, samples, internalFormat, width, height,
                                depth, fixedSampleLocations, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem3DMultisample(targetPacked, samples, internalFormat, width,
                                                height, depth, fixedSampleLocations, memoryPacked,
                                                offset);
        }
        ANGLE_CAPTURE(TexStorageMem3DMultisampleEXT, isCallValid, context, targetPacked, samples,
                      internalFormat, width, height, depth, fixedSampleLocations, memoryPacked,
                      offset);
    }
}

void GL_APIENTRY TexSubImage2DContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLenum type,
                                           const void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexSubImage2D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLsizei width = %d, GLsizei height = %d, GLenum format = %s, GLenum type = %s, "
          "const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTexSubImage2D(context, targetPacked, level, xoffset, yoffset,
                                                  width, height, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage2D(targetPacked, level, xoffset, yoffset, width, height, format,
                                   type, pixels);
        }
        ANGLE_CAPTURE(TexSubImage2D, isCallValid, context, targetPacked, level, xoffset, yoffset,
                      width, height, format, type, pixels);
    }
}

void GL_APIENTRY TexSubImage3DContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint zoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLenum format,
                                           GLenum type,
                                           const void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexSubImage3D",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                   height, depth, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
        ANGLE_CAPTURE(TexSubImage3D, isCallValid, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, type, pixels);
    }
}

void GL_APIENTRY TexSubImage3DOESContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLenum type,
                                              const void *pixels)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTexSubImage3DOES",
          "context = %d, GLenum target = %s, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
          "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                    = FromGL<TextureTarget>(target);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset,
                                      width, height, depth, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
        ANGLE_CAPTURE(TexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, type, pixels);
    }
}

void GL_APIENTRY TransformFeedbackVaryingsContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLsizei count,
                                                       const GLchar *const *varyings,
                                                       GLenum bufferMode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTransformFeedbackVaryings",
          "context = %d, GLuint program = %u, GLsizei count = %d, const GLchar *const*varyings = "
          "0x%016" PRIxPTR ", GLenum bufferMode = %s",
          CID(context), program, count, (uintptr_t)varyings,
          GLenumToString(GLenumGroup::DefaultGroup, bufferMode));

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTransformFeedbackVaryings(
                                              context, programPacked, count, varyings, bufferMode));
        if (isCallValid)
        {
            context->transformFeedbackVaryings(programPacked, count, varyings, bufferMode);
        }
        ANGLE_CAPTURE(TransformFeedbackVaryings, isCallValid, context, programPacked, count,
                      varyings, bufferMode);
    }
}

void GL_APIENTRY TranslatefContextANGLE(GLeglContext ctx, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTranslatef", "context = %d, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f",
          CID(context), x, y, z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTranslatef(context, x, y, z));
        if (isCallValid)
        {
            context->translatef(x, y, z);
        }
        ANGLE_CAPTURE(Translatef, isCallValid, context, x, y, z);
    }
}

void GL_APIENTRY TranslatexContextANGLE(GLeglContext ctx, GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glTranslatex", "context = %d, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X",
          CID(context), x, y, z);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTranslatex(context, x, y, z));
        if (isCallValid)
        {
            context->translatex(x, y, z);
        }
        ANGLE_CAPTURE(Translatex, isCallValid, context, x, y, z);
    }
}

void GL_APIENTRY Uniform1fContextANGLE(GLeglContext ctx, GLint location, GLfloat v0)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform1f", "context = %d, GLint location = %d, GLfloat v0 = %f", CID(context),
          location, v0);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateUniform1f(context, location, v0));
        if (isCallValid)
        {
            context->uniform1f(location, v0);
        }
        ANGLE_CAPTURE(Uniform1f, isCallValid, context, location, v0);
    }
}

void GL_APIENTRY Uniform1fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform1fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform1fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform1fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform1iContextANGLE(GLeglContext ctx, GLint location, GLint v0)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform1i", "context = %d, GLint location = %d, GLint v0 = %d", CID(context), location,
          v0);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateUniform1i(context, location, v0));
        if (isCallValid)
        {
            context->uniform1i(location, v0);
        }
        ANGLE_CAPTURE(Uniform1i, isCallValid, context, location, v0);
    }
}

void GL_APIENTRY Uniform1ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glUniform1iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform1iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform1iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform1uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform1ui", "context = %d, GLint location = %d, GLuint v0 = %u", CID(context),
          location, v0);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateUniform1ui(context, location, v0));
        if (isCallValid)
        {
            context->uniform1ui(location, v0);
        }
        ANGLE_CAPTURE(Uniform1ui, isCallValid, context, location, v0);
    }
}

void GL_APIENTRY Uniform1uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform1uiv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLuint *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1uiv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform1uiv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform1uiv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform2fContextANGLE(GLeglContext ctx, GLint location, GLfloat v0, GLfloat v1)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform2f", "context = %d, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f",
          CID(context), location, v0, v1);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2f(context, location, v0, v1));
        if (isCallValid)
        {
            context->uniform2f(location, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2f, isCallValid, context, location, v0, v1);
    }
}

void GL_APIENTRY Uniform2fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform2fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform2fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform2fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform2iContextANGLE(GLeglContext ctx, GLint location, GLint v0, GLint v1)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform2i", "context = %d, GLint location = %d, GLint v0 = %d, GLint v1 = %d",
          CID(context), location, v0, v1);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2i(context, location, v0, v1));
        if (isCallValid)
        {
            context->uniform2i(location, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2i, isCallValid, context, location, v0, v1);
    }
}

void GL_APIENTRY Uniform2ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glUniform2iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform2iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform2iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform2uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0, GLuint v1)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform2ui", "context = %d, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u",
          CID(context), location, v0, v1);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2ui(context, location, v0, v1));
        if (isCallValid)
        {
            context->uniform2ui(location, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2ui, isCallValid, context, location, v0, v1);
    }
}

void GL_APIENTRY Uniform2uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform2uiv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLuint *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2uiv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform2uiv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform2uiv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY
Uniform3fContextANGLE(GLeglContext ctx, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform3f",
          "context = %d, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3f(context, location, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3f(location, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3f, isCallValid, context, location, v0, v1, v2);
    }
}

void GL_APIENTRY Uniform3fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform3fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform3fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform3fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY
Uniform3iContextANGLE(GLeglContext ctx, GLint location, GLint v0, GLint v1, GLint v2)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform3i",
          "context = %d, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3i(context, location, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3i(location, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3i, isCallValid, context, location, v0, v1, v2);
    }
}

void GL_APIENTRY Uniform3ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glUniform3iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform3iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform3iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY
Uniform3uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform3ui",
          "context = %d, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3ui(context, location, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3ui(location, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3ui, isCallValid, context, location, v0, v1, v2);
    }
}

void GL_APIENTRY Uniform3uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform3uiv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLuint *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3uiv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform3uiv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform3uiv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform4fContextANGLE(GLeglContext ctx,
                                       GLint location,
                                       GLfloat v0,
                                       GLfloat v1,
                                       GLfloat v2,
                                       GLfloat v3)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform4f",
          "context = %d, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f, "
          "GLfloat v3 = %f",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4f(context, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4f(location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4f, isCallValid, context, location, v0, v1, v2, v3);
    }
}

void GL_APIENTRY Uniform4fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform4fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform4fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform4fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY
Uniform4iContextANGLE(GLeglContext ctx, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform4i",
          "context = %d, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, GLint "
          "v3 = %d",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4i(context, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4i(location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4i, isCallValid, context, location, v0, v1, v2, v3);
    }
}

void GL_APIENTRY Uniform4ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        "glUniform4iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform4iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform4iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY
Uniform4uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform4ui",
          "context = %d, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u, "
          "GLuint v3 = %u",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4ui(context, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4ui(location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4ui, isCallValid, context, location, v0, v1, v2, v3);
    }
}

void GL_APIENTRY Uniform4uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniform4uiv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLuint *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4uiv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform4uiv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform4uiv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY UniformBlockBindingContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLuint uniformBlockIndex,
                                                 GLuint uniformBlockBinding)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniformBlockBinding",
          "context = %d, GLuint program = %u, GLuint uniformBlockIndex = %u, GLuint "
          "uniformBlockBinding = %u",
          CID(context), program, uniformBlockIndex, uniformBlockBinding);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateUniformBlockBinding(context, programPacked, uniformBlockIndex,
                                                        uniformBlockBinding));
        if (isCallValid)
        {
            context->uniformBlockBinding(programPacked, uniformBlockIndex, uniformBlockBinding);
        }
        ANGLE_CAPTURE(UniformBlockBinding, isCallValid, context, programPacked, uniformBlockIndex,
                      uniformBlockBinding);
    }
}

void GL_APIENTRY UniformMatrix2fvContextANGLE(GLeglContext ctx,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniformMatrix2fv",
          "context = %d, GLint location = %d, GLsizei count = %d, GLboolean transpose = %s, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateUniformMatrix2fv(context, location, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2fv(location, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2fv, isCallValid, context, location, count, transpose, value);
    }
}

void GL_APIENTRY UniformMatrix2x3fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT("glUniformMatrix2x3fv",
          "context = %d, GLint location = %d, GLsizei count = %d, GLboolean transpose = %s, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateUniformMatrix2x3fv(context, location, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x3fv(location, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2x3fv, isCallValid, context, location, count, transpose, value);
    }
}

void GL_APIENTRY UniformMatrix2x4fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);